/*
 * Decompiled with CFR 0.152.
 */
package y.io.gml;

import java.io.IOException;
import y.base.Edge;
import y.io.gml.GMLEncoder;
import y.io.gml.ObjectEncoder;
import y.view.EdgeRealizer;
import y.view.Graph2D;
import y.view.NodeRealizer;
import y.view.Port;

public class EdgeObjectEncoder
implements ObjectEncoder {
    private ObjectEncoder p;
    private ObjectEncoder q;

    public EdgeObjectEncoder() {
        this(null, null);
    }

    public EdgeObjectEncoder(ObjectEncoder objectEncoder, ObjectEncoder objectEncoder2) {
        this.p = objectEncoder;
        this.q = objectEncoder2;
    }

    public void encode(Object object, GMLEncoder gMLEncoder) throws IOException {
        Port port;
        Edge edge = (Edge)object;
        Graph2D graph2D = (Graph2D)edge.getGraph();
        EdgeRealizer edgeRealizer = graph2D.getRealizer(edge);
        gMLEncoder.addAttribute("source", edge.source().index());
        gMLEncoder.addAttribute("target", edge.target().index());
        if (edgeRealizer.labelCount() > 0) {
            gMLEncoder.addAttribute("label", edgeRealizer.getLabel(0).getText());
        }
        if (this.p != null) {
            gMLEncoder.beginSection("graphics");
            this.p.encode(edgeRealizer, gMLEncoder);
            gMLEncoder.endSection();
        }
        boolean bl = (port = edgeRealizer.getTargetPort()).getOffsetX() != 0.0 || port.getOffsetY() != 0.0;
        port = edgeRealizer.getSourcePort();
        if (bl |= port.getOffsetX() != 0.0 || port.getOffsetY() != 0.0) {
            NodeRealizer nodeRealizer = graph2D.getRealizer(edge.source());
            NodeRealizer nodeRealizer2 = graph2D.getRealizer(edge.target());
            gMLEncoder.beginSection("edgeAnchor");
            if (port.getOffsetX() != 0.0) {
                gMLEncoder.addAttribute("xSource", (float)(2.0 * port.getOffsetX() / nodeRealizer.getWidth()));
            }
            if (port.getOffsetY() != 0.0) {
                gMLEncoder.addAttribute("ySource", (float)(2.0 * port.getOffsetY() / nodeRealizer.getHeight()));
            }
            if ((port = edgeRealizer.getTargetPort()).getOffsetX() != 0.0) {
                gMLEncoder.addAttribute("xTarget", (float)(2.0 * port.getOffsetX() / nodeRealizer2.getWidth()));
            }
            if (port.getOffsetY() != 0.0) {
                gMLEncoder.addAttribute("yTarget", (float)(2.0 * port.getOffsetY() / nodeRealizer2.getHeight()));
            }
            gMLEncoder.endSection();
        }
    }

    public ObjectEncoder getLabelEncoder() {
        return this.q;
    }

    public void setLabelEncoder(ObjectEncoder objectEncoder) {
        this.q = objectEncoder;
    }

    public ObjectEncoder getRealizerEncoder() {
        return this.p;
    }

    public void setRealizerEncoder(ObjectEncoder objectEncoder) {
        this.p = objectEncoder;
    }
}

