/*
 * Decompiled with CFR 0.152.
 */
package y.io;

import java.awt.Color;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.net.URL;
import y.io.IOHandler;
import y.io.gml.DefaultHierarchicParserFactory;
import y.io.gml.EncoderFactory;
import y.io.gml.GMLEncoder;
import y.io.gml.GMLTokenizer;
import y.io.gml.HierarchicGraphEncoderFactory;
import y.io.gml.ObjectEncoder;
import y.io.gml.ParserFactory;
import y.util.D;
import y.view.Graph2D;

public class GMLIOHandler
extends IOHandler {
    private static ParserFactory g;
    private static EncoderFactory h;

    public String getFileFormatString() {
        return "GML Format";
    }

    public String getFileNameExtension() {
        return "gml";
    }

    public void read(Graph2D graph2D, InputStream inputStream) throws IOException {
        graph2D.firePreEvent();
        this.read(graph2D, new InputStreamReader(inputStream));
        graph2D.firePostEvent();
    }

    public void read(Graph2D graph2D, String string) throws IOException {
        graph2D.firePreEvent();
        URL uRL = graph2D.getURL();
        graph2D.setURL(new File(string).toURL());
        FileReader fileReader = new FileReader(string);
        try {
            try {
                this.read(graph2D, fileReader);
            }
            catch (IOException iOException) {
                graph2D.setURL(uRL);
                throw iOException;
            }
            Object var7_5 = null;
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            ((Reader)fileReader).close();
            graph2D.firePostEvent();
            throw throwable;
        }
        ((Reader)fileReader).close();
        graph2D.firePostEvent();
    }

    protected void read(Graph2D graph2D, Reader reader) throws IOException {
        GMLTokenizer.Callback callback = GMLIOHandler.getParserFactory().createGMLParser(graph2D);
        GMLTokenizer gMLTokenizer = new GMLTokenizer(callback);
        gMLTokenizer.parse(reader);
    }

    public static synchronized ParserFactory getParserFactory() {
        if (g == null) {
            g = new DefaultHierarchicParserFactory();
        }
        return g;
    }

    public static synchronized void setParserFactory(ParserFactory parserFactory) {
        g = parserFactory;
    }

    public static synchronized EncoderFactory getEncoderFactory() {
        if (h == null) {
            h = new HierarchicGraphEncoderFactory();
        }
        return h;
    }

    public static synchronized void setEncoderFactory(EncoderFactory encoderFactory) {
        h = encoderFactory;
    }

    public void write(Graph2D graph2D, OutputStream outputStream) throws IOException {
        PrintWriter printWriter = new PrintWriter(outputStream);
        GMLEncoder gMLEncoder = new GMLEncoder(printWriter);
        EncoderFactory encoderFactory = GMLIOHandler.getEncoderFactory();
        ObjectEncoder objectEncoder = encoderFactory.createGMLEncoder();
        D.bug(this, (Object)"saving in gml format....");
        objectEncoder.encode(graph2D, gMLEncoder);
        printWriter.flush();
    }

    public static String convertColor(Color color) {
        return "#" + Integer.toHexString(color.getRGB()).substring(2).toUpperCase();
    }
}

