/*
 * Decompiled with CFR 0.152.
 */
package y.geom;

import y.geom.YPoint;

public class YVector {
    private double b;
    private double a;

    public YVector(double d2, double d3) {
        this.b = d2;
        this.a = d3;
    }

    public YVector(YVector yVector) {
        this.b = yVector.getX();
        this.a = yVector.getY();
    }

    public YVector(YPoint yPoint, YPoint yPoint2) {
        this.b = yPoint.getX() - yPoint2.getX();
        this.a = yPoint.getY() - yPoint2.getY();
    }

    public YVector(YPoint yPoint) {
        this.b = yPoint.getX();
        this.a = yPoint.getY();
    }

    public YVector(double d2, double d3, double d4, double d5) {
        this.b = d2 - d4;
        this.a = d3 - d5;
    }

    public double getX() {
        return this.b;
    }

    public double getY() {
        return this.a;
    }

    public void norm() {
        if (this.b == 0.0 && this.a == 0.0) {
            return;
        }
        double d2 = this.length();
        this.b /= d2;
        this.a /= d2;
    }

    public void add(YVector yVector) {
        this.b += yVector.getX();
        this.a += yVector.getY();
    }

    public static YVector add(YVector yVector, YVector yVector2) {
        YVector yVector3 = new YVector(yVector);
        yVector3.add(yVector2);
        return yVector3;
    }

    public static YPoint add(YPoint yPoint, YVector yVector) {
        YPoint yPoint2 = new YPoint(yPoint.getX() + yVector.getX(), yPoint.getY() + yVector.getY());
        return yPoint2;
    }

    public void scale(double d2) {
        this.b *= d2;
        this.a *= d2;
    }

    public double length() {
        return Math.sqrt(this.b * this.b + this.a * this.a);
    }

    public static boolean rightOf(YVector yVector, YVector yVector2) {
        return yVector.getX() * yVector2.getY() - yVector.getY() * yVector2.getX() > 0.0;
    }

    public static YVector getNormal(YVector yVector) {
        YVector yVector2 = new YVector(yVector.getX(), yVector.getY());
        yVector2.norm();
        return yVector2;
    }

    public static YVector orthoNormal(YVector yVector) {
        double d2 = yVector.length();
        YVector yVector2 = new YVector(-yVector.getY() / d2, yVector.getX() / d2);
        return yVector2;
    }

    public static double scalarProduct(YVector yVector, YVector yVector2) {
        return yVector.getX() * yVector2.getX() + yVector.getY() * yVector2.getY();
    }

    public static double angle(YVector yVector, YVector yVector2) {
        double d2 = Math.acos(YVector.scalarProduct(yVector, yVector2) / (yVector.length() * yVector2.length()));
        if (!YVector.rightOf(yVector, yVector2)) {
            d2 = Math.PI * 2 - d2;
        }
        return d2;
    }

    public String toString() {
        return new String("X: " + this.getX() + " Y: " + this.getY());
    }
}

