/*
 * Decompiled with CFR 0.152.
 */
package y.geom;

import java.util.Iterator;
import java.util.Vector;
import y.base.YCursor;
import y.base.YList;
import y.geom.LineSegment;
import y.geom.YLineSegmentCursor;
import y.geom.YPoint;
import y.geom.YPointCursor;

public final class YPointPath {
    public static final YPointPath EMPTY_PATH = new YPointPath();
    YList a;

    public YPointPath() {
        this.a = new YList();
    }

    public YPointPath(Vector vector) {
        if (vector == null) {
            this.a = new YList();
        } else {
            this.a = new YList();
            int n = 0;
            while (n < vector.size()) {
                this.a.add(vector.elementAt(n));
                ++n;
            }
        }
    }

    public YPointPath(YPoint[] yPointArray) {
        this.a = yPointArray == null ? new YList() : new YList(yPointArray);
    }

    public YCursor cursor() {
        return this.a.cursor();
    }

    public YPointCursor points() {
        return new _a(this.a.cursor());
    }

    public Iterator iterator() {
        return this.a.iterator();
    }

    public YPoint getFirst() {
        return (YPoint)this.a.first();
    }

    public YPoint getLast() {
        return (YPoint)this.a.last();
    }

    public Vector toVector() {
        Vector<Object> vector = new Vector<Object>(this.a.size());
        YCursor yCursor = this.cursor();
        while (yCursor.ok()) {
            vector.addElement(yCursor.current());
            yCursor.next();
        }
        return vector;
    }

    public YPoint[] toArray() {
        YPoint[] yPointArray = new YPoint[this.a.size()];
        int n = 0;
        YCursor yCursor = this.cursor();
        while (yCursor.ok()) {
            yPointArray[n++] = (YPoint)yCursor.current();
            yCursor.next();
        }
        return yPointArray;
    }

    public YPointPath createReverse() {
        Vector<Object> vector = new Vector<Object>();
        YCursor yCursor = this.cursor();
        while (yCursor.ok()) {
            vector.insertElementAt(yCursor.current(), 0);
            yCursor.next();
        }
        return new YPointPath(vector);
    }

    public int length() {
        return this.a.size();
    }

    public YLineSegmentCursor lineSegments() {
        return new _if(this.points());
    }

    public LineSegment getLineSegment(int n) {
        if (n + 1 > this.a.size()) {
            return null;
        }
        YPoint yPoint = (YPoint)this.a.elementAt(n);
        YPoint yPoint2 = (YPoint)this.a.elementAt(n + 1);
        if (yPoint == null || yPoint2 == null) {
            return null;
        }
        return new LineSegment(yPoint, yPoint2);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("YPointPath:\n");
        YCursor yCursor = this.cursor();
        while (yCursor.ok()) {
            YPoint yPoint = (YPoint)yCursor.current();
            stringBuffer.append(yPoint.toString() + "\n");
            yCursor.next();
        }
        return stringBuffer.toString();
    }

    class _if
    implements YLineSegmentCursor {
        YPointCursor t;
        YPoint s = null;

        _if(YPointCursor yPointCursor) {
            this.t = yPointCursor;
            if (this.t.ok()) {
                this.s = this.t.point();
                this.t.next();
            }
        }

        public boolean ok() {
            return this.t.ok();
        }

        public void next() {
            this.s = this.t.point();
            this.t.next();
        }

        public void prev() {
            throw new UnsupportedOperationException();
        }

        public void toFirst() {
            this.t.toFirst();
            if (this.t.ok()) {
                this.s = this.t.point();
                this.t.next();
            }
        }

        public void toLast() {
            this.t.toLast();
            this.t.prev();
            if (this.t.ok()) {
                this.s = this.t.point();
                this.t.next();
            }
        }

        public Object current() {
            return this.lineSegment();
        }

        public LineSegment lineSegment() {
            YPoint yPoint = this.t.point();
            if (this.s == null || yPoint == null) {
                throw new NullPointerException();
            }
            return new LineSegment(this.s, yPoint);
        }

        public int size() {
            if (this.t.size() < 2) {
                return 0;
            }
            return this.t.size() - 1;
        }
    }

    class _a
    implements YPointCursor {
        YCursor u;

        _a(YCursor yCursor) {
            this.u = yCursor;
        }

        public boolean ok() {
            return this.u.ok();
        }

        public void next() {
            this.u.next();
        }

        public void prev() {
            this.u.prev();
        }

        public void toFirst() {
            this.u.toFirst();
        }

        public void toLast() {
            this.u.toLast();
        }

        public Object current() {
            return this.u.current();
        }

        public int size() {
            return this.u.size();
        }

        public YPoint point() {
            return (YPoint)this.u.current();
        }
    }
}

