/*
 * Decompiled with CFR 0.152.
 */
package y.geom;

import java.util.Comparator;
import y.base.DataProvider;
import y.base.Edge;
import y.base.EdgeCursor;
import y.base.EdgeList;
import y.base.EdgeMap;
import y.base.Graph;
import y.base.Node;
import y.base.NodeList;
import y.base.NodeMap;
import y.base.YCursor;
import y.base.YList;
import y.geom.Geom;
import y.geom.YPoint;
import y.util.D;

public class Triangulator {
    public static Edge triangulatePoints(Graph graph, DataProvider dataProvider, EdgeMap edgeMap) {
        EdgeCursor edgeCursor = graph.edges();
        while (edgeCursor.ok()) {
            graph.removeEdge(edgeCursor.edge());
            edgeCursor.next();
        }
        final DataProvider dataProvider2 = dataProvider;
        NodeList nodeList = new NodeList(graph.nodes());
        nodeList.sort(new Comparator(){

            public int compare(Object object, Object object2) {
                return ((YPoint)dataProvider2.get(object)).compareTo(dataProvider2.get(object2));
            }
        });
        return Triangulator.a(graph, nodeList, dataProvider, edgeMap);
    }

    public static Edge triangulatePoints(YList yList, Graph graph, NodeMap nodeMap, EdgeMap edgeMap) {
        graph.clear();
        yList = new YList(yList.cursor());
        yList.sort();
        YCursor yCursor = yList.cursor();
        while (yCursor.ok()) {
            nodeMap.set(graph.createNode(), yCursor.current());
            yCursor.next();
        }
        return Triangulator.a(graph, new NodeList(graph.nodes()), nodeMap, edgeMap);
    }

    public static Edge calcDelauneyTriangulation(Graph graph, DataProvider dataProvider, EdgeMap edgeMap) {
        Edge edge;
        boolean bl = false;
        if (edgeMap == null) {
            graph.createEdgeMap();
            bl = true;
        }
        if ((edge = Triangulator.triangulatePoints(graph, dataProvider, edgeMap)) != null) {
            Triangulator.a(graph, dataProvider, edgeMap, edge);
        }
        if (bl) {
            graph.disposeEdgeMap(edgeMap);
        }
        return edge;
    }

    private static int a(Graph graph, DataProvider dataProvider, EdgeMap edgeMap, Edge edge) {
        if (graph.nodeCount() <= 3) {
            return 0;
        }
        boolean[] blArray = new boolean[graph.edgeCount()];
        Edge edge2 = edge;
        do {
            blArray[edge2.index()] = true;
        } while (edge != (edge2 = Triangulator.b(edge2, edgeMap)));
        EdgeList edgeList = new EdgeList(graph.edges());
        int n = 0;
        while (!edgeList.isEmpty()) {
            Edge edge3 = edgeList.popEdge();
            Edge edge4 = (Edge)edgeMap.get(edge3);
            if (blArray[edge3.index()] || blArray[edge4.index()]) continue;
            Edge edge5 = Triangulator.b(edge4, edgeMap);
            Edge edge6 = Triangulator.b(edge3, edgeMap);
            YPoint yPoint = (YPoint)dataProvider.get(edge5.source());
            YPoint yPoint2 = (YPoint)dataProvider.get(edge5.target());
            YPoint yPoint3 = (YPoint)dataProvider.get(edge6.source());
            YPoint yPoint4 = (YPoint)dataProvider.get(edge6.target());
            if (!Geom.leftTurn(yPoint4, yPoint, yPoint2) || !Geom.leftTurn(yPoint2, yPoint3, yPoint4)) continue;
            int n2 = Geom.sideOfCircle(yPoint, yPoint2, yPoint3, yPoint4);
            if (n2 == 0) {
                // empty if block
            }
            if (n2 <= 0) continue;
            Edge edge7 = Triangulator.b(edge5, edgeMap);
            Edge edge8 = Triangulator.b(edge6, edgeMap);
            edgeList.push(edge5);
            edgeList.push(edge7);
            edgeList.push(edge6);
            edgeList.push(edge8);
            graph.changeEdge(edge3, edge7, edge6, 0, 0);
            graph.changeEdge(edge4, edge8, edge5, 0, 0);
            ++n;
        }
        return n;
    }

    private static Edge a(Graph graph, NodeList nodeList, DataProvider dataProvider, EdgeMap edgeMap) {
        Object object;
        Edge edge;
        Object object2;
        Graph graph2 = graph;
        NodeList nodeList2 = nodeList;
        if (graph.isEmpty()) {
            return null;
        }
        boolean bl = false;
        if (edgeMap == null) {
            edgeMap = graph2.createEdgeMap();
            bl = true;
        }
        Object object3 = nodeList2.popNode();
        Object object4 = (YPoint)dataProvider.get(object3);
        while (!nodeList2.isEmpty() && ((YPoint)object4).equals(dataProvider.get(nodeList2.first()))) {
            nodeList2.pop();
        }
        if (!nodeList2.isEmpty()) {
            object2 = nodeList2.popNode();
            object4 = (YPoint)dataProvider.get(object2);
            edge = graph2.createEdge((Node)object3, (Node)object2);
            object = graph2.createEdge((Node)object2, (Node)object3);
            edgeMap.set(edge, object);
            edgeMap.set(object, edge);
            object3 = object2;
        }
        object2 = nodeList2.nodes();
        while (object2.ok()) {
            edge = ((Node)object3).lastOutEdge();
            object3 = object2.node();
            object = (YPoint)dataProvider.get(object3);
            if (((YPoint)object).equals(object4)) {
                D.bug("PRECONDITION VIOLATED! Identical points given to Triangulator!");
            } else {
                Edge edge2;
                object4 = object;
                while (Triangulator.a((YPoint)object, edge = Triangulator.a(edge, edgeMap), dataProvider)) {
                }
                do {
                    edge2 = Triangulator.b(edge, edgeMap);
                    Edge edge3 = graph2.createEdge(edge2.source(), edge2, (Node)object3, null, 0, 0);
                    Edge edge4 = graph2.createEdge((Node)object3, edge2.source());
                    edgeMap.set(edge3, edge4);
                    edgeMap.set(edge4, edge3);
                } while (Triangulator.a((YPoint)object, edge = edge2, dataProvider));
            }
            object2.next();
        }
        if (bl) {
            graph2.disposeEdgeMap(edgeMap);
        }
        if (graph2.edgeCount() == 0) {
            return null;
        }
        return graph2.lastEdge();
    }

    private static Edge a(Edge edge, DataProvider dataProvider) {
        Edge edge2 = edge.nextOutEdge();
        if (edge2 == null) {
            edge2 = edge.source().firstOutEdge();
        }
        return (Edge)dataProvider.get(edge2);
    }

    private static Edge b(Edge edge, DataProvider dataProvider) {
        Edge edge2 = (Edge)dataProvider.get(edge);
        Edge edge3 = edge2.prevOutEdge();
        return edge3 == null ? edge2.source().lastOutEdge() : edge3;
    }

    private static boolean a(YPoint yPoint, Edge edge, DataProvider dataProvider) {
        return Geom.orientation(yPoint, (YPoint)dataProvider.get(edge.source()), (YPoint)dataProvider.get(edge.target())) > 0;
    }
}

