/*
 * Decompiled with CFR 0.152.
 */
package y.algo;

import java.util.Arrays;
import y.algo.case;
import y.base.DataProvider;
import y.base.Edge;
import y.base.EdgeCursor;
import y.base.EdgeList;
import y.base.Graph;
import y.base.Node;
import y.base.NodeCursor;
import y.base.if;
import y.util.Comparators;
import y.util.pq.BHeapDoubleNodePQ;

public class SpanningTrees {
    public static EdgeList minimum(Graph graph, DataProvider dataProvider) {
        return SpanningTrees.prim(graph, dataProvider);
    }

    public static EdgeList kruskal(Graph graph, DataProvider dataProvider) {
        EdgeList edgeList = new EdgeList();
        case case_ = new case(graph);
        int n = graph.N();
        int n2 = graph.E();
        EdgeList edgeList2 = new EdgeList(graph.edges());
        SpanningTrees.a(edgeList2, dataProvider, case_, edgeList);
        return edgeList;
    }

    private static void a(EdgeList edgeList, DataProvider dataProvider, case case_, EdgeList edgeList2) {
        edgeList.sort(Comparators.createDoubleDataComparator(dataProvider));
        EdgeCursor edgeCursor = edgeList.edges();
        while (edgeCursor.ok()) {
            Node node;
            Edge edge = edgeCursor.edge();
            Node node2 = edge.source();
            if (!case_.a(node2, node = edge.target())) {
                edgeList2.add(edge);
                case_.b(node2, node);
            }
            edgeCursor.next();
        }
    }

    public static EdgeList prim(Graph graph, DataProvider dataProvider) {
        EdgeList edgeList = new EdgeList();
        BHeapDoubleNodePQ bHeapDoubleNodePQ = new BHeapDoubleNodePQ(graph);
        double[] dArray = new double[graph.N()];
        Arrays.fill(dArray, Double.POSITIVE_INFINITY);
        Edge[] edgeArray = new Edge[graph.N()];
        NodeCursor nodeCursor = graph.nodes();
        while (nodeCursor.ok()) {
            bHeapDoubleNodePQ.add(nodeCursor.node(), Double.POSITIVE_INFINITY);
            nodeCursor.next();
        }
        while (!bHeapDoubleNodePQ.isEmpty()) {
            if if_;
            Node node = bHeapDoubleNodePQ.removeMin();
            int n = node.index();
            if (dArray[n] != Double.POSITIVE_INFINITY) {
                edgeList.add(edgeArray[n]);
            }
            dArray[n] = Double.NEGATIVE_INFINITY;
            Edge edge = node.firstOutEdge();
            while (edge != null) {
                if_ = edge.target();
                int n2 = ((Node)if_).index();
                double d2 = dataProvider.getDouble(edge);
                if (d2 < dArray[n2]) {
                    bHeapDoubleNodePQ.decreasePriority((Node)if_, d2);
                    dArray[n2] = d2;
                    edgeArray[n2] = edge;
                }
                edge = edge.nextOutEdge();
            }
            if_ = node.firstInEdge();
            while (if_ != null) {
                Node node2 = ((Edge)if_).source();
                int n3 = node2.index();
                double d3 = dataProvider.getDouble(if_);
                if (d3 < dArray[n3]) {
                    bHeapDoubleNodePQ.decreasePriority(node2, d3);
                    dArray[n3] = d3;
                    edgeArray[n3] = if_;
                }
                if_ = ((Edge)if_).nextInEdge();
            }
        }
        return edgeList;
    }

    public static EdgeList uniform(Graph graph) {
        EdgeList edgeList = new EdgeList();
        case case_ = new case(graph);
        EdgeCursor edgeCursor = graph.edges();
        while (edgeCursor.ok()) {
            Node node;
            Edge edge = edgeCursor.edge();
            Node node2 = edge.source();
            if (!case_.a(node2, node = edge.target())) {
                edgeList.add(edge);
                case_.b(node2, node);
            }
            edgeCursor.next();
        }
        return edgeList;
    }

    public static double cost(EdgeList edgeList, DataProvider dataProvider) {
        double d2 = 0.0;
        EdgeCursor edgeCursor = edgeList.edges();
        while (edgeCursor.ok()) {
            d2 += dataProvider.getDouble(edgeCursor.edge());
            edgeCursor.next();
        }
        return d2;
    }
}

