/*
 * Decompiled with CFR 0.152.
 */
package y.algo;

import y.algo.GraphConnectivity;
import y.algo.NodeOrders;
import y.base.DataProvider;
import y.base.Edge;
import y.base.EdgeCursor;
import y.base.EdgeList;
import y.base.Graph;
import y.base.Node;
import y.base.NodeCursor;
import y.base.NodeList;
import y.base.NodeMap;
import y.base.if;
import y.util.BoundedQueue;
import y.util.DataProviders;
import y.util.pq.BHeapDoubleNodePQ;
import y.util.pq.DoubleNodePQ;

public class ShortestPaths {
    private ShortestPaths() {
    }

    public static void uniform(Graph graph, Node node, boolean bl, double[] dArray) {
        ShortestPaths.uniform(graph, node, bl, dArray, new Edge[graph.N()]);
    }

    public static void uniform(Graph graph, Node node, boolean bl, double[] dArray, Edge[] edgeArray) {
        int n = graph.N();
        BoundedQueue boundedQueue = new BoundedQueue(n + 1);
        boolean[] blArray = new boolean[n];
        int n2 = 0;
        while (n2 < n) {
            edgeArray[n2] = null;
            dArray[n2] = Double.POSITIVE_INFINITY;
            ++n2;
        }
        dArray[node.index()] = 0.0;
        edgeArray[node.index()] = graph.firstEdge();
        boundedQueue.append(node);
        while (!boundedQueue.isEmpty()) {
            Node node2 = (Node)boundedQueue.pop();
            double d2 = dArray[node2.index()] + 1.0;
            Edge edge = node2.firstOutEdge();
            while (edge != null) {
                int n3 = edge.target().index();
                if (edgeArray[n3] == null) {
                    edgeArray[n3] = edge;
                    dArray[n3] = d2;
                    boundedQueue.append(edge.target());
                }
                edge = edge.nextOutEdge();
            }
            if (bl) continue;
            Edge edge2 = node2.firstInEdge();
            while (edge2 != null) {
                int n4 = edge2.source().index();
                if (edgeArray[n4] == null) {
                    edgeArray[n4] = edge2;
                    dArray[n4] = d2;
                    boundedQueue.append(edge2.source());
                }
                edge2 = edge2.nextInEdge();
            }
        }
        edgeArray[node.index()] = null;
    }

    public static void uniform(Graph graph, Node node, boolean bl, NodeMap nodeMap, NodeMap nodeMap2) {
        double[] dArray = ShortestPaths.b(graph);
        Edge[] edgeArray = ShortestPaths.a(graph);
        ShortestPaths.uniform(graph, node, bl, dArray, edgeArray);
        ShortestPaths.a(graph, dArray, nodeMap);
        ShortestPaths.a(graph, edgeArray, nodeMap2);
    }

    public static boolean acyclic(Graph graph, Node node, double[] dArray, double[] dArray2) {
        return ShortestPaths.acyclic(graph, node, dArray, dArray2, new Edge[graph.N()]);
    }

    public static boolean acyclic(Graph graph, Node node, double[] dArray, double[] dArray2, Edge[] edgeArray) {
        int n = graph.N();
        int[] nArray = new int[n];
        if (!NodeOrders.topological(graph, nArray)) {
            return false;
        }
        Node[] nodeArray = new Node[n];
        NodeCursor nodeCursor = graph.nodes();
        while (nodeCursor.ok()) {
            Node node2;
            nodeArray[nArray[node2.index()]] = node2 = nodeCursor.node();
            nodeCursor.next();
        }
        int n2 = 0;
        while (n2 < n) {
            dArray2[n2] = Double.POSITIVE_INFINITY;
            edgeArray[n2] = null;
            ++n2;
        }
        dArray2[node.index()] = 0.0;
        edgeArray[node.index()] = graph.E() == 0 ? null : graph.firstEdge();
        int n3 = 0;
        while (n3 < n) {
            Node node3 = nodeArray[n3];
            int n4 = node3.index();
            if (edgeArray[n4] != null) {
                double d2 = dArray2[n4];
                Edge edge = node3.firstOutEdge();
                while (edge != null) {
                    int n5 = edge.index();
                    int n6 = edge.target().index();
                    if (edgeArray[n6] == null || d2 + dArray[n5] < dArray2[n6]) {
                        edgeArray[n6] = edge;
                        dArray2[n6] = d2 + dArray[n5];
                    }
                    edge = edge.nextOutEdge();
                }
            }
            ++n3;
        }
        edgeArray[node.index()] = null;
        return true;
    }

    public static boolean acyclic(Graph graph, Node node, DataProvider dataProvider, NodeMap nodeMap, NodeMap nodeMap2) {
        double[] dArray = ShortestPaths.a(graph, dataProvider);
        double[] dArray2 = ShortestPaths.b(graph);
        Edge[] edgeArray = ShortestPaths.a(graph);
        boolean bl = ShortestPaths.acyclic(graph, node, dArray, dArray2, edgeArray);
        ShortestPaths.a(graph, dArray2, nodeMap);
        ShortestPaths.a(graph, edgeArray, nodeMap2);
        return bl;
    }

    public static void dijkstra(Graph graph, Node node, boolean bl, double[] dArray, double[] dArray2) {
        ShortestPaths.dijkstra(graph, node, bl, dArray, dArray2, new Edge[graph.N()]);
    }

    public static void dijkstra(Graph graph, Node node, boolean bl, double[] dArray, double[] dArray2, Edge[] edgeArray) {
        BHeapDoubleNodePQ bHeapDoubleNodePQ = new BHeapDoubleNodePQ(graph);
        int n = graph.N();
        int n2 = 0;
        while (n2 < n) {
            edgeArray[n2] = null;
            dArray2[n2] = Double.POSITIVE_INFINITY;
            ++n2;
        }
        dArray2[node.index()] = 0.0;
        bHeapDoubleNodePQ.add(node, 0.0);
        while (!bHeapDoubleNodePQ.isEmpty()) {
            if if_;
            Node node2 = bHeapDoubleNodePQ.removeMin();
            int n3 = node2.index();
            double d2 = dArray2[n3];
            Edge edge = node2.firstOutEdge();
            while (edge != null) {
                block10: {
                    block9: {
                        double d3;
                        int n4;
                        block8: {
                            if_ = edge.target();
                            n4 = ((Node)if_).index();
                            d3 = d2 + dArray[edge.index()];
                            if (edgeArray[n4] != null || if_ == node) break block8;
                            dArray2[n4] = d3;
                            bHeapDoubleNodePQ.add((Node)if_, d3);
                            break block9;
                        }
                        if (!(d3 < dArray2[n4])) break block10;
                        dArray2[n4] = d3;
                        bHeapDoubleNodePQ.decreasePriority((Node)if_, d3);
                    }
                    edgeArray[n4] = edge;
                }
                edge = edge.nextOutEdge();
            }
            if (bl) continue;
            if_ = node2.firstInEdge();
            while (if_ != null) {
                block13: {
                    block12: {
                        double d4;
                        int n5;
                        Node node3;
                        block11: {
                            node3 = ((Edge)if_).source();
                            n5 = node3.index();
                            d4 = d2 + dArray[((Edge)if_).index()];
                            if (edgeArray[n5] != null || node3 == node) break block11;
                            dArray2[n5] = d4;
                            bHeapDoubleNodePQ.add(node3, d4);
                            break block12;
                        }
                        if (!(d4 < dArray2[n5])) break block13;
                        dArray2[n5] = d4;
                        bHeapDoubleNodePQ.decreasePriority(node3, d4);
                    }
                    edgeArray[n5] = if_;
                }
                if_ = ((Edge)if_).nextInEdge();
            }
        }
    }

    public static void dijkstra(Graph graph, Node node, boolean bl, DataProvider dataProvider, NodeMap nodeMap, NodeMap nodeMap2) {
        double[] dArray = ShortestPaths.a(graph, dataProvider);
        double[] dArray2 = ShortestPaths.b(graph);
        Edge[] edgeArray = ShortestPaths.a(graph);
        ShortestPaths.dijkstra(graph, node, bl, dArray, dArray2, edgeArray);
        ShortestPaths.a(graph, dArray2, nodeMap);
        ShortestPaths.a(graph, edgeArray, nodeMap2);
    }

    public static double singleSourceSingleSink(Graph graph, Node node, Node node2, boolean bl, double[] dArray, Edge[] edgeArray) {
        return ShortestPaths.a(graph, node, node2, bl, dArray, edgeArray);
    }

    public static EdgeList singleSourceSingleSink(Graph graph, Node node, Node node2, boolean bl, double[] dArray) {
        Edge[] edgeArray = new Edge[graph.N()];
        if (ShortestPaths.singleSourceSingleSink(graph, node, node2, bl, dArray, edgeArray) != Double.POSITIVE_INFINITY) {
            return ShortestPaths.constructEdgePath(node, node2, edgeArray);
        }
        return new EdgeList();
    }

    public static EdgeList singleSourceSingleSink(Graph graph, Node node, Node node2, boolean bl, DataProvider dataProvider) {
        double[] dArray = ShortestPaths.a(graph, dataProvider);
        return ShortestPaths.singleSourceSingleSink(graph, node, node2, bl, dArray);
    }

    public static double singleSourceSingleSink(Graph graph, Node node, Node node2, boolean bl, DataProvider dataProvider, NodeMap nodeMap) {
        double[] dArray = ShortestPaths.a(graph, dataProvider);
        Edge[] edgeArray = ShortestPaths.a(graph);
        double d2 = ShortestPaths.a(graph, node, node2, bl, dArray, edgeArray);
        ShortestPaths.a(graph, edgeArray, nodeMap);
        return d2;
    }

    private static double a(Graph graph, Node node, Node node2, boolean bl, double[] dArray, Edge[] edgeArray) {
        Node[] nodeArray = new Node[]{node, node2};
        double[][] dArray2 = new double[2][graph.N()];
        Edge[][] edgeArray2 = new Edge[2][graph.E()];
        DoubleNodePQ[] doubleNodePQArray = new DoubleNodePQ[]{new BHeapDoubleNodePQ(graph), new BHeapDoubleNodePQ(graph)};
        doubleNodePQArray[0].add(nodeArray[0], 0.0);
        doubleNodePQArray[1].add(nodeArray[1], 0.0);
        boolean bl2 = node != node2;
        double d2 = 0.0;
        while (!doubleNodePQArray[0].isEmpty() || !doubleNodePQArray[1].isEmpty()) {
            int n = 0;
            while (n < 2) {
                if (!doubleNodePQArray[n].isEmpty()) {
                    Object object;
                    Node node3 = doubleNodePQArray[n].removeMin();
                    int n2 = node3.index();
                    if (!(node3 != nodeArray[1 - n] && edgeArray2[1 - n][n2] == null || doubleNodePQArray[1 - n].contains(node3) || dArray2[0][n2] + dArray2[1][n2] != d2)) {
                        Edge edge;
                        object = node3;
                        int n3 = ((Node)object).index();
                        while (object != node) {
                            edgeArray[n3] = edgeArray2[0][n3];
                            object = edgeArray[n3].opposite((Node)object);
                            n3 = ((Node)object).index();
                        }
                        object = node3;
                        n3 = ((Node)object).index();
                        while ((edge = edgeArray2[1][n3]) != null) {
                            object = edge.opposite((Node)object);
                            n3 = ((Node)object).index();
                            edgeArray[n3] = edge;
                        }
                        return d2;
                    }
                    object = bl ? (n == 0 ? node3.outEdges() : node3.inEdges()) : node3.edges();
                    while (object.ok()) {
                        Edge edge = object.edge();
                        int n4 = edge.index();
                        Node node4 = edge.opposite(node3);
                        int n5 = node4.index();
                        double d3 = dArray2[n][n2] + dArray[n4];
                        if (edgeArray2[n][n5] == null && node4 != nodeArray[n]) {
                            dArray2[n][n5] = d3;
                            doubleNodePQArray[n].add(node4, d3);
                        } else if (d3 < dArray2[n][n5]) {
                            doubleNodePQArray[n].decreasePriority(node4, d3);
                            dArray2[n][n5] = d3;
                        } else {
                            object.next();
                            continue;
                        }
                        edgeArray2[n][n5] = edge;
                        if ((node4 == nodeArray[1 - n] || edgeArray2[1 - n][n5] != null) && (bl2 || dArray2[0][n5] + dArray2[1][n5] < d2)) {
                            bl2 = false;
                            d2 = dArray2[0][n5] + dArray2[1][n5];
                        }
                        object.next();
                    }
                }
                ++n;
            }
        }
        edgeArray[node2.index()] = null;
        return Double.POSITIVE_INFINITY;
    }

    public static boolean bellmanFord(Graph graph, Node node, boolean bl, double[] dArray, double[] dArray2) {
        return ShortestPaths.bellmanFord(graph, node, bl, dArray, dArray2, new Edge[graph.N()]);
    }

    public static boolean bellmanFord(Graph graph, Node node, boolean bl, double[] dArray, double[] dArray2, Edge[] edgeArray) {
        Object object;
        int n;
        Node node2;
        Edge edge;
        int n2 = graph.N();
        int n3 = 0;
        BoundedQueue boundedQueue = new BoundedQueue(n2 + 1);
        boolean[] blArray = new boolean[n2];
        int n4 = 0;
        while (n4 < n2) {
            edgeArray[n4] = null;
            dArray2[n4] = Double.POSITIVE_INFINITY;
            ++n4;
        }
        dArray2[node.index()] = 0.0;
        boundedQueue.append(node);
        blArray[node.index()] = true;
        boundedQueue.append(null);
        while (n3 < n2) {
            double d2;
            Node node3 = (Node)boundedQueue.pop();
            if (node3 == null) {
                ++n3;
                if (boundedQueue.isEmpty()) {
                    return true;
                }
                boundedQueue.append(null);
                continue;
            }
            int n5 = node3.index();
            blArray[n5] = false;
            double d3 = dArray2[n5];
            edge = node3.firstOutEdge();
            while (edge != null) {
                node2 = edge.target();
                n = node2.index();
                d2 = d3 + dArray[edge.index()];
                if (edgeArray[n] == null && node2 != node || d2 < dArray2[n]) {
                    dArray2[n] = d2;
                    edgeArray[n] = edge;
                    if (!blArray[n]) {
                        boundedQueue.append(node2);
                        blArray[n] = true;
                    }
                }
                edge = edge.nextOutEdge();
            }
            if (bl) continue;
            edge = node3.firstInEdge();
            while (edge != null) {
                node2 = edge.source();
                n = node2.index();
                d2 = d3 + dArray[edge.index()];
                if (edgeArray[n] == null && node2 != node || d2 < dArray2[n]) {
                    dArray2[n] = d2;
                    edgeArray[n] = edge;
                    if (!blArray[n]) {
                        boundedQueue.append(node2);
                        blArray[n] = true;
                    }
                }
                edge = edge.nextInEdge();
            }
        }
        if (edgeArray[node.index()] != null) {
            return false;
        }
        boolean[] blArray2 = new boolean[graph.N()];
        boolean[] blArray3 = new boolean[graph.E()];
        EdgeCursor edgeCursor = graph.edges();
        while (edgeCursor.ok()) {
            edge = edgeCursor.edge();
            if (edge != edgeArray[edge.target().index()]) {
                blArray3[edge.index()] = true;
            }
            edgeCursor.next();
        }
        if (!bl) {
            object = graph.edges();
            while (object.ok()) {
                edge = object.edge();
                if (edge != edgeArray[edge.source().index()]) {
                    blArray3[edge.index()] = true;
                }
                object.next();
            }
        }
        GraphConnectivity.reachable(graph, node, bl, blArray3, blArray2);
        object = new boolean[graph.N()];
        NodeCursor nodeCursor = graph.nodes();
        while (nodeCursor.ok()) {
            node2 = nodeCursor.node();
            n = node2.index();
            if (blArray[n] && object[n] == false) {
                ShortestPaths.a(graph, node2, bl, blArray2, (boolean[])object, edgeArray);
            }
            nodeCursor.next();
        }
        return false;
    }

    public static boolean bellmanFord(Graph graph, Node node, boolean bl, DataProvider dataProvider, NodeMap nodeMap, NodeMap nodeMap2) {
        double[] dArray = ShortestPaths.a(graph, dataProvider);
        double[] dArray2 = ShortestPaths.b(graph);
        Edge[] edgeArray = ShortestPaths.a(graph);
        boolean bl2 = ShortestPaths.bellmanFord(graph, node, bl, dArray, dArray2, edgeArray);
        ShortestPaths.a(graph, dArray2, nodeMap);
        ShortestPaths.a(graph, edgeArray, nodeMap2);
        return bl2;
    }

    private static void a(Graph graph, Node node, boolean bl, boolean[] blArray, boolean[] blArray2, Edge[] edgeArray) {
        if if_;
        blArray2[node.index()] = true;
        Edge edge = node.firstOutEdge();
        while (edge != null) {
            if_ = edge.target();
            int n = ((Node)if_).index();
            if (!blArray2[n]) {
                if (blArray[n]) {
                    edgeArray[n] = edge;
                }
                ShortestPaths.a(graph, (Node)if_, bl, blArray, blArray2, edgeArray);
            }
            edge = edge.nextOutEdge();
        }
        if (!bl) {
            if_ = node.firstInEdge();
            while (if_ != null) {
                Node node2 = ((Edge)if_).source();
                int n = node2.index();
                if (!blArray2[n]) {
                    if (blArray[n]) {
                        edgeArray[n] = if_;
                    }
                    ShortestPaths.a(graph, node2, bl, blArray, blArray2, edgeArray);
                }
                if_ = ((Edge)if_).nextInEdge();
            }
        }
    }

    public static boolean singleSource(Graph graph, Node node, boolean bl, double[] dArray, double[] dArray2) {
        return ShortestPaths.singleSource(graph, node, bl, dArray, dArray2, new Edge[graph.N()]);
    }

    public static boolean singleSource(Graph graph, Node node, boolean bl, double[] dArray, double[] dArray2, Edge[] edgeArray) {
        if (bl && ShortestPaths.acyclic(graph, node, dArray, dArray2, edgeArray)) {
            return true;
        }
        boolean bl2 = true;
        EdgeCursor edgeCursor = graph.edges();
        while (edgeCursor.ok()) {
            if (dArray[edgeCursor.edge().index()] < 0.0) {
                bl2 = false;
                break;
            }
            edgeCursor.next();
        }
        if (bl2) {
            ShortestPaths.dijkstra(graph, node, bl, dArray, dArray2, edgeArray);
            return true;
        }
        return ShortestPaths.bellmanFord(graph, node, bl, dArray, dArray2, edgeArray);
    }

    public static boolean singleSource(Graph graph, Node node, boolean bl, DataProvider dataProvider, NodeMap nodeMap, NodeMap nodeMap2) {
        double[] dArray = ShortestPaths.a(graph, dataProvider);
        double[] dArray2 = ShortestPaths.b(graph);
        Edge[] edgeArray = ShortestPaths.a(graph);
        boolean bl2 = ShortestPaths.singleSource(graph, node, bl, dArray, dArray2, edgeArray);
        ShortestPaths.a(graph, dArray2, nodeMap);
        ShortestPaths.a(graph, edgeArray, nodeMap2);
        return bl2;
    }

    /*
     * Unable to fully structure code
     */
    public static boolean allPairs(Graph var0, boolean var1_1, double[] var2_2, double[][] var3_3) {
        var4_4 = var0.createNode();
        var5_5 = new EdgeList();
        var6_6 = var0.nodes();
        while (var6_6.ok()) {
            var7_7 = var6_6.node();
            if (var7_7 != var4_4) {
                var5_5.push(var0.createEdge(var4_4, (Node)var7_7));
            }
            var6_6.next();
        }
        var7_7 = new double[var0.E()];
        var8_8 = new double[var0.N()];
        var9_9 = new Edge[var0.N()];
        var10_10 = var0.edges();
        while (var10_10.ok()) {
            var11_11 = var10_10.edge();
            var12_12 = var11_11.index();
            var7_7[var12_12] = var11_11.source() == var4_4 ? 0.0 : var2_2[var11_11.index()];
            var10_10.next();
        }
        if (ShortestPaths.bellmanFord(var0, var4_4, var1_1, (double[])var7_7, var8_8, var9_9)) ** GOTO lbl24
        return false;
lbl-1000:
        // 1 sources

        {
            var0.removeEdge(var5_5.popEdge());
lbl24:
            // 2 sources

            ** while (!var5_5.isEmpty())
        }
lbl25:
        // 1 sources

        var0.removeNode(var4_4);
        var11_11 = var0.edges();
        while (var11_11.ok()) {
            var12_13 = var11_11.edge();
            var13_15 = var12_13.index();
            var7_7[var13_15] = var8_8[var12_13.source().index()] + var2_2[var13_15] - var8_8[var12_13.target().index()];
            var11_11.next();
        }
        var12_14 = var0.nodes();
        while (var12_14.ok()) {
            ShortestPaths.dijkstra(var0, var12_14.node(), var1_1, (double[])var7_7, var3_3[var12_14.node().index()], var9_9);
            var12_14.next();
        }
        var13_16 = var0.nodes();
        while (var13_16.ok()) {
            var14_17 = var13_16.node();
            var15_18 = var14_17.index();
            var16_19 = var8_8[var15_18];
            var18_20 = var0.nodes();
            while (var18_20.ok()) {
                var19_21 = var18_20.node().index();
                v0 = var3_3[var15_18];
                v1 = var19_21;
                v0[v1] = v0[v1] + (var8_8[var19_21] - var16_19);
                var18_20.next();
            }
            var13_16.next();
        }
        return true;
    }

    public static double[] uniformCost(Graph graph) {
        double[] dArray = new double[graph.E()];
        int n = 0;
        while (n < graph.E()) {
            dArray[n] = 1.0;
            ++n;
        }
        return dArray;
    }

    public static NodeList constructNodePath(Node node, Node node2, Edge[] edgeArray) {
        return ShortestPaths.constructNodePath(node, node2, DataProviders.createNodeDataProvider(edgeArray));
    }

    public static NodeList constructNodePath(Node node, Node node2, DataProvider dataProvider) {
        NodeList nodeList = new NodeList();
        Edge edge = (Edge)dataProvider.get(node2);
        if (edge != null) {
            nodeList.push(node2);
            while (edge != null) {
                node2 = edge.opposite(node2);
                nodeList.push(node2);
                edge = (Edge)dataProvider.get(node2);
            }
        }
        return nodeList;
    }

    public static EdgeList constructEdgePath(Node node, Node node2, Edge[] edgeArray) {
        return ShortestPaths.constructEdgePath(node, node2, DataProviders.createNodeDataProvider(edgeArray));
    }

    public static EdgeList constructEdgePath(Node node, Node node2, DataProvider dataProvider) {
        EdgeList edgeList = new EdgeList();
        Edge edge = (Edge)dataProvider.get(node2);
        while (edge != null) {
            edgeList.push(edge);
            node2 = edge.opposite(node2);
            edge = (Edge)dataProvider.get(node2);
        }
        return edgeList;
    }

    private static double[] a(Graph graph, DataProvider dataProvider) {
        double[] dArray = new double[graph.E()];
        EdgeCursor edgeCursor = graph.edges();
        while (edgeCursor.ok()) {
            Edge edge = edgeCursor.edge();
            dArray[edge.index()] = dataProvider.getDouble(edge);
            edgeCursor.next();
        }
        return dArray;
    }

    private static double[] b(Graph graph, DataProvider dataProvider) {
        double[] dArray = new double[graph.N()];
        NodeCursor nodeCursor = graph.nodes();
        while (nodeCursor.ok()) {
            Node node = nodeCursor.node();
            dArray[node.index()] = dataProvider.getDouble(node);
            nodeCursor.next();
        }
        return dArray;
    }

    private static double[] b(Graph graph) {
        return new double[graph.N()];
    }

    private static Edge[] a(Graph graph) {
        return new Edge[graph.N()];
    }

    private static void a(Graph graph, double[] dArray, NodeMap nodeMap) {
        NodeCursor nodeCursor = graph.nodes();
        while (nodeCursor.ok()) {
            Node node = nodeCursor.node();
            nodeMap.setDouble(node, dArray[node.index()]);
            nodeCursor.next();
        }
    }

    private static void a(Graph graph, Edge[] edgeArray, NodeMap nodeMap) {
        NodeCursor nodeCursor = graph.nodes();
        while (nodeCursor.ok()) {
            Node node = nodeCursor.node();
            nodeMap.set(node, edgeArray[node.index()]);
            nodeCursor.next();
        }
    }
}

