/*
 * Decompiled with CFR 0.152.
 */
package visad.util;

import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGEncodeParam;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.Vector;
import javax.swing.JFileChooser;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import ncsa.hdf.hdf5lib.H5;
import visad.DisplayImpl;
import visad.util.ComboFileFilter;
import visad.util.ExtensionFileFilter;
import visad.util.McIDASFileFilter;

public class Util {
    public static boolean isApproximatelyEqual(float a, float b, float epsilon) {
        if (Float.isNaN(a)) {
            return Float.isNaN(b);
        }
        if (Float.isNaN(b)) {
            return false;
        }
        if (Float.isInfinite(a)) {
            if (Float.isInfinite(b)) {
                return (double)a < 0.0 && (double)b < 0.0 || (double)a > 0.0 && (double)b > 0.0;
            }
            return false;
        }
        if (Float.isInfinite(b)) {
            return false;
        }
        if (Math.abs(a - b) < epsilon) {
            return true;
        }
        if ((double)a == 0.0 || (double)b == 0.0) {
            return false;
        }
        return Math.abs(1.0f - a / b) < 1.1920929E-7f;
    }

    public static boolean isApproximatelyEqual(float a, float b) {
        return Util.isApproximatelyEqual((double)a, (double)b, 1.0E-5);
    }

    public static boolean isApproximatelyEqual(double a, double b, double epsilon) {
        if (Double.isNaN(a)) {
            return Double.isNaN(b);
        }
        if (Double.isNaN(b)) {
            return false;
        }
        if (Double.isInfinite(a)) {
            if (Double.isInfinite(b)) {
                return a < 0.0 && b < 0.0 || a > 0.0 && b > 0.0;
            }
            return false;
        }
        if (Double.isInfinite(b)) {
            return false;
        }
        if (Math.abs(a - b) < epsilon) {
            return true;
        }
        if (a == 0.0 || b == 0.0) {
            return false;
        }
        return Math.abs(1.0 - a / b) < 2.220446049250313E-16;
    }

    public static boolean isApproximatelyEqual(double a, double b) {
        return Util.isApproximatelyEqual(a, b, 1.0E-9);
    }

    public static JFileChooser getVisADFileChooser() {
        JFileChooser dialog = null;
        try {
            dialog = new JFileChooser(System.getProperty("user.dir"));
            Vector<FileFilter> filters = new Vector<FileFilter>();
            boolean jai = Util.canDoJAI();
            ExtensionFileFilter f2000 = new ExtensionFileFilter("r", "Amanda F2000 datasets");
            dialog.addChoosableFileFilter(f2000);
            filters.add(f2000);
            ExtensionFileFilter biorad = new ExtensionFileFilter("pic", "BioRad PIC images");
            dialog.addChoosableFileFilter(biorad);
            filters.add(biorad);
            ExtensionFileFilter bmp = new ExtensionFileFilter("bmp", "BMP images");
            dialog.addChoosableFileFilter(bmp);
            filters.add(bmp);
            ExtensionFileFilter dicom = new ExtensionFileFilter("dicom", "DICOM images");
            dialog.addChoosableFileFilter(dicom);
            filters.add(dicom);
            ExtensionFileFilter fits = new ExtensionFileFilter("fits", "FITS datasets");
            dialog.addChoosableFileFilter(fits);
            filters.add(fits);
            if (jai) {
                ExtensionFileFilter flashpix = new ExtensionFileFilter("flashpix", "FlashPix images");
                dialog.addChoosableFileFilter(flashpix);
                filters.add(flashpix);
            }
            ExtensionFileFilter gif = new ExtensionFileFilter("gif", "GIF images");
            dialog.addChoosableFileFilter(gif);
            filters.add(gif);
            if (Util.canDoHDF5()) {
                ExtensionFileFilter hdf5 = new ExtensionFileFilter(new String[]{"hdf", "hdf5"}, "HDF-5 datasets");
                dialog.addChoosableFileFilter(hdf5);
                filters.add(hdf5);
            }
            ExtensionFileFilter hdfeos = new ExtensionFileFilter(new String[]{"hdf", "hdfeos"}, "HDF-EOS datasets");
            dialog.addChoosableFileFilter(hdfeos);
            filters.add(hdfeos);
            ExtensionFileFilter jpeg = new ExtensionFileFilter(new String[]{"jpg", "jpeg", "jpe"}, "JPEG images");
            dialog.addChoosableFileFilter(jpeg);
            filters.add(jpeg);
            ExtensionFileFilter lut = new ExtensionFileFilter("lut", "LUT data");
            dialog.addChoosableFileFilter(lut);
            filters.add(lut);
            McIDASFileFilter mcidas = new McIDASFileFilter();
            dialog.addChoosableFileFilter(mcidas);
            filters.add(mcidas);
            ExtensionFileFilter netcdf = new ExtensionFileFilter("nc", "netCDF datasets");
            dialog.addChoosableFileFilter(netcdf);
            filters.add(netcdf);
            ExtensionFileFilter pgm = new ExtensionFileFilter("pgm", "PGM images");
            dialog.addChoosableFileFilter(pgm);
            filters.add(pgm);
            ExtensionFileFilter png = new ExtensionFileFilter("png", "PNG images");
            dialog.addChoosableFileFilter(png);
            filters.add(png);
            if (jai) {
                ExtensionFileFilter pnm = new ExtensionFileFilter("pnm", "PNM images");
                dialog.addChoosableFileFilter(pnm);
                filters.add(pnm);
            }
            if (Util.canDoQuickTime()) {
                ExtensionFileFilter qt = new ExtensionFileFilter("mov", "QuickTime movies");
                dialog.addChoosableFileFilter(qt);
                filters.add(qt);
            }
            ExtensionFileFilter roi = new ExtensionFileFilter("roi", "ROI data");
            dialog.addChoosableFileFilter(roi);
            filters.add(roi);
            ExtensionFileFilter text = new ExtensionFileFilter(new String[]{"csv", "tsv", "bsv", "txt"}, "ASCII text data");
            dialog.addChoosableFileFilter(text);
            filters.add(text);
            ExtensionFileFilter tiff = new ExtensionFileFilter(new String[]{"tiff", "tif"}, "TIFF datasets");
            dialog.addChoosableFileFilter(tiff);
            filters.add(tiff);
            ExtensionFileFilter visad = new ExtensionFileFilter("vad", "Binary or serialized VisAD data");
            dialog.addChoosableFileFilter(visad);
            filters.add(visad);
            ExtensionFileFilter vis5d = new ExtensionFileFilter("v5d", "Vis5D datasets");
            dialog.addChoosableFileFilter(vis5d);
            filters.add(vis5d);
            ExtensionFileFilter zip = new ExtensionFileFilter("zip", "ZIP-compressed TIFF data");
            dialog.addChoosableFileFilter(zip);
            filters.add(zip);
            Object[] ff = new FileFilter[filters.size()];
            filters.copyInto(ff);
            ComboFileFilter combo = new ComboFileFilter((FileFilter[])ff, "All VisAD file types");
            dialog.addChoosableFileFilter(combo);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return dialog;
    }

    public static void adjustTextField(JTextField field) {
        Dimension msize = field.getMaximumSize();
        Dimension psize = field.getPreferredSize();
        msize.height = psize.height;
        field.setMaximumSize(msize);
    }

    public static void centerWindow(Window window) {
        Dimension s = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension w = window.getSize();
        ((Component)window).setLocation(s.width / 2 - w.width / 2, s.height / 2 - w.height / 2);
    }

    public static boolean canDoHDF5() {
        boolean success = false;
        try {
            H5.J2C(0);
            success = true;
        }
        catch (NoClassDefFoundError err) {
        }
        catch (UnsatisfiedLinkError err) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        return success;
    }

    public static boolean canDoJPEG() {
        return Util.canDoClass("com.sun.image.codec.jpeg.JPEGCodec") != null;
    }

    public static boolean canDoJAI() {
        return Util.canDoClass("javax.media.jai.JAI") != null;
    }

    public static boolean canDoPython() {
        return Util.canDoClass("org.python.util.PythonInterpreter") != null;
    }

    public static boolean canDoQuickTime() {
        return Util.canDoClass("quicktime.QTSession") != null;
    }

    public static boolean canDoJava3D() {
        return Util.canDoJava3D("1.0");
    }

    public static boolean canDoJava3D(String version) {
        Package p;
        boolean b;
        Class testClass = Util.canDoClass("javax.vecmath.Point3d");
        boolean bl = testClass != null ? Util.canDoClass("javax.media.j3d.SceneGraphObject") != null : (b = false);
        if (b && (p = testClass.getPackage()) != null) {
            try {
                b = p.isCompatibleWith(version);
            }
            catch (NumberFormatException nfe) {
                b = false;
            }
        }
        return b;
    }

    private static Class canDoClass(String classname) {
        Class<?> c = null;
        try {
            c = Class.forName(classname);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return c;
    }

    public static void captureDisplay(DisplayImpl display, String filename) {
        final DisplayImpl disp = display;
        final File fn = new File(filename);
        Runnable savedisp = new Runnable(){

            public void run() {
                BufferedImage image = disp.getImage();
                try {
                    JPEGEncodeParam param = JPEGCodec.getDefaultJPEGEncodeParam((BufferedImage)image);
                    param.setQuality(1.0f, true);
                    FileOutputStream fout = new FileOutputStream(fn);
                    JPEGImageEncoder encoder = JPEGCodec.createJPEGEncoder((OutputStream)fout);
                    encoder.encode(image, param);
                    fout.close();
                }
                catch (Exception err) {
                    System.err.println("Error whilst saving JPEG: " + err);
                }
            }
        };
        Thread t = new Thread(savedisp);
        t.start();
    }

    public static boolean arraysEqual(Object[] o1, Object[] o2) {
        if (o1 == null && o2 == null) {
            return true;
        }
        if (o1 == null || o2 == null) {
            return false;
        }
        if (o1.length != o2.length) {
            return false;
        }
        int i = 0;
        while (i < o1.length) {
            if (!o1[i].equals(o2[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static void invoke(boolean wait, Runnable r) {
        Util.invoke(wait, false, r);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void invoke(boolean wait, boolean printStackTraces, Runnable r) {
        if (wait) {
            if (Thread.currentThread().getName().startsWith("AWT-EventQueue")) {
                r.run();
                return;
            } else {
                try {
                    SwingUtilities.invokeAndWait(r);
                    return;
                }
                catch (InterruptedException exc) {
                    if (!printStackTraces) return;
                    exc.printStackTrace();
                    return;
                }
                catch (InvocationTargetException exc) {
                    if (!printStackTraces) return;
                    exc.getTargetException().printStackTrace();
                }
            }
            return;
        } else {
            SwingUtilities.invokeLater(r);
        }
    }
}

