/*
 * Decompiled with CFR 0.152.
 */
package visad.util;

import java.util.AbstractList;
import java.util.ListIterator;
import java.util.Vector;

public class ThreadPool {
    private static final String DEFAULT_PREFIX = "Minnow";
    private static final int DEFAULT_MIN_THREADS = 5;
    private static final int DEFAULT_MAX_THREADS = 10;
    private int maxQueuedTasks = 3;
    private int minThreads;
    private int maxThreads;
    private Object threadLock = new Object();
    private Object doneLock = new Object();
    private boolean terminateThread = false;
    private Vector threads = new Vector();
    private Vector tasks = new Vector();
    private Vector busy_tasks = new Vector();
    private String prefix;
    private int nextID = 0;

    public ThreadPool() throws Exception {
        this(DEFAULT_PREFIX, 5, 10);
    }

    public ThreadPool(String prefix) throws Exception {
        this(prefix, 5, 10);
    }

    public ThreadPool(int max) throws Exception {
        this(5, max);
    }

    public ThreadPool(int min, int max) throws Exception {
        this(DEFAULT_PREFIX, min, max);
    }

    public ThreadPool(String prefix, int min, int max) throws Exception {
        this.minThreads = min;
        this.maxThreads = max;
        if (this.minThreads > this.maxThreads) {
            throw new Exception("Maximum number of threads (" + this.maxThreads + ") is less than minimum number of threads (" + this.minThreads + ")");
        }
        this.prefix = prefix;
        int i = 0;
        while (i < this.minThreads) {
            ThreadMinnow minnow = new ThreadMinnow(this);
            minnow.setName(prefix + "-" + this.nextID++);
            this.threads.addElement(minnow);
            ++i;
        }
    }

    public void remove(Runnable r) {
        Vector vector = this.tasks;
        synchronized (vector) {
            this.tasks.removeElement(r);
            this.busy_tasks.removeElement(r);
        }
    }

    public void queue(Runnable r) {
        if (this.terminateThread) {
            throw new Error("Task queued after threads stopped");
        }
        int numTasks = 0;
        Vector vector = this.tasks;
        synchronized (vector) {
            if (!this.tasks.contains(r)) {
                this.tasks.addElement(r);
                numTasks = this.tasks.size();
            }
        }
        Object object = this.threadLock;
        synchronized (object) {
            if (numTasks > this.maxQueuedTasks) {
                if (this.threads != null && this.threads.size() < this.maxThreads) {
                    try {
                        ThreadMinnow t = new ThreadMinnow(this);
                        t.setName(this.prefix + "-" + this.nextID++);
                        this.threads.addElement(t);
                        this.threadLock.notify();
                    }
                    catch (SecurityException e) {}
                } else {
                    this.threadLock.notifyAll();
                }
            } else {
                this.threadLock.notify();
            }
        }
    }

    Runnable getTask() {
        Runnable thisTask = null;
        Vector vector = this.tasks;
        synchronized (vector) {
            int n = this.tasks.size();
            int i = 0;
            while (i < n) {
                thisTask = (Runnable)this.tasks.elementAt(i);
                if (!this.busy_tasks.contains(thisTask)) {
                    this.tasks.removeElementAt(i);
                    this.busy_tasks.addElement(thisTask);
                    break;
                }
                thisTask = null;
                ++i;
            }
        }
        return thisTask;
    }

    void releaseTask(Runnable r) {
        Vector vector = this.tasks;
        synchronized (vector) {
            this.busy_tasks.removeElement(r);
        }
    }

    /*
     * Unable to fully structure code
     */
    public boolean waitForTasks() {
        timeout = this.tasks.size();
        if (!(Thread.currentThread() instanceof ThreadMinnow)) ** GOTO lbl21
        try {
            Thread.sleep(15000L);
        }
        catch (InterruptedException ie) {
            // empty catch block
        }
        return false;
lbl-1000:
        // 1 sources

        {
            try {
                ie = this.doneLock;
                synchronized (ie) {
                    this.doneLock.wait();
                }
            }
            catch (InterruptedException var2_4) {
                // empty catch block
            }
            if (timeout-- == 0) break;
lbl21:
            // 2 sources

            ** while (this.tasks.size() > 0)
        }
lbl22:
        // 2 sources

        return timeout > 0;
    }

    public void setThreadMaximum(int num) throws Exception {
        if (num < this.maxThreads) {
            throw new Exception("Cannot decrease maximum number of threads");
        }
        this.maxThreads = num;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void stopThreads() {
        ListIterator i;
        Vector oldthreads;
        if (this.terminateThread) {
            return;
        }
        this.terminateThread = true;
        Object object = this.threadLock;
        synchronized (object) {
            this.threadLock.notifyAll();
        }
        Vector vector = this.threads;
        synchronized (vector) {
            oldthreads = this.threads;
            this.threads = null;
            i = ((AbstractList)oldthreads).listIterator();
        }
        while (i.hasNext()) {
            Thread t = (Thread)i.next();
            while (true) {
                Vector vector2 = oldthreads;
                synchronized (vector2) {
                    oldthreads.notifyAll();
                }
                try {
                    t.join();
                }
                catch (InterruptedException e) {
                    continue;
                }
                break;
            }
            i.remove();
        }
    }

    private class ThreadMinnow
    extends Thread {
        private ThreadPool parent = null;

        public ThreadMinnow(ThreadPool p) {
            this.parent = p;
            this.start();
        }

        public void run() {
            while (true) {
                Object t2;
                Runnable r;
                if ((r = this.parent.getTask()) != null) {
                    try {
                        r.run();
                    }
                    catch (Throwable t2) {
                        t2.printStackTrace();
                    }
                    this.parent.releaseTask(r);
                    t2 = ThreadPool.this.threadLock;
                    synchronized (t2) {
                        ThreadPool.this.threadLock.notify();
                    }
                    Object object = ThreadPool.this.doneLock;
                    synchronized (object) {
                        ThreadPool.this.doneLock.notifyAll();
                    }
                }
                if (ThreadPool.this.terminateThread) {
                    return;
                }
                try {
                    t2 = ThreadPool.this.threadLock;
                    synchronized (t2) {
                        ThreadPool.this.threadLock.wait();
                        continue;
                    }
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }
    }
}

