/*
 * Decompiled with CFR 0.152.
 */
package visad.util;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import visad.util.Slider;
import visad.util.SliderChangeEvent;

public class BarSlider
extends Slider
implements MouseListener,
MouseMotionListener {
    private float upper;
    private float lower;
    private float val;
    Dimension minSize = null;
    Dimension prefSize = null;
    Dimension maxSize = null;
    private int oldxval;

    public BarSlider() {
        this(-1.0f, 1.0f, 0.0f);
    }

    public BarSlider(float lower, float upper, float initial) {
        if (lower > initial) {
            throw new IllegalArgumentException("BarSlider: lower bound is greater than initial value");
        }
        if (initial > upper) {
            throw new IllegalArgumentException("BarSlider: initial value is greater than the upper bound");
        }
        this.upper = upper;
        this.lower = lower;
        this.val = initial;
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public static void main(String[] argv) {
        JFrame frame = new JFrame("Visad Bar Slider");
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        BarSlider b = new BarSlider();
        frame.add(b);
        ((Component)frame).setSize(b.getPreferredSize());
        ((Component)frame).setVisible(true);
    }

    public float getMinimum() {
        return this.lower;
    }

    public synchronized void setMinimum(float value) {
        if (value > this.val || value == this.val && value == this.upper) {
            throw new IllegalArgumentException("BarSlider: Attemped to set new minimum value greater than the current value");
        }
        this.lower = value;
        this.notifyListeners(new SliderChangeEvent(2, value));
        this.repaint();
    }

    public float getMaximum() {
        return this.upper;
    }

    public synchronized void setMaximum(float value) {
        if (value < this.val || value == this.val && value == this.lower) {
            throw new IllegalArgumentException("BarSlider: Attemped to set new maximum value less than the current value");
        }
        this.upper = value;
        this.notifyListeners(new SliderChangeEvent(3, value));
        this.repaint();
    }

    public float getValue() {
        return this.val;
    }

    public synchronized void setValue(float value) {
        if (value > this.upper || value < this.lower) {
            throw new IllegalArgumentException("BarSlider: Attemped to set new value out of slider range");
        }
        this.val = value;
        this.notifyListeners(new SliderChangeEvent(1, value));
        this.repaint();
    }

    public Dimension getPreferredSize() {
        if (this.prefSize == null) {
            this.prefSize = new Dimension(256, 16);
        }
        return this.prefSize;
    }

    public void setPreferredSize(Dimension dim) {
        this.prefSize = dim;
    }

    public Dimension getMaximumSize() {
        if (this.maxSize == null) {
            this.maxSize = new Dimension(Integer.MAX_VALUE, 16);
        }
        return this.maxSize;
    }

    public void setMaximumSize(Dimension dim) {
        this.maxSize = dim;
    }

    public Dimension getMinimumSize() {
        if (this.minSize == null) {
            this.minSize = new Dimension(40, 16);
        }
        return this.minSize;
    }

    public void setMinimumSize(Dimension dim) {
        this.minSize = dim;
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        this.updatePosition(e);
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mouseDragged(MouseEvent e) {
        this.updatePosition(e);
    }

    public void mouseMoved(MouseEvent e) {
    }

    private void updatePosition(MouseEvent e) {
        int x = e.getX();
        if (x < 0) {
            x = 0;
        }
        if (x >= this.getBounds().width) {
            x = this.getBounds().width - 1;
        }
        float dist = (float)x / (float)(this.getBounds().width - 1);
        this.setValue(this.lower + dist * (this.upper - this.lower));
    }

    public void update(Graphics g) {
        g.setColor(Color.black);
        g.drawRect(this.oldxval - 2, 0, 5, this.getBounds().height - 1);
        g.setColor(Color.gray);
        g.fillRect(this.oldxval - 2, this.getBounds().height / 2 - 1, 6, 3);
        g.setColor(Color.white);
        int xval = (int)Math.floor((this.val - this.lower) * (float)(this.getBounds().width - 1) / (this.upper - this.lower));
        g.drawRect(xval - 2, 0, 5, this.getBounds().height - 1);
        this.oldxval = xval;
    }

    public void paint(Graphics g) {
        g.setColor(Color.black);
        g.fillRect(0, 0, this.getBounds().width, this.getBounds().height);
        g.setColor(Color.gray);
        g.fillRect(0, this.getBounds().height / 2 - 1, this.getBounds().width, 3);
        g.setColor(Color.white);
        int xval = (int)Math.floor((this.val - this.lower) * (float)(this.getBounds().width - 1) / (this.upper - this.lower));
        g.drawRect(xval - 2, 0, 5, this.getBounds().height - 1);
        this.oldxval = xval;
    }
}

