/*
 * Decompiled with CFR 0.152.
 */
package visad.paoloa;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.ItemSelectable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.rmi.RemoteException;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import visad.CellImpl;
import visad.ConstantMap;
import visad.DataReferenceImpl;
import visad.DataRenderer;
import visad.Display;
import visad.DisplayImpl;
import visad.Field;
import visad.FlatField;
import visad.FunctionType;
import visad.GraphicsModeControl;
import visad.Gridded1DSet;
import visad.Linear2DSet;
import visad.MathType;
import visad.PlotText;
import visad.Real;
import visad.RealTuple;
import visad.RealTupleType;
import visad.RealType;
import visad.ScalarMap;
import visad.ScalarMapControlEvent;
import visad.ScalarMapEvent;
import visad.ScalarMapListener;
import visad.Tuple;
import visad.TupleType;
import visad.VisADException;
import visad.data.netcdf.Plain;
import visad.java2d.DirectManipulationRendererJ2D;
import visad.java2d.DisplayImplJ2D;
import visad.java3d.DirectManipulationRendererJ3D;
import visad.java3d.DisplayImplJ3D;
import visad.java3d.DisplayRendererJ3D;
import visad.java3d.TwoDDisplayRendererJ3D;
import visad.util.LabeledColorWidget;

public class Nasti {
    int ntimes;
    int nlines;
    int nelements;
    int[] time_to_sample;
    int[][] sample_to_time;
    Field nasti;
    int spectrum_index;
    boolean java2d = false;
    RealType time;
    RealType wnum1;
    RealType atmosphericRadiance;
    RealType image_line;
    RealType image_element;
    float wnum_low;
    float wnum_hi;
    Linear2DSet image_set;
    RealTupleType image_domain;
    FunctionType image_type;
    FunctionType red_bar_type;

    public static void main(String[] args) throws VisADException, RemoteException, IOException {
        if (args.length < 1) {
            System.out.println("To run this program, type \"java visad.paoloa.Nasti file.nc\"");
            System.out.println("where file.nc is a netCDF file containing a NAST-I file.");
            return;
        }
        Nasti nasti = new Nasti(args[0]);
    }

    public Nasti(String filename) throws VisADException, RemoteException, IOException {
        Plain plain = new Plain();
        Tuple nasti_tuple = (Tuple)plain.open(filename);
        plain = null;
        this.nasti = (Field)nasti_tuple.getComponent(2);
        FunctionType nasti_type = (FunctionType)this.nasti.getType();
        TupleType nasti_range_type = (TupleType)nasti_type.getRange();
        int angle_index = nasti_range_type.getIndex("sceneMirrorAngle");
        this.time = (RealType)nasti_type.getDomain().getComponent(0);
        Gridded1DSet time_set = (Gridded1DSet)this.nasti.getDomainSet();
        float[][] t = time_set.getSamples();
        float[] times = t[0];
        this.ntimes = time_set.getLength();
        double[] angles = new double[this.ntimes];
        int[] elements = new int[this.ntimes];
        int[] lines = new int[this.ntimes];
        int line = 0;
        int max_element = 0;
        int i = 0;
        while (i < this.ntimes) {
            angles[i] = ((Real)((Tuple)this.nasti.getSample(i)).getComponent(angle_index)).getValue();
            if (i <= 0 || angles[i] < angles[i - 1]) {
                // empty if block
            }
            lines[i] = ++line;
            elements[i] = (int)Math.round((angles[i] + 45.0) / 7.5);
            if (elements[i] < 0) {
                System.out.println("negative element " + elements[i]);
                System.exit(0);
            }
            if (elements[i] > 12) {
                System.out.println("element > 12: " + elements[i]);
                System.exit(0);
            }
            if (elements[i] > max_element) {
                max_element = elements[i];
            }
            ++i;
        }
        if (max_element > 12) {
            System.out.println("max_element = " + max_element + " too large");
            System.exit(0);
        }
        this.nlines = line + 1;
        this.nelements = 13;
        System.out.println("nlines = " + this.nlines + " nelements = " + this.nelements);
        this.time_to_sample = new int[this.ntimes];
        this.sample_to_time = new int[this.nlines][this.nelements];
        int i2 = 0;
        while (i2 < this.nlines) {
            int j = 0;
            while (j < this.nelements) {
                this.sample_to_time[i2][j] = -1;
                ++j;
            }
            ++i2;
        }
        int i3 = 0;
        while (i3 < this.ntimes) {
            this.time_to_sample[i3] = elements[i3] + this.nelements * lines[i3];
            this.sample_to_time[lines[i3]][elements[i3]] = i3;
            ++i3;
        }
        this.spectrum_index = nasti_range_type.getDimension() - 1;
        FunctionType spectrum_type = (FunctionType)nasti_range_type.getComponent(this.spectrum_index);
        this.wnum1 = (RealType)spectrum_type.getDomain().getComponent(0);
        this.atmosphericRadiance = (RealType)spectrum_type.getRange();
        this.red_bar_type = new FunctionType(this.atmosphericRadiance, this.wnum1);
        Field spectrum0 = (Field)((Tuple)this.nasti.getSample(0)).getComponent(this.spectrum_index);
        Gridded1DSet spectrum_set = (Gridded1DSet)spectrum0.getDomainSet();
        float[] lows = spectrum_set.getLow();
        float[] his = spectrum_set.getHi();
        int spectrum_set_length = spectrum_set.getLength();
        this.wnum_low = lows[0];
        this.wnum_hi = his[0];
        this.image_set = new Linear2DSet(-48.75, 48.75, 13, -0.5, (double)this.nlines - 0.5, this.nlines);
        this.image_line = RealType.getRealType("image_line");
        this.image_element = RealType.getRealType("image_element");
        this.image_domain = new RealTupleType(this.image_element, this.image_line);
        this.image_type = new FunctionType(this.image_domain, this.atmosphericRadiance);
        JFrame frame = new JFrame("Nasti VisAD Application");
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        panel.setAlignmentY(0.0f);
        panel.setAlignmentX(0.0f);
        ChannelImage channel_image1 = new ChannelImage();
        ChannelImage channel_image2 = new ChannelImage();
        panel.add(channel_image1);
        panel.add(channel_image2);
        frame.getContentPane().add(panel);
        ((Component)frame).setSize(800, 900);
        ((Component)frame).setVisible(true);
    }

    class ChannelImage
    extends JPanel
    implements ActionListener,
    ItemListener,
    ScalarMapListener {
        double[][] radiances;
        FlatField image;
        DataReferenceImpl image_ref;
        DataReferenceImpl white_cursor_ref;
        DataReferenceImpl red_cursor_ref;
        DataReferenceImpl spectrum_ref;
        DataReferenceImpl red_bar_ref;
        ScalarMap radiance_map2;
        ScalarMap wnum_map;
        JPanel wpanel;
        JLabel wnum_label;
        JTextField wnum_field;
        JPanel zpanel;
        JCheckBox wnum_zoom;
        JButton recenter;
        JPanel dpanel1;
        JPanel dpanel2;
        float wnum_last;
        boolean wzoom;
        boolean skip_red = false;

        ChannelImage() throws VisADException, RemoteException {
            this.setLayout(new BoxLayout(this, 1));
            this.setAlignmentY(0.0f);
            this.setAlignmentX(0.0f);
            this.white_cursor_ref = new DataReferenceImpl("white_cursor_ref");
            this.red_cursor_ref = new DataReferenceImpl("red_cursor_ref");
            this.spectrum_ref = new DataReferenceImpl("spectrum_ref");
            this.red_bar_ref = new DataReferenceImpl("red_bar_ref");
            this.wpanel = new JPanel();
            this.wpanel.setLayout(new BoxLayout(this.wpanel, 0));
            this.wnum_label = new JLabel("wave number:");
            this.wnum_field = new JTextField("---");
            Dimension msize = this.wnum_field.getMaximumSize();
            Dimension psize = this.wnum_field.getPreferredSize();
            msize.height = psize.height;
            this.wnum_field.setMaximumSize(msize);
            this.wnum_field.addActionListener(this);
            this.wnum_field.setActionCommand("wavenum");
            this.wnum_field.setEnabled(true);
            this.wpanel.add(this.wnum_label);
            this.wpanel.add(this.wnum_field);
            this.wpanel.add(Box.createRigidArea(new Dimension(10, 0)));
            this.add(this.wpanel);
            this.wnum_last = (Nasti.this.wnum_low + Nasti.this.wnum_hi) / 2.0f;
            this.wnum_field.setText(PlotText.shortString(this.wnum_last));
            RealTuple init_white_cursor = new RealTuple(new Real[]{new Real(Nasti.this.image_element, 0.0), new Real(Nasti.this.image_line, 0.0)});
            this.white_cursor_ref.setData(init_white_cursor);
            this.image = new FlatField(Nasti.this.image_type, Nasti.this.image_set);
            this.radiances = new double[1][Nasti.this.nelements * Nasti.this.nlines];
            int i = 0;
            while (i < Nasti.this.nelements * Nasti.this.nlines) {
                this.radiances[0][i] = Double.NaN;
                ++i;
            }
            this.image_ref = new DataReferenceImpl("image_ref");
            this.image_ref.setData(this.image);
            Real init_red_cursor = new Real(Nasti.this.wnum1, (double)this.wnum_last);
            this.red_cursor_ref.setData(init_red_cursor);
            this.do_image(this.wnum_last);
            DisplayImpl display1 = null;
            if (!Nasti.this.java2d) {
                try {
                    display1 = new DisplayImplJ3D("image display", (DisplayRendererJ3D)new TwoDDisplayRendererJ3D());
                }
                catch (UnsatisfiedLinkError e) {
                    Nasti.this.java2d = true;
                }
            }
            if (Nasti.this.java2d) {
                display1 = new DisplayImplJ2D("image display");
            }
            ScalarMap line_map = new ScalarMap(Nasti.this.image_line, Display.YAxis);
            display1.addMap(line_map);
            line_map.setRange(12.5, -0.5);
            ScalarMap element_map = new ScalarMap(Nasti.this.image_element, Display.XAxis);
            display1.addMap(element_map);
            element_map.setRange(-48.75, 48.75);
            ScalarMap radiance_map1 = new ScalarMap(Nasti.this.atmosphericRadiance, Display.RGB);
            display1.addMap(radiance_map1);
            display1.setAlwaysAutoScale(true);
            GraphicsModeControl mode1 = display1.getGraphicsModeControl();
            display1.addReference(this.image_ref);
            ConstantMap[] wmaps = new ConstantMap[]{new ConstantMap(1.0, Display.Blue), new ConstantMap(1.0, Display.Red), new ConstantMap(1.0, Display.Green), new ConstantMap(4.0, Display.PointSize)};
            if (Nasti.this.java2d) {
                display1.addReferences((DataRenderer)new DirectManipulationRendererJ2D(), this.white_cursor_ref, wmaps);
            } else {
                display1.addReferences((DataRenderer)new DirectManipulationRendererJ3D(), this.white_cursor_ref, wmaps);
            }
            this.dpanel1 = new JPanel();
            this.dpanel1.setLayout(new BoxLayout(this.dpanel1, 0));
            this.dpanel1.add(display1.getComponent());
            this.dpanel1.add(Box.createHorizontalStrut(0));
            CompoundBorder etchedBorder5 = new CompoundBorder(new EtchedBorder(), new EmptyBorder(5, 5, 5, 5));
            this.dpanel1.setBorder(etchedBorder5);
            this.add(this.dpanel1);
            LabeledColorWidget lw = new LabeledColorWidget(radiance_map1);
            Dimension d = new Dimension(400, 200);
            lw.setMaximumSize(d);
            JPanel lpanel = new JPanel();
            lpanel.setLayout(new BoxLayout(lpanel, 0));
            lpanel.add(lw);
            lpanel.setBorder(etchedBorder5);
            this.add(lpanel);
            this.zpanel = new JPanel();
            this.zpanel.setLayout(new BoxLayout(this.zpanel, 0));
            this.wnum_zoom = new JCheckBox("wave number zoom", false);
            this.wnum_zoom.addItemListener(this);
            this.recenter = new JButton("Recenter");
            this.recenter.addActionListener(this);
            this.recenter.setActionCommand("recenter");
            this.zpanel.add(this.wnum_zoom);
            this.zpanel.add(this.recenter);
            this.add(this.zpanel);
            DisplayImpl display2 = null;
            display2 = Nasti.this.java2d ? new DisplayImplJ2D("spectrum display") : new DisplayImplJ3D("spectrum display", (DisplayRendererJ3D)new TwoDDisplayRendererJ3D());
            this.wnum_map = new ScalarMap(Nasti.this.wnum1, Display.XAxis);
            display2.addMap(this.wnum_map);
            this.radiance_map2 = new ScalarMap(Nasti.this.atmosphericRadiance, Display.YAxis);
            display2.addMap(this.radiance_map2);
            this.radiance_map2.addScalarMapListener(this);
            display1.setAlwaysAutoScale(true);
            GraphicsModeControl mode2 = display2.getGraphicsModeControl();
            mode2.setScaleEnable(true);
            display2.addReference(this.spectrum_ref);
            ConstantMap[] bmaps = new ConstantMap[]{new ConstantMap(0.0, Display.Blue), new ConstantMap(1.0, Display.Red), new ConstantMap(0.0, Display.Green)};
            display2.addReference(this.red_bar_ref, bmaps);
            ConstantMap[] rmaps = new ConstantMap[]{new ConstantMap(-1.0, Display.YAxis), new ConstantMap(0.0, Display.Blue), new ConstantMap(1.0, Display.Red), new ConstantMap(0.0, Display.Green), new ConstantMap(4.0, Display.PointSize)};
            if (Nasti.this.java2d) {
                display2.addReferences((DataRenderer)new DirectManipulationRendererJ2D(), this.red_cursor_ref, rmaps);
            } else {
                display2.addReferences((DataRenderer)new DirectManipulationRendererJ3D(), this.red_cursor_ref, rmaps);
            }
            this.dpanel2 = new JPanel();
            this.dpanel2.setLayout(new BoxLayout(this.dpanel2, 0));
            this.dpanel2.add(display2.getComponent());
            this.dpanel2.add(Box.createHorizontalStrut(0));
            this.dpanel2.setBorder(etchedBorder5);
            this.add(this.dpanel2);
            CellImpl white_cursor_cell = new CellImpl(this){
                private final /* synthetic */ ChannelImage this$1;
                {
                    this.this$1 = this$1;
                }

                public void doAction() throws VisADException, RemoteException {
                    this.this$1.red_bar_ref.setData(null);
                    RealTuple white_cursor = (RealTuple)this.this$1.white_cursor_ref.getData();
                    float elem = (float)((Real)white_cursor.getComponent(0)).getValue();
                    int element = (int)Math.round(((double)elem + 45.0) / 7.5);
                    int line = (int)Math.round(((Real)white_cursor.getComponent(1)).getValue());
                    int i = 0 <= line && line < ChannelImage.access$000((ChannelImage)this.this$1).nlines && 0 <= element && element < ChannelImage.access$000((ChannelImage)this.this$1).nelements ? ChannelImage.access$000((ChannelImage)this.this$1).sample_to_time[line][element] : -1;
                    if (i >= 0) {
                        Field spectrum = (Field)((Tuple)ChannelImage.access$000((ChannelImage)this.this$1).nasti.getSample(i)).getComponent(ChannelImage.access$000((ChannelImage)this.this$1).spectrum_index);
                        this.this$1.spectrum_ref.setData(spectrum);
                    } else {
                        this.this$1.spectrum_ref.setData(null);
                    }
                }
            };
            white_cursor_cell.addReference(this.white_cursor_ref);
            CellImpl red_cursor_cell = new CellImpl(this){
                private final /* synthetic */ ChannelImage this$1;
                {
                    this.this$1 = this$1;
                }

                public void doAction() throws VisADException, RemoteException {
                    if (this.this$1.skip_red) {
                        this.this$1.skip_red = false;
                        return;
                    }
                    Real red_cursor = (Real)this.this$1.red_cursor_ref.getData();
                    if (red_cursor == null) {
                        return;
                    }
                    float wnum = (float)red_cursor.getValue();
                    if (wnum < ChannelImage.access$000((ChannelImage)this.this$1).wnum_low) {
                        wnum = ChannelImage.access$000((ChannelImage)this.this$1).wnum_low;
                    }
                    if (wnum > ChannelImage.access$000((ChannelImage)this.this$1).wnum_hi) {
                        wnum = ChannelImage.access$000((ChannelImage)this.this$1).wnum_hi;
                    }
                    try {
                        this.this$1.do_image(wnum);
                        this.this$1.wnum_last = wnum;
                        this.this$1.do_red_bar(wnum);
                        this.this$1.wnum_field.setText(PlotText.shortString(Math.abs(wnum)));
                    }
                    catch (VisADException exc) {
                    }
                    catch (RemoteException exc) {
                        // empty catch block
                    }
                }
            };
            red_cursor_cell.addReference(this.red_cursor_ref);
        }

        void do_image(float wnum) throws VisADException, RemoteException {
            int i = 0;
            while (i < Nasti.this.ntimes) {
                double radiance;
                Field spectrum = (Field)((Tuple)Nasti.this.nasti.getSample(i)).getComponent(Nasti.this.spectrum_index);
                try {
                    radiance = ((Real)spectrum.evaluate(new Real(Nasti.this.wnum1, (double)wnum))).getValue();
                }
                catch (VisADException e1) {
                    radiance = Double.NaN;
                }
                this.radiances[0][Nasti.this.time_to_sample[i]] = radiance;
                ++i;
            }
            this.image.setSamples(this.radiances);
        }

        synchronized void do_red_bar(float wnum) throws VisADException, RemoteException {
            double[] rads = this.radiance_map2.getRange();
            if (rads[0] == rads[0] && rads[1] == rads[1]) {
                float[][] red_bar_set_samples = new float[][]{{(float)rads[0], (float)rads[1]}};
                Gridded1DSet red_bar_set = new Gridded1DSet((MathType)Nasti.this.atmosphericRadiance, (float[][])red_bar_set_samples, 2);
                FlatField red_bar = new FlatField(Nasti.this.red_bar_type, red_bar_set);
                float[][] red_bar_samples = new float[][]{{wnum, wnum}};
                red_bar.setSamples(red_bar_samples);
                this.red_bar_ref.setData(red_bar);
            }
        }

        synchronized void do_wzoom() throws VisADException, RemoteException {
            if (this.wzoom) {
                this.wnum_map.setRange((double)this.wnum_last - 10.0, (double)this.wnum_last + 10.0);
            } else {
                this.wnum_map.setRange(Nasti.this.wnum_low, Nasti.this.wnum_hi);
            }
        }

        public void mapChanged(ScalarMapEvent e) {
            if (this.radiance_map2.equals(e.getScalarMap())) {
                try {
                    this.do_red_bar(this.wnum_last);
                }
                catch (VisADException e2) {
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
        }

        public void controlChanged(ScalarMapControlEvent evt) {
        }

        public void actionPerformed(ActionEvent e) {
            String cmd = e.getActionCommand();
            if (cmd.equals("wavenum")) {
                float wnum = Float.NaN;
                try {
                    wnum = Float.valueOf(this.wnum_field.getText()).floatValue();
                }
                catch (NumberFormatException exc) {
                    this.wnum_field.setText(PlotText.shortString(Math.abs(this.wnum_last)));
                }
                if (wnum == wnum) {
                    if (wnum < Nasti.this.wnum_low) {
                        wnum = Nasti.this.wnum_low;
                        this.wnum_field.setText(PlotText.shortString(Math.abs(wnum)));
                    }
                    if (wnum > Nasti.this.wnum_hi) {
                        wnum = Nasti.this.wnum_hi;
                        this.wnum_field.setText(PlotText.shortString(Math.abs(wnum)));
                    }
                    try {
                        this.do_image(wnum);
                        this.wnum_last = wnum;
                        this.do_red_bar(wnum);
                        this.do_wzoom();
                        this.skip_red = true;
                        Real red_cursor = new Real(Nasti.this.wnum1, (double)this.wnum_last);
                        this.red_cursor_ref.setData(red_cursor);
                    }
                    catch (VisADException exc) {
                        this.wnum_field.setText(PlotText.shortString(Math.abs(this.wnum_last)));
                    }
                    catch (RemoteException exc) {
                        this.wnum_field.setText(PlotText.shortString(Math.abs(this.wnum_last)));
                    }
                } else {
                    this.wnum_field.setText(PlotText.shortString(Math.abs(this.wnum_last)));
                }
            }
            if (cmd.equals("recenter")) {
                try {
                    this.do_wzoom();
                }
                catch (VisADException exc) {
                }
                catch (RemoteException exc) {
                    // empty catch block
                }
            }
        }

        public void itemStateChanged(ItemEvent e) {
            boolean on;
            ItemSelectable o = e.getItemSelectable();
            boolean bl = on = e.getStateChange() == 1;
            if (o == this.wnum_zoom) {
                try {
                    this.wzoom = on;
                    this.do_wzoom();
                }
                catch (VisADException e2) {
                }
                catch (RemoteException e2) {
                    // empty catch block
                }
            }
        }

        static /* synthetic */ Nasti access$000(ChannelImage x0) {
            return x0.Nasti.this;
        }
    }
}

