/*
 * Decompiled with CFR 0.152.
 */
package visad.meteorology;

import java.rmi.RemoteException;
import visad.Data;
import visad.DateTime;
import visad.ErrorEstimate;
import visad.FlatField;
import visad.FunctionType;
import visad.MathType;
import visad.Real;
import visad.RealType;
import visad.SampledSet;
import visad.Set;
import visad.SetType;
import visad.Unit;
import visad.VisADError;
import visad.VisADException;
import visad.georef.NavigatedCoordinateSystem;
import visad.meteorology.SingleBandedImage;

public class SingleBandedImageImpl
extends FlatField
implements SingleBandedImage {
    private DateTime startTime;
    private String description;
    private Real minValue;
    private Real maxValue;

    public SingleBandedImageImpl(FunctionType function, Set domain, DateTime startTime, String desc) throws VisADException {
        this(new FlatField(function, domain), startTime, desc);
    }

    public SingleBandedImageImpl(FlatField image, DateTime startTime, String desc) throws VisADException {
        super((FunctionType)image.getType(), image.getDomainSet());
        if (((FunctionType)this.getType()).getFlatRange().getNumberOfRealComponents() > 1) {
            throw new VisADException("SingleBandedImageImpl: Range must be a RealType or RealTupleType with one component");
        }
        try {
            if (!image.isMissing()) {
                this.setSamples(image.getValues());
                this.setRangeErrors(image.getRangeErrors());
                this.setMaxMinValues();
            }
        }
        catch (RemoteException re) {
            // empty catch block
        }
        this.startTime = startTime;
        this.description = desc;
    }

    public DateTime getStartTime() {
        return this.startTime;
    }

    public String getDescription() {
        return this.description;
    }

    public Real getMinRangeValue() {
        return this.minValue;
    }

    public Real getMaxRangeValue() {
        return this.maxValue;
    }

    public boolean isNavigated() {
        return this.getDomainCoordinateSystem() instanceof NavigatedCoordinateSystem;
    }

    public void setSamples(float[][] range, ErrorEstimate[] errors, boolean copy) throws VisADException, RemoteException {
        super.setSamples(range, errors, copy);
        this.setMaxMinValues();
    }

    public void setSamples(double[][] range, ErrorEstimate[] errors, boolean copy) throws VisADException, RemoteException {
        super.setSamples(range, errors, copy);
        this.setMaxMinValues();
    }

    public Data unary(int op, MathType new_type, int sampling_mode, int error_mode) throws VisADException {
        return new SingleBandedImageImpl((FlatField)super.unary(op, new_type, sampling_mode, error_mode), this.startTime, this.description);
    }

    public Object clone() {
        SingleBandedImageImpl newImage;
        try {
            newImage = new SingleBandedImageImpl((FlatField)super.clone(), this.startTime, this.description);
        }
        catch (VisADException excp) {
            throw new VisADError("SingleBandedImageImpl.clone(): VisADException occurred");
        }
        return newImage;
    }

    private void setMaxMinValues() throws VisADException {
        Unit units = null;
        RealType type = RealType.Generic;
        ErrorEstimate errors = null;
        double min = Double.MIN_VALUE;
        double max = Double.MAX_VALUE;
        try {
            Set rangeSet = this.getRangeSets()[0];
            units = this.getRangeUnits()[0][0];
            type = (RealType)((SetType)rangeSet.getType()).getDomain().getComponent(0);
            errors = this.getRangeErrors()[0];
            if (rangeSet instanceof SampledSet) {
                min = ((SampledSet)rangeSet).getLow()[0];
                max = ((SampledSet)rangeSet).getHi()[0];
            } else {
                double[] values = this.getValues(0);
                int i = 0;
                while (i < values.length) {
                    if (values[i] != Double.NaN) {
                        if (min == Double.MIN_VALUE) {
                            min = values[i];
                            max = values[i];
                        } else {
                            if (values[i] < min) {
                                min = values[i];
                            }
                            if (values[i] > max) {
                                max = values[i];
                            }
                        }
                    }
                    ++i;
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        this.minValue = new Real(type, min, units, errors);
        this.maxValue = new Real(type, max, units, errors);
    }
}

