/*
 * Decompiled with CFR 0.152.
 */
package visad.matrix;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import visad.Data;
import visad.FlatField;
import visad.FunctionType;
import visad.Integer1DSet;
import visad.RealTupleType;
import visad.RealType;
import visad.Tuple;
import visad.VisADException;
import visad.matrix.JamaMatrix;

public class JamaSingularValueDecomposition
extends Tuple {
    private static final RealType SVS_row = RealType.getRealType("SV_S_row");
    private static final RealType SVS_column = RealType.getRealType("SV_S_column");
    private static final RealType SVS_value = RealType.getRealType("SV_S_value");
    private static final FunctionType SVSType = JamaSingularValueDecomposition.constructSFunction();
    private static final RealType SVV_row = RealType.getRealType("SV_V_row");
    private static final RealType SVV_column = RealType.getRealType("SV_V_column");
    private static final RealType SVV_value = RealType.getRealType("SV_V_value");
    private static final FunctionType SVVType = JamaSingularValueDecomposition.constructVFunction();
    private static final RealType SVU_row = RealType.getRealType("SV_H_row");
    private static final RealType SVU_column = RealType.getRealType("SV_H_column");
    private static final RealType SVU_value = RealType.getRealType("SV_H_value");
    private static final FunctionType SVUType = JamaSingularValueDecomposition.constructHFunction();
    private static final RealType singular_domain = RealType.getRealType("singular_domain");
    private static final RealType singular_value = RealType.getRealType("singular_value");
    private static final FunctionType singularType = JamaSingularValueDecomposition.constructSVFunction();
    private static final Class[] classes = JamaSingularValueDecomposition.constructClasses();
    private static final Class classMatrix = classes[0];
    private static final Class classCholeskyDecomposition = classes[1];
    private static final Class classEigenvalueDecomposition = classes[2];
    private static final Class classLUDecomposition = classes[3];
    private static final Class classQRDecomposition = classes[4];
    private static final Class classSingularValueDecomposition = classes[5];
    private Object svd = ((JamaMatrix)this.getComponent(0)).getStash();
    private static final Method[] methods = JamaSingularValueDecomposition.constructMethods();
    private static final Method getU = methods[0];
    private static final Method getS = methods[1];
    private static final Method getV = methods[2];
    private static final Method getSingularValues = methods[3];
    private static final Method cond = methods[4];
    private static final Method norm2 = methods[4];
    private static final Method rank = methods[4];
    private static final Constructor matrixSVDecomposition = JamaSingularValueDecomposition.constructConstructor();

    private static FunctionType constructSFunction() {
        try {
            RealTupleType tuple = new RealTupleType(SVS_row, SVS_column);
            FunctionType function = new FunctionType(tuple, SVS_value);
            return function;
        }
        catch (VisADException exc) {
            exc.printStackTrace();
            return null;
        }
    }

    private static FunctionType constructVFunction() {
        try {
            RealTupleType tuple = new RealTupleType(SVV_row, SVV_column);
            FunctionType function = new FunctionType(tuple, SVV_value);
            return function;
        }
        catch (VisADException exc) {
            exc.printStackTrace();
            return null;
        }
    }

    private static FunctionType constructHFunction() {
        try {
            RealTupleType tuple = new RealTupleType(SVU_row, SVU_column);
            FunctionType function = new FunctionType(tuple, SVU_value);
            return function;
        }
        catch (VisADException exc) {
            exc.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static FunctionType constructSVFunction() {
        try {
            void exc;
            FunctionType function = new FunctionType(singular_domain, singular_value);
            return exc;
        }
        catch (VisADException exc) {
            exc.printStackTrace();
            return null;
        }
    }

    private static Class[] constructClasses() {
        Class[] cs = new Class[6];
        try {
            cs[0] = Class.forName("Jama.Matrix");
            cs[1] = Class.forName("Jama.CholeskyDecomposition");
            cs[2] = Class.forName("Jama.EigenvalueDecomposition");
            cs[3] = Class.forName("Jama.LUDecomposition");
            cs[4] = Class.forName("Jama.QRDecomposition");
            cs[5] = Class.forName("Jama.SingularValueDecomposition");
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("you need to install Jama from http://math.nist.gov/javanumerics/jama/");
        }
        return cs;
    }

    private static Method[] constructMethods() {
        Method[] ms = new Method[7];
        try {
            Class[] param = new Class[]{};
            ms[0] = classSingularValueDecomposition.getMethod("getU", param);
            ms[1] = classSingularValueDecomposition.getMethod("getS", param);
            ms[2] = classSingularValueDecomposition.getMethod("getV", param);
            ms[3] = classSingularValueDecomposition.getMethod("getSingularValues", param);
            ms[4] = classSingularValueDecomposition.getMethod("cond", param);
            ms[5] = classSingularValueDecomposition.getMethod("norm2", param);
            ms[6] = classSingularValueDecomposition.getMethod("rank", param);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        return ms;
    }

    private static Constructor constructConstructor() {
        try {
            Class[] param = new Class[]{classMatrix};
            return classSingularValueDecomposition.getConstructor(param);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            return null;
        }
    }

    public JamaSingularValueDecomposition(JamaMatrix matrix) throws VisADException, RemoteException, IllegalAccessException, InstantiationException, InvocationTargetException {
        this(matrixSVDecomposition.newInstance(matrix.getMatrix()), false);
    }

    JamaSingularValueDecomposition(Object sv, boolean copy) throws VisADException, RemoteException, IllegalAccessException, InstantiationException, InvocationTargetException {
        super(JamaSingularValueDecomposition.makeDatums(sv), copy);
    }

    private static Data[] makeDatums(Object sv) throws VisADException, RemoteException, IllegalAccessException, InstantiationException, InvocationTargetException {
        Object u = getU.invoke(sv, new Object[0]);
        JamaMatrix ju = new JamaMatrix(u, SVUType, null, null, null, null, null);
        ju.setStash(sv);
        Object v = getV.invoke(sv, new Object[0]);
        JamaMatrix jv = new JamaMatrix(v, SVVType, null, null, null, null, null);
        double[] singular = (double[])getSingularValues.invoke(sv, new Object[0]);
        FlatField sf = new FlatField(singularType, new Integer1DSet(singular.length));
        sf.setSamples(new double[][]{singular});
        return new Data[]{ju, jv, sf};
    }

    public Object getSVDecomposition() {
        return this.svd;
    }

    public JamaMatrix getU() throws VisADException, RemoteException {
        if (classSingularValueDecomposition == null) {
            throw new VisADException("you need to install Jama from http://math.nist.gov/javanumerics/jama/");
        }
        return (JamaMatrix)this.getComponent(0);
    }

    public JamaMatrix getV() throws VisADException, RemoteException {
        if (classSingularValueDecomposition == null) {
            throw new VisADException("you need to install Jama from http://math.nist.gov/javanumerics/jama/");
        }
        return (JamaMatrix)this.getComponent(1);
    }

    public JamaMatrix getS() throws VisADException, RemoteException, IllegalAccessException, InstantiationException, InvocationTargetException {
        if (classSingularValueDecomposition == null) {
            throw new VisADException("you need to install Jama from http://math.nist.gov/javanumerics/jama/");
        }
        Object m = getS.invoke(this.svd, new Object[0]);
        return new JamaMatrix(m, SVSType, null, null, null, null, null);
    }

    public double[] getSingularValues() throws VisADException, RemoteException {
        if (classSingularValueDecomposition == null) {
            throw new VisADException("you need to install Jama from http://math.nist.gov/javanumerics/jama/");
        }
        FlatField sf = (FlatField)this.getComponent(2);
        double[][] s = sf.getValues(false);
        return s[0];
    }

    public double cond() throws VisADException, RemoteException, IllegalAccessException, InstantiationException, InvocationTargetException {
        if (classSingularValueDecomposition == null) {
            throw new VisADException("you need to install Jama from http://math.nist.gov/javanumerics/jama/");
        }
        double val = (Double)cond.invoke(this.svd, new Object[0]);
        return val;
    }

    public double norm2() throws VisADException, RemoteException, IllegalAccessException, InstantiationException, InvocationTargetException {
        if (classSingularValueDecomposition == null) {
            throw new VisADException("you need to install Jama from http://math.nist.gov/javanumerics/jama/");
        }
        double val = (Double)norm2.invoke(this.svd, new Object[0]);
        return val;
    }

    public int rank() throws VisADException, RemoteException, IllegalAccessException, InstantiationException, InvocationTargetException {
        if (classSingularValueDecomposition == null) {
            throw new VisADException("you need to install Jama from http://math.nist.gov/javanumerics/jama/");
        }
        int val = (Integer)rank.invoke(this.svd, new Object[0]);
        return val;
    }
}

