/*
 * Decompiled with CFR 0.152.
 */
package visad.java3d;

import java.awt.AWTEvent;
import java.awt.event.KeyEvent;
import java.rmi.RemoteException;
import java.util.Enumeration;
import javax.media.j3d.Behavior;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.WakeupCondition;
import javax.media.j3d.WakeupCriterion;
import javax.media.j3d.WakeupOnAWTEvent;
import javax.media.j3d.WakeupOr;
import javax.vecmath.Point3d;
import visad.Display;
import visad.DisplayEvent;
import visad.DisplayImpl;
import visad.DisplayRenderer;
import visad.KeyboardBehavior;
import visad.MouseBehavior;
import visad.ProjectionControl;
import visad.VisADException;
import visad.java3d.DisplayRendererJ3D;

public class KeyboardBehaviorJ3D
extends Behavior
implements KeyboardBehavior {
    private ProjectionControl proj;
    private DisplayRenderer displayRenderer;
    private MouseBehavior mouseBehavior;
    private double rotateAmount = 5.0;
    private double scaleAmount = 0.05;
    private double transAmount = 0.1;
    public static final int ROTATE_Z_POS = 7;
    public static final int ROTATE_Z_NEG = 8;
    public static final int ROTATE_X_POS = 9;
    public static final int ROTATE_X_NEG = 10;
    public static final int ROTATE_Y_POS = 11;
    public static final int ROTATE_Y_NEG = 12;
    private int MAX_FUNCTIONS;
    private int[] functionKeys = null;
    private int[] functionMods = null;
    protected WakeupCondition wakeupCondition = null;

    public KeyboardBehaviorJ3D(DisplayRendererJ3D r) {
        this.displayRenderer = r;
        boolean mode2D = this.displayRenderer.getMode2D();
        this.proj = this.displayRenderer.getDisplay().getProjectionControl();
        this.mouseBehavior = this.displayRenderer.getMouseBehavior();
        WakeupCriterion[] wakeupCriteria = new WakeupCriterion[]{new WakeupOnAWTEvent(401), new WakeupOnAWTEvent(402)};
        this.wakeupCondition = new WakeupOr(wakeupCriteria);
        BoundingSphere bounds = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 2000000.0);
        this.setSchedulingBounds((Bounds)bounds);
        this.MAX_FUNCTIONS = 13;
        this.functionKeys = new int[this.MAX_FUNCTIONS];
        this.functionMods = new int[this.MAX_FUNCTIONS];
        this.mapKeyToFunction(0, 38, mode2D ? 0 : 2);
        this.mapKeyToFunction(1, 40, mode2D ? 0 : 2);
        this.mapKeyToFunction(2, 37, mode2D ? 0 : 2);
        this.mapKeyToFunction(3, 39, mode2D ? 0 : 2);
        this.mapKeyToFunction(4, 38, 1);
        this.mapKeyToFunction(5, 40, 1);
        this.mapKeyToFunction(6, 82, 2);
        this.mapKeyToFunction(9, 40, 0);
        this.mapKeyToFunction(10, 38, 0);
        this.mapKeyToFunction(11, 37, 0);
        this.mapKeyToFunction(12, 39, 0);
        this.mapKeyToFunction(7, 37, 1);
        this.mapKeyToFunction(8, 39, 1);
    }

    public KeyboardBehaviorJ3D(DisplayRendererJ3D r, int num_functions) {
        this.displayRenderer = r;
        boolean mode2D = this.displayRenderer.getMode2D();
        this.proj = this.displayRenderer.getDisplay().getProjectionControl();
        this.mouseBehavior = this.displayRenderer.getMouseBehavior();
        WakeupCriterion[] wakeupCriteria = new WakeupCriterion[]{new WakeupOnAWTEvent(401), new WakeupOnAWTEvent(402)};
        this.wakeupCondition = new WakeupOr(wakeupCriteria);
        BoundingSphere bounds = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 2000000.0);
        this.setSchedulingBounds((Bounds)bounds);
        this.MAX_FUNCTIONS = num_functions;
        this.functionKeys = new int[this.MAX_FUNCTIONS];
        this.functionMods = new int[this.MAX_FUNCTIONS];
    }

    public void initialize() {
        this.wakeupOn(this.wakeupCondition);
    }

    public void processStimulus(Enumeration criteria) {
        while (criteria.hasMoreElements()) {
            WakeupCriterion genericEvent = (WakeupCriterion)criteria.nextElement();
            if (genericEvent instanceof WakeupOnAWTEvent) {
                WakeupOnAWTEvent event = (WakeupOnAWTEvent)genericEvent;
                AWTEvent[] events = event.getAWTEvent();
                int i = 0;
                while (i < events.length) {
                    if (events[i] instanceof KeyEvent) {
                        this.processKeyEvent((KeyEvent)events[i]);
                    }
                    ++i;
                }
            }
            this.wakeupOn(this.wakeupCondition);
        }
    }

    public void mapKeyToFunction(int function, int keycode, int modifiers) {
        if (function < 0 || function >= this.MAX_FUNCTIONS) {
            return;
        }
        this.functionKeys[function] = keycode;
        this.functionMods[function] = modifiers;
    }

    public void processKeyEvent(KeyEvent event) {
        int id = event.getID();
        if (id == 401) {
            int modifiers = event.getModifiers();
            int keyCode = event.getKeyCode();
            int i = 0;
            while (i < this.MAX_FUNCTIONS) {
                if (this.functionKeys[i] == keyCode && modifiers == this.functionMods[i]) {
                    this.execFunction(i);
                    break;
                }
                ++i;
            }
        }
        int d_id = -1;
        if (id == 401) {
            d_id = 16;
        } else if (id == 402) {
            d_id = 17;
        }
        if (d_id != -1) {
            try {
                DisplayImpl display = this.displayRenderer.getDisplay();
                DisplayEvent e = new DisplayEvent((Display)display, d_id, event);
                display.notifyListeners(e);
            }
            catch (VisADException exc) {
            }
            catch (RemoteException exc) {
                // empty catch block
            }
        }
    }

    public void execFunction(int function) {
        double transx = 0.0;
        double transy = 0.0;
        double scale = 1.0;
        double anglez = 0.0;
        double angley = 0.0;
        double anglex = 0.0;
        double[] t1 = null;
        double[] tstart = this.proj.getMatrix();
        switch (function) {
            case 10: {
                if (this.displayRenderer.getMode2D()) break;
                t1 = this.mouseBehavior.make_matrix(anglex += this.rotateAmount, angley, 0.0, 1.0, 0.0, 0.0, 0.0);
                break;
            }
            case 9: {
                if (this.displayRenderer.getMode2D()) break;
                t1 = this.mouseBehavior.make_matrix(anglex -= this.rotateAmount, angley, 0.0, 1.0, 0.0, 0.0, 0.0);
                break;
            }
            case 11: {
                if (this.displayRenderer.getMode2D()) break;
                t1 = this.mouseBehavior.make_matrix(anglex, angley += this.rotateAmount, 0.0, 1.0, 0.0, 0.0, 0.0);
                break;
            }
            case 12: {
                if (this.displayRenderer.getMode2D()) break;
                t1 = this.mouseBehavior.make_matrix(anglex, angley -= this.rotateAmount, 0.0, 1.0, 0.0, 0.0, 0.0);
                break;
            }
            case 7: {
                t1 = this.mouseBehavior.make_matrix(0.0, 0.0, anglez -= this.rotateAmount, 1.0, 0.0, 0.0, 0.0);
                break;
            }
            case 8: {
                t1 = this.mouseBehavior.make_matrix(0.0, 0.0, anglez += this.rotateAmount, 1.0, 0.0, 0.0, 0.0);
                break;
            }
            case 0: {
                t1 = this.mouseBehavior.make_matrix(0.0, 0.0, 0.0, 1.0, transx, transy += this.transAmount, 0.0);
                break;
            }
            case 1: {
                t1 = this.mouseBehavior.make_matrix(0.0, 0.0, 0.0, 1.0, transx, transy -= this.transAmount, 0.0);
                break;
            }
            case 2: {
                t1 = this.mouseBehavior.make_matrix(0.0, 0.0, 0.0, 1.0, transx -= this.transAmount, transy, 0.0);
                break;
            }
            case 3: {
                t1 = this.mouseBehavior.make_matrix(0.0, 0.0, 0.0, 1.0, transx += this.transAmount, transy, 0.0);
                break;
            }
            case 4: {
                t1 = this.mouseBehavior.make_matrix(0.0, 0.0, 0.0, scale += this.scaleAmount, 0.0, 0.0, 0.0);
                break;
            }
            case 5: {
                t1 = this.mouseBehavior.make_matrix(0.0, 0.0, 0.0, scale -= this.scaleAmount, 0.0, 0.0, 0.0);
                break;
            }
            case 6: {
                tstart = this.proj.getSavedProjectionMatrix();
                t1 = this.mouseBehavior.make_matrix(0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0);
                break;
            }
        }
        if (t1 != null) {
            t1 = this.mouseBehavior.multiply_matrix(t1, tstart);
            try {
                this.proj.setMatrix(t1);
            }
            catch (VisADException e) {
            }
            catch (RemoteException e) {
                // empty catch block
            }
        }
    }
}

