/*
 * Decompiled with CFR 0.152.
 */
package visad.java3d;

import javax.media.j3d.AmbientLight;
import javax.media.j3d.Appearance;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.ColoringAttributes;
import javax.media.j3d.DirectionalLight;
import javax.media.j3d.Geometry;
import javax.media.j3d.LineArray;
import javax.media.j3d.Node;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Switch;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.View;
import javax.vecmath.Color3f;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3f;
import visad.VisADException;
import visad.java3d.DisplayRendererJ3D;
import visad.java3d.VisADCanvasJ3D;
import visad.java3d.WandBehaviorJ3D;

public class ImmersaDeskDisplayRendererJ3D
extends DisplayRendererJ3D {
    private ColoringAttributes box_color = null;
    private ColoringAttributes cursor_color = null;
    private LineArray ray_geometry = null;
    private ColoringAttributes ray_color = null;
    private Switch ray_switch = null;
    private BranchGroup ray_on = null;
    private BranchGroup ray_off = null;
    private boolean rayOn = false;
    private WandBehaviorJ3D wand = null;
    private static final float[] box_verts = new float[]{-1.0f, -1.0f, 1.0f, -1.0f, 1.0f, 1.0f, -1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, -1.0f, 1.0f, 1.0f, -1.0f, 1.0f, -1.0f, -1.0f, 1.0f, -1.0f, -1.0f, -1.0f, -1.0f, 1.0f, -1.0f, -1.0f, 1.0f, -1.0f, 1.0f, 1.0f, -1.0f, 1.0f, 1.0f, -1.0f, 1.0f, -1.0f, -1.0f, 1.0f, -1.0f, -1.0f, -1.0f, -1.0f, -1.0f, -1.0f, -1.0f, 1.0f, -1.0f, -1.0f, -1.0f, -1.0f, 1.0f, 1.0f, -1.0f, 1.0f, -1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, -1.0f, 1.0f, -1.0f, 1.0f, 1.0f, -1.0f, -1.0f};
    private static final float[] cursor_verts = new float[]{0.0f, 0.0f, 0.1f, 0.0f, 0.0f, -0.1f, 0.0f, 0.1f, 0.0f, 0.0f, -0.1f, 0.0f, 0.1f, 0.0f, 0.0f, -0.1f, 0.0f, 0.0f};
    private static final float[] init_ray_verts = new float[]{0.0f, 0.0f, 0.0f, 0.0f, 0.0f, -10.0f};

    public ImmersaDeskDisplayRendererJ3D(int tracker_shmkey, int controller_shmkey) throws VisADException {
        this.wand = new WandBehaviorJ3D(this, tracker_shmkey, controller_shmkey);
    }

    public BranchGroup createSceneGraph(View v, TransformGroup vpt, VisADCanvasJ3D c) {
        BranchGroup root = this.getRoot();
        if (root != null) {
            return root;
        }
        this.getDisplay().setMouseBehavior(this.wand);
        this.box_color = new ColoringAttributes();
        this.cursor_color = new ColoringAttributes();
        root = this.createBasicSceneGraph(v, vpt, c, this.wand, this.box_color, this.cursor_color);
        TransformGroup trans = this.getTrans();
        this.wand.initialize();
        LineArray box_geometry = new LineArray(24, 1);
        box_geometry.setCapability(1);
        box_geometry.setCoordinates(0, box_verts);
        Appearance box_appearance = new Appearance();
        this.box_color.setCapability(0);
        this.box_color.setCapability(1);
        float[] ctlBox = this.getRendererControl().getBoxColor();
        this.box_color.setColor(ctlBox[0], ctlBox[1], ctlBox[2]);
        box_appearance.setColoringAttributes(this.box_color);
        Shape3D box = new Shape3D((Geometry)box_geometry, box_appearance);
        box.setCapability(12);
        BranchGroup box_on = this.getBoxOnBranch();
        box_on.addChild((Node)box);
        Appearance cursor_appearance = new Appearance();
        this.cursor_color.setCapability(0);
        this.cursor_color.setCapability(1);
        float[] ctlCursor = this.getRendererControl().getCursorColor();
        this.cursor_color.setColor(ctlCursor[0], ctlCursor[1], ctlCursor[2]);
        cursor_appearance.setColoringAttributes(this.cursor_color);
        BranchGroup cursor_on = this.getCursorOnBranch();
        LineArray cursor_geometry = new LineArray(6, 1);
        cursor_geometry.setCoordinates(0, cursor_verts);
        Shape3D cursor = new Shape3D((Geometry)cursor_geometry, cursor_appearance);
        cursor_on.addChild((Node)cursor);
        this.ray_switch = new Switch();
        this.ray_switch.setCapability(17);
        this.ray_switch.setCapability(18);
        trans.addChild((Node)this.ray_switch);
        this.ray_on = new BranchGroup();
        this.ray_on.setCapability(12);
        this.ray_on.setCapability(13);
        this.ray_off = new BranchGroup();
        this.ray_switch.addChild((Node)this.ray_off);
        this.ray_switch.addChild((Node)this.ray_on);
        this.ray_switch.setWhichChild(1);
        this.ray_geometry = new LineArray(2, 1);
        this.ray_geometry.setCoordinates(0, init_ray_verts);
        this.ray_geometry.setCapability(0);
        this.ray_geometry.setCapability(1);
        Appearance ray_appearance = new Appearance();
        this.ray_color = new ColoringAttributes();
        this.ray_color.setCapability(0);
        this.ray_color.setCapability(1);
        this.ray_color.setColor(1.0f, 1.0f, 1.0f);
        ray_appearance.setColoringAttributes(this.ray_color);
        Shape3D ray = new Shape3D((Geometry)this.ray_geometry, ray_appearance);
        this.ray_on.addChild((Node)ray);
        Color3f color = new Color3f(0.6f, 0.6f, 0.6f);
        AmbientLight light = new AmbientLight(color);
        BoundingSphere bounds = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 2000000.0);
        light.setInfluencingBounds((Bounds)bounds);
        root.addChild((Node)light);
        Color3f dcolor = new Color3f(0.9f, 0.9f, 0.9f);
        Vector3f direction1 = new Vector3f(0.0f, 0.0f, 1.0f);
        Vector3f direction2 = new Vector3f(0.0f, 0.0f, -1.0f);
        DirectionalLight light1 = new DirectionalLight(true, dcolor, direction1);
        light1.setInfluencingBounds((Bounds)bounds);
        DirectionalLight light2 = new DirectionalLight(true, dcolor, direction2);
        light2.setInfluencingBounds((Bounds)bounds);
        root.addChild((Node)light1);
        root.addChild((Node)light2);
        return root;
    }

    public void setRayOn(boolean on, float[] ray_verts) {
        this.rayOn = on;
        if (this.ray_switch != null) {
            if (on) {
                this.ray_geometry.setCoordinates(0, ray_verts);
                this.ray_switch.setWhichChild(1);
            } else {
                this.ray_switch.setWhichChild(0);
            }
        }
    }

    public void setBoxAspect(double[] aspect) {
        float[] new_verts = new float[box_verts.length];
        int i = 0;
        while (i < box_verts.length) {
            new_verts[i] = (float)((double)box_verts[i] * aspect[0]);
            new_verts[i + 1] = (float)((double)box_verts[i + 1] * aspect[1]);
            new_verts[i + 2] = (float)((double)box_verts[i + 2] * aspect[2]);
            i += 3;
        }
        BranchGroup box_on = this.getBoxOnBranch();
        Shape3D box = (Shape3D)box_on.getChild(0);
        LineArray box_geometry = (LineArray)box.getGeometry();
        box_geometry.setCoordinates(0, new_verts);
    }
}

