/*
 * Decompiled with CFR 0.152.
 */
package visad.java3d;

import com.sun.j3d.utils.applet.MainFrame;
import java.applet.Applet;
import java.awt.Component;
import java.awt.GraphicsConfiguration;
import java.rmi.RemoteException;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.GeometryArray;
import javax.media.j3d.IndexedTriangleStripArray;
import javax.media.j3d.LineArray;
import javax.media.j3d.LineStripArray;
import javax.media.j3d.PointArray;
import javax.media.j3d.QuadArray;
import javax.media.j3d.Screen3D;
import javax.media.j3d.TriangleArray;
import javax.media.j3d.TriangleStripArray;
import visad.DisplayException;
import visad.DisplayImpl;
import visad.DisplayRenderer;
import visad.GraphicsModeControl;
import visad.ProjectionControl;
import visad.RemoteDisplay;
import visad.VisADException;
import visad.VisADGeometryArray;
import visad.VisADIndexedTriangleStripArray;
import visad.VisADLineArray;
import visad.VisADLineStripArray;
import visad.VisADPointArray;
import visad.VisADQuadArray;
import visad.VisADTriangleArray;
import visad.VisADTriangleStripArray;
import visad.java3d.DefaultDisplayRendererJ3D;
import visad.java3d.DisplayAppletJ3D;
import visad.java3d.DisplayPanelJ3D;
import visad.java3d.DisplayRendererJ3D;
import visad.java3d.GraphicsModeControlJ3D;
import visad.java3d.ProjectionControlJ3D;
import visad.java3d.TransformOnlyDisplayRendererJ3D;
import visad.java3d.UniverseBuilderJ3D;
import visad.java3d.VisADCanvasJ3D;

public class DisplayImplJ3D
extends DisplayImpl {
    public static final float BACK2D = -2.0f;
    public static final int PARALLEL_PROJECTION = 0;
    public static final int PERSPECTIVE_PROJECTION = 1;
    public static final int POLYGON_FILL = 2;
    public static final int POLYGON_LINE = 1;
    public static final int POLYGON_POINT = 0;
    public static final int NICEST = 1;
    public static final int FASTEST = 0;
    public static final int UNKNOWN = 0;
    public static final int JPANEL = 1;
    public static final int OFFSCREEN = 2;
    public static final int APPLETFRAME = 3;
    public static final int TRANSFORM_ONLY = 4;
    private DisplayAppletJ3D applet = null;
    private ProjectionControlJ3D projection = null;
    private GraphicsModeControlJ3D mode = null;
    private int apiValue = 0;

    public DisplayImplJ3D(String name) throws VisADException, RemoteException {
        this(name, null, 1, null);
    }

    public DisplayImplJ3D(String name, DisplayRendererJ3D renderer) throws VisADException, RemoteException {
        this(name, renderer, 1, null);
    }

    public DisplayImplJ3D(String name, int api) throws VisADException, RemoteException {
        this(name, null, api, null);
    }

    public DisplayImplJ3D(String name, GraphicsConfiguration config) throws VisADException, RemoteException {
        this(name, null, 1, config);
    }

    public DisplayImplJ3D(String name, DisplayRendererJ3D renderer, int api) throws VisADException, RemoteException {
        this(name, renderer, api, null);
    }

    public DisplayImplJ3D(String name, DisplayRendererJ3D renderer, GraphicsConfiguration config) throws VisADException, RemoteException {
        this(name, renderer, 1, config);
    }

    public DisplayImplJ3D(String name, int api, GraphicsConfiguration config) throws VisADException, RemoteException {
        this(name, null, api, config);
    }

    public DisplayImplJ3D(String name, DisplayRendererJ3D renderer, int api, GraphicsConfiguration config) throws VisADException, RemoteException {
        this(name, renderer, api, config, null);
    }

    public DisplayImplJ3D(String name, DisplayRendererJ3D renderer, int api, GraphicsConfiguration config, VisADCanvasJ3D c) throws VisADException, RemoteException {
        super(name, (DisplayRenderer)renderer);
        this.initialize(api, config, c);
    }

    public DisplayImplJ3D(String name, int width, int height) throws VisADException, RemoteException {
        this(name, null, width, height);
    }

    public DisplayImplJ3D(String name, DisplayRendererJ3D renderer, int width, int height) throws VisADException, RemoteException {
        this(name, renderer, width, height, null);
    }

    public DisplayImplJ3D(String name, DisplayRendererJ3D renderer, int width, int height, VisADCanvasJ3D c) throws VisADException, RemoteException {
        super(name, (DisplayRenderer)renderer);
        this.initialize(2, null, width, height, c);
    }

    public DisplayImplJ3D(RemoteDisplay rmtDpy) throws VisADException, RemoteException {
        this(rmtDpy, null, rmtDpy.getDisplayAPI(), null);
    }

    public DisplayImplJ3D(RemoteDisplay rmtDpy, DisplayRendererJ3D renderer) throws VisADException, RemoteException {
        this(rmtDpy, renderer, rmtDpy.getDisplayAPI(), null);
    }

    public DisplayImplJ3D(RemoteDisplay rmtDpy, int api) throws VisADException, RemoteException {
        this(rmtDpy, null, api, null);
    }

    public DisplayImplJ3D(RemoteDisplay rmtDpy, GraphicsConfiguration config) throws VisADException, RemoteException {
        this(rmtDpy, null, rmtDpy.getDisplayAPI(), config);
    }

    public DisplayImplJ3D(RemoteDisplay rmtDpy, DisplayRendererJ3D renderer, int api) throws VisADException, RemoteException {
        this(rmtDpy, renderer, api, null);
    }

    public DisplayImplJ3D(RemoteDisplay rmtDpy, DisplayRendererJ3D renderer, GraphicsConfiguration config) throws VisADException, RemoteException {
        this(rmtDpy, renderer, rmtDpy.getDisplayAPI(), config);
    }

    public DisplayImplJ3D(RemoteDisplay rmtDpy, int api, GraphicsConfiguration config) throws VisADException, RemoteException {
        this(rmtDpy, null, api, config);
    }

    public DisplayImplJ3D(RemoteDisplay rmtDpy, DisplayRendererJ3D renderer, int api, GraphicsConfiguration config) throws VisADException, RemoteException {
        this(rmtDpy, renderer, api, config, null);
    }

    public DisplayImplJ3D(RemoteDisplay rmtDpy, DisplayRendererJ3D renderer, int api, GraphicsConfiguration config, VisADCanvasJ3D c) throws VisADException, RemoteException {
        super(rmtDpy, (DisplayRenderer)(renderer == null && api == 4 ? new TransformOnlyDisplayRendererJ3D() : renderer));
        this.initialize(api, config, c);
        this.syncRemoteData(rmtDpy);
    }

    public DisplayImplJ3D(RemoteDisplay rmtDpy, TransformOnlyDisplayRendererJ3D renderer, GraphicsConfiguration config) throws VisADException, RemoteException {
        super(rmtDpy, renderer, true);
        this.initialize(4, config);
        this.syncRemoteData(rmtDpy);
    }

    private void initialize(int api, GraphicsConfiguration config) throws VisADException, RemoteException {
        this.initialize(api, config, -1, -1, null);
    }

    private void initialize(int api, GraphicsConfiguration config, VisADCanvasJ3D c) throws VisADException, RemoteException {
        this.initialize(api, config, -1, -1, c);
    }

    private void initialize(int api, GraphicsConfiguration config, int width, int height) throws VisADException, RemoteException {
        this.initialize(api, config, width, height, null);
    }

    private void initialize(int api, GraphicsConfiguration config, int width, int height, VisADCanvasJ3D c) throws VisADException, RemoteException {
        this.projection = new ProjectionControlJ3D(this);
        this.addControl(this.projection);
        if (api == 3) {
            this.applet = new DisplayAppletJ3D(this, config);
            MainFrame component = new MainFrame((Applet)this.applet, 256, 256);
            this.setComponent((Component)component);
            this.apiValue = api;
        } else if (api == 1) {
            DisplayPanelJ3D component = new DisplayPanelJ3D(this, config, c);
            this.setComponent(component);
            this.apiValue = api;
        } else if (api == 4) {
            if (!(this.getDisplayRenderer() instanceof TransformOnlyDisplayRendererJ3D)) {
                throw new DisplayException("must be TransformOnlyDisplayRendererJ3D for api = TRANSFORM_ONLY");
            }
            this.setComponent(null);
            this.apiValue = api;
        } else if (api == 2) {
            DisplayRendererJ3D renderer = (DisplayRendererJ3D)this.getDisplayRenderer();
            VisADCanvasJ3D canvas = c != null ? c : new VisADCanvasJ3D(renderer, width, height);
            UniverseBuilderJ3D universe = new UniverseBuilderJ3D(canvas);
            BranchGroup scene = renderer.createSceneGraph(universe.view, universe.vpTrans, canvas);
            universe.addBranchGraph(scene);
            this.setComponent(null);
            this.apiValue = api;
        } else {
            throw new DisplayException("DisplayImplJ3D: bad graphics API " + api);
        }
        if (api != 4) {
            this.projection.setAspect(new double[]{1.0, 1.0, 1.0});
            ((DisplayRendererJ3D)this.getDisplayRenderer()).getCanvas().setDisplay();
        }
        this.mode = new GraphicsModeControlJ3D(this);
        this.addControl(this.mode);
    }

    protected DisplayRenderer getDefaultDisplayRenderer() {
        return new DefaultDisplayRendererJ3D();
    }

    public void setScreenAspect(double height, double width) {
        DisplayRendererJ3D dr = (DisplayRendererJ3D)this.getDisplayRenderer();
        Screen3D screen = dr.getCanvas().getScreen3D();
        screen.setPhysicalScreenHeight(height);
        screen.setPhysicalScreenWidth(width);
    }

    public ProjectionControl getProjectionControl() {
        return this.projection;
    }

    public GraphicsModeControl getGraphicsModeControl() {
        return this.mode;
    }

    public DisplayAppletJ3D getApplet() {
        return this.applet;
    }

    public int getAPI() throws VisADException {
        return this.apiValue;
    }

    public GeometryArray makeGeometry(VisADGeometryArray vga) throws VisADException {
        if (vga == null) {
            return null;
        }
        boolean mode2d = this.getDisplayRenderer().getMode2D();
        if (vga instanceof VisADIndexedTriangleStripArray) {
            VisADIndexedTriangleStripArray vgb = (VisADIndexedTriangleStripArray)vga;
            if (vga.vertexCount == 0) {
                return null;
            }
            IndexedTriangleStripArray array = new IndexedTriangleStripArray(vga.vertexCount, DisplayImplJ3D.makeFormat(vga), vgb.indexCount, vgb.stripVertexCounts);
            this.basicGeometry(vga, (GeometryArray)array, mode2d);
            if (vga.coordinates != null) {
                array.setCoordinateIndices(0, vgb.indices);
            }
            if (vga.colors != null) {
                array.setColorIndices(0, vgb.indices);
            }
            if (vga.normals != null) {
                array.setNormalIndices(0, vgb.indices);
            }
            if (vga.texCoords != null) {
                array.setTextureCoordinateIndices(0, vgb.indices);
            }
            return array;
        }
        if (vga instanceof VisADTriangleStripArray) {
            VisADTriangleStripArray vgb = (VisADTriangleStripArray)vga;
            if (vga.vertexCount == 0) {
                return null;
            }
            TriangleStripArray array = new TriangleStripArray(vga.vertexCount, DisplayImplJ3D.makeFormat(vga), vgb.stripVertexCounts);
            this.basicGeometry(vga, (GeometryArray)array, mode2d);
            return array;
        }
        if (vga instanceof VisADLineArray) {
            if (vga.vertexCount == 0) {
                return null;
            }
            LineArray array = new LineArray(vga.vertexCount, DisplayImplJ3D.makeFormat(vga));
            this.basicGeometry(vga, (GeometryArray)array, false);
            return array;
        }
        if (vga instanceof VisADLineStripArray) {
            if (vga.vertexCount == 0) {
                return null;
            }
            VisADLineStripArray vgb = (VisADLineStripArray)vga;
            LineStripArray array = new LineStripArray(vga.vertexCount, DisplayImplJ3D.makeFormat(vga), vgb.stripVertexCounts);
            this.basicGeometry(vga, (GeometryArray)array, false);
            return array;
        }
        if (vga instanceof VisADPointArray) {
            if (vga.vertexCount == 0) {
                return null;
            }
            PointArray array = new PointArray(vga.vertexCount, DisplayImplJ3D.makeFormat(vga));
            this.basicGeometry(vga, (GeometryArray)array, false);
            return array;
        }
        if (vga instanceof VisADTriangleArray) {
            if (vga.vertexCount == 0) {
                return null;
            }
            TriangleArray array = new TriangleArray(vga.vertexCount, DisplayImplJ3D.makeFormat(vga));
            this.basicGeometry(vga, (GeometryArray)array, mode2d);
            return array;
        }
        if (vga instanceof VisADQuadArray) {
            if (vga.vertexCount == 0) {
                return null;
            }
            QuadArray array = new QuadArray(vga.vertexCount, DisplayImplJ3D.makeFormat(vga));
            this.basicGeometry(vga, (GeometryArray)array, mode2d);
            return array;
        }
        throw new DisplayException("DisplayImplJ3D.makeGeometry");
    }

    private void basicGeometry(VisADGeometryArray vga, GeometryArray array, boolean mode2d) {
        if (mode2d) {
            if (vga.coordinates != null) {
                int len = vga.coordinates.length;
                float[] coords = new float[len];
                System.arraycopy(vga.coordinates, 0, coords, 0, len);
                int i = 2;
                while (i < len) {
                    coords[i] = -2.0f;
                    i += 3;
                }
                array.setCoordinates(0, coords);
            }
        } else if (vga.coordinates != null) {
            array.setCoordinates(0, vga.coordinates);
        }
        if (vga.colors != null) {
            array.setColors(0, vga.colors);
        }
        if (vga.normals != null) {
            array.setNormals(0, vga.normals);
        }
        if (vga.texCoords != null) {
            array.setTextureCoordinates(0, vga.texCoords);
        }
    }

    private static int makeFormat(VisADGeometryArray vga) {
        int format = 0;
        if (vga.coordinates != null) {
            format |= 1;
        }
        if (vga.colors != null) {
            format = vga.colors.length == 3 * vga.vertexCount ? (format |= 4) : (format |= 0xC);
        }
        if (vga.normals != null) {
            format |= 2;
        }
        if (vga.texCoords != null) {
            format = vga.texCoords.length == 2 * vga.vertexCount ? (format |= 0x20) : (format |= 0x40);
        }
        return format;
    }

    public void destroy() throws VisADException, RemoteException {
        ((DisplayRendererJ3D)this.getDisplayRenderer()).destroy();
        super.destroy();
    }
}

