/*
 * Decompiled with CFR 0.152.
 */
package visad.java3d;

import java.rmi.RemoteException;
import javax.media.j3d.Appearance;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Geometry;
import javax.media.j3d.GeometryArray;
import javax.media.j3d.Group;
import javax.media.j3d.Node;
import javax.media.j3d.Shape3D;
import visad.BadDirectManipulationException;
import visad.Data;
import visad.DataDisplayLink;
import visad.Display;
import visad.DisplayException;
import visad.DisplayImpl;
import visad.GraphicsModeControl;
import visad.VisADException;
import visad.VisADGeometryArray;
import visad.VisADLineArray;
import visad.VisADPointArray;
import visad.collab.CollabUtil;
import visad.java3d.DisplayImplJ3D;
import visad.java3d.DisplayRendererJ3D;
import visad.java3d.RendererJ3D;
import visad.java3d.ShadowTypeJ3D;

public class DirectManipulationRendererJ3D
extends RendererJ3D {
    BranchGroup branch = null;

    public void setLinks(DataDisplayLink[] links, DisplayImpl d) throws VisADException {
        if (links == null || links.length != 1) {
            throw new DisplayException("DirectManipulationRendererJ3D.setLinks: must be exactly one DataDisplayLink");
        }
        super.setLinks(links, d);
    }

    public void checkDirect() throws VisADException, RemoteException {
        this.realCheckDirect();
    }

    public void addPoint(float[] x) throws VisADException {
        int count = x.length / 3;
        VisADGeometryArray array = null;
        if (count == 1) {
            array = new VisADPointArray();
        } else if (count == 2) {
            array = new VisADLineArray();
        } else {
            return;
        }
        array.coordinates = x;
        array.vertexCount = count;
        DisplayImplJ3D display = (DisplayImplJ3D)this.getDisplay();
        GeometryArray geometry = display.makeGeometry(array);
        DataDisplayLink[] Links = this.getLinks();
        if (Links == null || Links.length == 0) {
            return;
        }
        DataDisplayLink link = Links[0];
        float[] default_values = link.getDefaultValues();
        GraphicsModeControl mode = (GraphicsModeControl)display.getGraphicsModeControl().clone();
        float pointSize = default_values[display.getDisplayScalarIndex(Display.PointSize)];
        float lineWidth = default_values[display.getDisplayScalarIndex(Display.LineWidth)];
        int lineStyle = (int)default_values[display.getDisplayScalarIndex(Display.LineStyle)];
        mode.setPointSize(pointSize, true);
        mode.setLineWidth(lineWidth, true);
        mode.setLineStyle(lineStyle, true);
        Appearance appearance = ShadowTypeJ3D.makeAppearance(mode, null, null, geometry, false);
        Shape3D shape = new Shape3D((Geometry)geometry, appearance);
        BranchGroup group = new BranchGroup();
        group.setCapability(12);
        group.addChild((Node)shape);
        this.branch.addChild((Node)group);
    }

    public synchronized BranchGroup doTransform() throws VisADException, RemoteException {
        Data data;
        this.branch = new BranchGroup();
        this.branch.setCapability(17);
        this.branch.setCapability(12);
        this.branch.setCapability(13);
        this.branch.setCapability(14);
        DataDisplayLink[] Links = this.getLinks();
        if (Links == null || Links.length == 0) {
            return null;
        }
        DataDisplayLink link = Links[0];
        ShadowTypeJ3D shadow = (ShadowTypeJ3D)link.getShadow();
        if (!this.getIsDirectManipulation()) {
            throw new BadDirectManipulationException(this.getWhyNotDirect() + ": DirectManipulationRendererJ3D.doTransform");
        }
        int valueArrayLength = this.getDisplay().getValueArrayLength();
        float[] valueArray = new float[valueArrayLength];
        int i = 0;
        while (i < valueArrayLength) {
            valueArray[i] = Float.NaN;
            ++i;
        }
        try {
            data = link.getData();
        }
        catch (RemoteException re) {
            if (CollabUtil.isDisconnectException(re)) {
                this.getDisplay().connectionFailed(this, link);
                this.removeLink(link);
                return null;
            }
            throw re;
        }
        if (data == null) {
            this.branch = null;
            this.addException(new DisplayException("Data is null: DirectManipulationRendererJ3D.doTransform"));
        } else {
            try {
                shadow.doTransform(this.branch, data, valueArray, link.getDefaultValues(), this);
            }
            catch (RemoteException re) {
                if (CollabUtil.isDisconnectException(re)) {
                    this.getDisplay().connectionFailed(this, link);
                    this.removeLink(link);
                    return null;
                }
                throw re;
            }
        }
        return this.branch;
    }

    public void setBranch(BranchGroup b) {
        this.branch = b;
    }

    void addSwitch(DisplayRendererJ3D displayRenderer, BranchGroup branch) {
        displayRenderer.addDirectManipulationSceneGraphComponent((Group)branch, this);
    }

    public boolean isLegalTextureMap() {
        return false;
    }

    public Object clone() {
        return new DirectManipulationRendererJ3D();
    }
}

