/*
 * Decompiled with CFR 0.152.
 */
package visad.java3d;

import java.rmi.RemoteException;
import java.util.StringTokenizer;
import visad.AnimationControl;
import visad.AnimationSetControl;
import visad.Control;
import visad.DataDisplayLink;
import visad.DataRenderer;
import visad.DisplayException;
import visad.RealType;
import visad.Set;
import visad.ToggleControl;
import visad.VisADError;
import visad.VisADException;
import visad.browser.Convert;
import visad.java3d.AVControlJ3D;
import visad.java3d.DisplayImplJ3D;

public class AnimationControlJ3D
extends AVControlJ3D
implements Runnable,
AnimationControl {
    protected int current = 0;
    private boolean direction;
    private long step;
    private long[] stepValues = new long[]{500L};
    private transient AnimationSetControl animationSet;
    private ToggleControl animate;
    private RealType real;
    private transient Thread animationThread;

    public AnimationControlJ3D(DisplayImplJ3D d, RealType r) {
        super(d);
        this.real = r;
        this.current = 0;
        this.direction = true;
        this.step = 500L;
        this.stepValues = new long[]{this.step};
        this.animationSet = new AnimationSetControl(d, this);
        try {
            Set set = this.animationSet.getSet();
            if (set != null) {
                this.stepValues = new long[set.getLength()];
            }
        }
        catch (VisADException v) {
            // empty catch block
        }
        int i = 0;
        while (i < this.stepValues.length) {
            this.stepValues[i] = this.step;
            ++i;
        }
        d.addControl(this.animationSet);
        this.animate = new ToggleControl(d, this);
        d.addControl(this.animate);
        try {
            this.animate.setOn(false);
        }
        catch (VisADException v) {
        }
        catch (RemoteException v) {
            // empty catch block
        }
        if (d != null) {
            this.animationThread = new Thread(this);
            this.animationThread.start();
        }
    }

    AnimationControlJ3D() {
        this(null, null);
    }

    public void nullControl() {
        this.stop();
        super.nullControl();
    }

    public void stop() {
        this.animationThread = null;
    }

    public void run() {
        Thread me = Thread.currentThread();
        while (this.animationThread == me) {
            try {
                if (this.animate != null && this.animate.getOn()) {
                    this.takeStep();
                }
            }
            catch (VisADException v) {
                v.printStackTrace();
                throw new VisADError("AnimationControlJ3D.run: " + v.toString());
            }
            catch (RemoteException v) {
                v.printStackTrace();
                throw new VisADError("AnimationControlJ3D.run: " + v.toString());
            }
            try {
                AnimationControlJ3D v = this;
                synchronized (v) {
                    if (0 <= this.current && this.current < this.stepValues.length) {
                        this.wait(this.stepValues[this.current]);
                    } else {
                        this.wait(500L);
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public int getCurrent() {
        return this.current;
    }

    public void setCurrent(int c) throws VisADException, RemoteException {
        if (this.animationSet != null) {
            this.current = this.animationSet.clipCurrent(c);
            this.init();
        } else {
            this.current = 0;
        }
        this.changeControl(false);
    }

    public void setCurrent(double value) throws VisADException, RemoteException {
        if (this.animationSet != null) {
            this.current = this.animationSet.getIndex(value);
            this.init();
        } else {
            this.current = 0;
        }
        this.changeControl(false);
    }

    public void setDirection(boolean dir) throws VisADException, RemoteException {
        this.direction = dir;
        this.changeControl(false);
    }

    public boolean getDirection() {
        return this.direction;
    }

    public long getStep() {
        if (this.stepValues == null || this.current < 0 || this.stepValues.length <= this.current) {
            return 500L;
        }
        return this.stepValues[this.current];
    }

    public long[] getSteps() {
        return this.stepValues;
    }

    public void setStep(int st) throws VisADException, RemoteException {
        if (st <= 0) {
            throw new DisplayException("AnimationControlJ3D.setStep: step must be > 0");
        }
        this.step = st;
        int i = 0;
        while (i < this.stepValues.length) {
            this.stepValues[i] = st;
            ++i;
        }
        this.changeControl(false);
    }

    public void setSteps(int[] steps) throws VisADException, RemoteException {
        int i = 0;
        while (i < this.stepValues.length) {
            long l = this.stepValues[i] = i < steps.length ? (long)steps[i] : (long)steps[steps.length - 1];
            if (this.stepValues[i] <= 0L) {
                throw new DisplayException("AnimationControlJ3D.setSteps: step " + i + " must be > 0");
            }
            ++i;
        }
        this.changeControl(true);
    }

    public void takeStep() throws VisADException, RemoteException {
        this.current = this.direction ? ++this.current : --this.current;
        if (this.animationSet != null) {
            this.current = this.animationSet.clipCurrent(this.current);
            this.init();
        }
        this.changeControl(false);
    }

    public void init() throws VisADException {
        if (this.animationSet != null && this.animationSet.getSet() != null) {
            double value = this.animationSet.getValue(this.current);
            Set set = this.animationSet.getSet();
            this.animation_string(this.real, set, value, this.current);
            this.selectSwitches(value, set);
        }
    }

    public Set getSet() {
        if (this.animationSet != null) {
            return this.animationSet.getSet();
        }
        return null;
    }

    public void setSet(Set s) throws VisADException, RemoteException {
        this.setSet(s, false);
        if (s.getLength() != this.stepValues.length) {
            this.stepValues = new long[s.getLength()];
            int i = 0;
            while (i < this.stepValues.length) {
                this.stepValues[i] = this.step;
                ++i;
            }
        }
    }

    public void setSet(Set s, boolean noChange) throws VisADException, RemoteException {
        if (this.animationSet != null) {
            if (s.getLength() != this.stepValues.length) {
                this.stepValues = new long[s.getLength()];
                int i = 0;
                while (i < this.stepValues.length) {
                    this.stepValues[i] = this.step;
                    ++i;
                }
            }
            this.animationSet.setSet(s, noChange);
        }
    }

    public boolean getOn() {
        if (this.animate != null) {
            return this.animate.getOn();
        }
        return false;
    }

    public void setOn(boolean o) throws VisADException, RemoteException {
        if (this.animate != null) {
            this.animate.setOn(o);
        }
    }

    public void toggle() throws VisADException, RemoteException {
        if (this.animate != null) {
            this.animate.setOn(!this.animate.getOn());
        }
    }

    public RealType getRealType() {
        return this.real;
    }

    public void subSetTicks() {
        if (this.animationSet != null) {
            this.animationSet.setTicks();
        }
        if (this.animate != null) {
            this.animate.setTicks();
        }
    }

    public boolean subCheckTicks(DataRenderer r, DataDisplayLink link) {
        boolean flag = false;
        if (this.animationSet != null) {
            flag |= this.animationSet.checkTicks(r, link);
        }
        if (this.animate != null) {
            flag |= this.animate.checkTicks(r, link);
        }
        return flag;
    }

    public boolean subPeekTicks(DataRenderer r, DataDisplayLink link) {
        boolean flag = false;
        if (this.animationSet != null) {
            flag |= this.animationSet.peekTicks(r, link);
        }
        if (this.animate != null) {
            flag |= this.animate.peekTicks(r, link);
        }
        return flag;
    }

    public void subResetTicks() {
        if (this.animationSet != null) {
            this.animationSet.resetTicks();
        }
        if (this.animate != null) {
            this.animate.resetTicks();
        }
    }

    public String getSaveString() {
        long[] steps;
        int numSteps;
        if (this.stepValues == null) {
            numSteps = 1;
            steps = new long[]{500L};
        } else {
            numSteps = this.stepValues.length;
            steps = this.stepValues;
        }
        StringBuffer sb = new StringBuffer(35 + 12 * numSteps);
        sb.append(this.animate != null && this.animate.getOn());
        sb.append(' ');
        sb.append(this.direction);
        sb.append(' ');
        sb.append(this.current);
        sb.append(' ');
        sb.append(numSteps);
        int i = 0;
        while (i < numSteps) {
            sb.append(' ');
            sb.append((int)steps[i]);
            ++i;
        }
        return sb.toString();
    }

    public void setSaveString(String save) throws VisADException, RemoteException {
        if (save == null) {
            throw new VisADException("Invalid save string");
        }
        StringTokenizer st = new StringTokenizer(save);
        int numTokens = st.countTokens();
        if (numTokens < 4) {
            throw new VisADException("Invalid save string");
        }
        boolean on = Convert.getBoolean(st.nextToken());
        boolean dir = Convert.getBoolean(st.nextToken());
        int cur = Convert.getInt(st.nextToken());
        int numSteps = Convert.getInt(st.nextToken());
        if (numSteps <= 0) {
            throw new VisADException("Number of steps is not positive");
        }
        if (numTokens < 4 + numSteps) {
            throw new VisADException("Not enough step entries");
        }
        int[] steps = new int[numSteps];
        int i = 0;
        while (i < numSteps) {
            steps[i] = Convert.getInt(st.nextToken());
            if (steps[i] <= 0) {
                throw new VisADException("Step #" + (i + 1) + "is not positive");
            }
            ++i;
        }
        this.setOn(on);
        this.setDirection(dir);
        this.setSteps(steps);
        this.setCurrent(cur);
    }

    public void syncControl(Control rmt) throws VisADException {
        if (rmt == null) {
            throw new VisADException("Cannot synchronize " + this.getClass().getName() + " with null Control object");
        }
        if (!(rmt instanceof AnimationControlJ3D)) {
            throw new VisADException("Cannot synchronize " + this.getClass().getName() + " with " + rmt.getClass().getName());
        }
        AnimationControlJ3D ac = (AnimationControlJ3D)rmt;
        boolean changed = false;
        if (this.direction != ac.direction) {
            changed = true;
            this.direction = ac.direction;
        }
        if (this.step != ac.step) {
            changed = true;
            this.step = ac.step;
        }
        if (this.animate != ac.animate) {
            changed = true;
            this.animate = ac.animate;
        }
        if (this.real != ac.real) {
            changed = true;
            this.real = ac.real;
        }
        if (changed) {
            try {
                this.changeControl(false);
            }
            catch (RemoteException re) {
                throw new VisADException("Could not indicate that control changed: " + re.getMessage());
            }
        }
    }

    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        AnimationControlJ3D ac = (AnimationControlJ3D)o;
        if (this.direction != ac.direction) {
            return false;
        }
        if (this.step != ac.step) {
            return false;
        }
        if (this.animate != ac.animate) {
            return false;
        }
        return this.real == ac.real;
    }
}

