/*
 * Decompiled with CFR 0.152.
 */
package visad.java2d;

import java.util.Enumeration;
import java.util.Vector;
import visad.AVControl;
import visad.Control;
import visad.CoordinateSystem;
import visad.DataRenderer;
import visad.RealTupleType;
import visad.Set;
import visad.SetType;
import visad.VisADException;
import visad.VisADSwitch;
import visad.java2d.DisplayImplJ2D;

public abstract class AVControlJ2D
extends Control
implements AVControl {
    transient Vector switches = new Vector();

    public AVControlJ2D(DisplayImplJ2D d) {
        super(d);
    }

    void addPair(VisADSwitch sw, Set se, DataRenderer re) {
        this.switches.addElement(new SwitchSet(sw, se, re));
    }

    abstract void init() throws VisADException;

    public void selectSwitches(double value, Set animation_set) throws VisADException {
        if (value != value) {
            return;
        }
        double[][] fvalues = new double[1][1];
        fvalues[0][0] = value;
        Enumeration pairs = ((Vector)this.switches.clone()).elements();
        while (pairs.hasMoreElements()) {
            SwitchSet ss = (SwitchSet)pairs.nextElement();
            Set set = ss.set;
            double[][] values = null;
            RealTupleType out = ((SetType)set.getType()).getDomain();
            if (animation_set != null) {
                RealTupleType in = ((SetType)animation_set.getType()).getDomain();
                values = CoordinateSystem.transformCoordinates(out, set.getCoordinateSystem(), set.getSetUnits(), null, in, animation_set.getCoordinateSystem(), animation_set.getSetUnits(), null, fvalues);
            } else {
                values = CoordinateSystem.transformCoordinates(out, set.getCoordinateSystem(), set.getSetUnits(), null, out, out.getCoordinateSystem(), out.getDefaultUnits(), null, fvalues);
            }
            int[] indices = set.getLength() == 1 ? new int[]{0} : set.doubleToIndex(values);
            ss.swit.setWhichChild(indices[0]);
        }
    }

    public void clearSwitches(DataRenderer re) {
        Enumeration pairs = ((Vector)this.switches.clone()).elements();
        while (pairs.hasMoreElements()) {
            SwitchSet ss = (SwitchSet)pairs.nextElement();
            if (!ss.renderer.equals(re)) continue;
            this.switches.removeElement(ss);
        }
    }

    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        AVControlJ2D av = (AVControlJ2D)o;
        if (this.switches == null) {
            return av.switches == null;
        }
        if (av.switches != null) {
            if (this.switches.size() != av.switches.size()) {
                return false;
            }
            int i = this.switches.size() - 1;
            while (i > 0) {
                if (!this.switches.elementAt(i).equals(av.switches.elementAt(i))) {
                    return false;
                }
                --i;
            }
        }
        return true;
    }

    private class SwitchSet {
        VisADSwitch swit;
        Set set;
        DataRenderer renderer;

        SwitchSet(VisADSwitch sw, Set se, DataRenderer re) {
            this.swit = sw;
            this.set = se;
            this.renderer = re;
        }
    }
}

