/*
 * Decompiled with CFR 0.152.
 */
package visad.install;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import visad.install.ProgressMonitor;

public class Util {
    public static final boolean copyDirectory(File source, File target) {
        return Util.copyDirectory(null, source, target, null);
    }

    public static final boolean copyDirectory(ProgressMonitor progress, File source, File target) {
        return Util.copyDirectory(progress, source, target, null);
    }

    public static final boolean copyDirectory(File source, File target, String saveSuffix) {
        return Util.copyDirectory(null, source, target, saveSuffix);
    }

    public static final boolean copyDirectory(ProgressMonitor progress, File source, File target, String saveSuffix) {
        if (!source.isDirectory() || target.exists() && !target.isDirectory()) {
            return false;
        }
        if (Util.getPath(source).equals(Util.getPath(target))) {
            return false;
        }
        if (!target.exists()) {
            target.mkdirs();
        }
        boolean result = true;
        String[] list = source.list();
        int i = 0;
        while (i < list.length) {
            File srcFile = new File(source, list[i]);
            File tgtFile = new File(target, list[i]);
            result = srcFile.isDirectory() ? (result |= Util.copyDirectory(progress, srcFile, tgtFile, saveSuffix)) : (result |= Util.copyFile(progress, srcFile, tgtFile, saveSuffix));
            ++i;
        }
        if (!source.canWrite()) {
            target.setReadOnly();
        }
        target.setLastModified(source.lastModified());
        return result;
    }

    public static final boolean copyFile(File source, File target) {
        return Util.copyFile(null, source, target, null);
    }

    public static final boolean copyFile(ProgressMonitor progress, File source, File target) {
        return Util.copyFile(progress, source, target, null);
    }

    public static final boolean copyFile(File source, File target, String saveSuffix) {
        return Util.copyFile(null, source, target, saveSuffix);
    }

    public static final boolean copyFile(ProgressMonitor progress, File source, File target, String saveSuffix) {
        FileInputStream in;
        if (source.isDirectory()) {
            return false;
        }
        if (Util.getPath(source).equals(Util.getPath(target))) {
            return false;
        }
        if (target.isDirectory()) {
            target = new File(target, source.getName());
        }
        try {
            in = new FileInputStream(source);
        }
        catch (IOException ioe) {
            System.err.println("Couldn't open source file " + source);
            return false;
        }
        Util.copyStreamToFile(progress, in, target, saveSuffix);
        try {
            in.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        if (!source.canWrite()) {
            target.setReadOnly();
        }
        target.setLastModified(source.lastModified());
        return true;
    }

    public static final boolean copyJar(File source, File target) {
        return Util.copyJar(null, source, target, null);
    }

    public static final boolean copyJar(ProgressMonitor progress, File source, File target) {
        return Util.copyJar(progress, source, target, null);
    }

    public static final boolean copyJar(File source, File target, String saveSuffix) {
        return Util.copyJar(null, source, target, saveSuffix);
    }

    public static final boolean copyJar(ProgressMonitor progress, File source, File target, String saveSuffix) {
        JarFile jar;
        if (target.exists() && !target.isDirectory()) {
            return false;
        }
        if (!target.exists()) {
            target.mkdirs();
        }
        try {
            jar = new JarFile(source);
        }
        catch (IOException ioe) {
            return false;
        }
        boolean result = true;
        Enumeration<JarEntry> enumeration = jar.entries();
        while (enumeration.hasMoreElements()) {
            JarEntry entry = enumeration.nextElement();
            String entryName = entry.getName();
            if ("META-INF/MANIFEST.MF".startsWith(entryName)) continue;
            File newFile = new File(target, entryName);
            newFile.mkdirs();
            if (!entry.isDirectory()) {
                InputStream in;
                try {
                    in = jar.getInputStream(entry);
                }
                catch (IOException ioe) {
                    System.err.println("Couldn't copy entry " + entryName);
                    continue;
                }
                Util.copyStreamToFile(progress, in, newFile, saveSuffix);
                try {
                    in.close();
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            newFile.setLastModified(entry.getTime());
        }
        return result;
    }

    /*
     * Loose catch block
     */
    private static final boolean copyStreamToFile(ProgressMonitor progress, InputStream in, File target, String saveSuffix) {
        block19: {
            int n;
            FileOutputStream out;
            if (target.exists()) {
                if (saveSuffix == null) {
                    if (progress != null) {
                        progress.setDetail("Deleting existing " + target);
                    }
                    target.delete();
                } else {
                    File saveFile;
                    if (progress != null) {
                        progress.setDetail("Backing up existing " + target);
                    }
                    if ((saveFile = new File(target.getPath() + saveSuffix)).exists()) {
                        saveFile.delete();
                    }
                    target.renameTo(saveFile);
                }
            }
            if (progress != null) {
                progress.setDetail("Installing " + target);
            }
            try {
                out = new FileOutputStream(target);
            }
            catch (IOException ioe) {
                System.err.println("Couldn't open output file " + target);
                return false;
            }
            byte[] buffer = new byte[1024];
            long totalBytes = 0L;
            while ((n = in.read(buffer)) >= 0) {
                out.write(buffer, 0, n);
            }
            Object var10_10 = null;
            try {
                out.close();
            }
            catch (Exception e) {}
            break block19;
            {
                catch (IOException ioe) {
                    ioe.printStackTrace();
                    boolean bl = false;
                    Object var10_11 = null;
                    try {
                        out.close();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    return bl;
                }
            }
            catch (Throwable throwable) {
                Object var10_12 = null;
                try {
                    out.close();
                }
                catch (Exception e) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return true;
    }

    public static final String getPath(File f) {
        try {
            return f.getCanonicalPath();
        }
        catch (IOException ioe) {
            return f.getAbsolutePath();
        }
    }
}

