/*
 * Decompiled with CFR 0.152.
 */
package visad.georef;

import java.rmi.RemoteException;
import visad.Data;
import visad.MathType;
import visad.Real;
import visad.RealTupleType;
import visad.Text;
import visad.TextType;
import visad.Tuple;
import visad.TupleType;
import visad.VisADError;
import visad.VisADException;
import visad.georef.EarthLocation;
import visad.georef.EarthLocationTuple;
import visad.georef.LatLonPoint;
import visad.georef.NamedLocation;

public class NamedLocationTuple
extends Tuple
implements NamedLocation {
    private EarthLocation location;
    private Text id;
    public static TextType IDENTIFIER_TYPE;

    public NamedLocationTuple() throws VisADException, RemoteException {
        this("", Double.NaN, Double.NaN, Double.NaN);
    }

    public NamedLocationTuple(Text id, Real lat, Real lon, Real alt) throws VisADException, RemoteException {
        this(id, (EarthLocation)new EarthLocationTuple(lat, lon, alt));
    }

    public NamedLocationTuple(Text identifier, EarthLocation location) throws VisADException, RemoteException {
        super(new TupleType(new MathType[]{IDENTIFIER_TYPE, RealTupleType.LatitudeLongitudeAltitude}), new Data[]{identifier, new EarthLocationTuple(location.getLatitude(), location.getLongitude(), location.getAltitude())});
        this.id = identifier;
        this.location = location;
    }

    public NamedLocationTuple(String id, double lat, double lon, double alt) throws VisADException, RemoteException {
        this(new Text(IDENTIFIER_TYPE, id), (EarthLocation)new EarthLocationTuple(lat, lon, alt));
    }

    public NamedLocationTuple(String id, EarthLocation location) throws VisADException, RemoteException {
        this(new Text(IDENTIFIER_TYPE, id), location);
    }

    public Real getLatitude() {
        return this.location.getLatitude();
    }

    public Real getLongitude() {
        return this.location.getLongitude();
    }

    public Real getAltitude() {
        return this.location.getAltitude();
    }

    public LatLonPoint getLatLonPoint() {
        return this.location.getLatLonPoint();
    }

    public EarthLocation getEarthLocation() {
        return this.location;
    }

    public Text getIdentifier() {
        return this.id;
    }

    public Object clone() {
        NamedLocationTuple nlt;
        try {
            nlt = new NamedLocationTuple(this.id, (EarthLocation)new EarthLocationTuple(this.location.getLatitude(), this.location.getLongitude(), this.location.getAltitude()));
        }
        catch (VisADException e) {
            throw new VisADError("NamedLocationTuple.clone: VisADException occurred");
        }
        catch (RemoteException e) {
            throw new VisADError("NamedLocationTuple.clone: RemoteException occurred");
        }
        return nlt;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("Name: ");
        buf.append(this.id);
        buf.append(" ");
        buf.append(this.location.toString());
        return buf.toString();
    }

    static {
        try {
            IDENTIFIER_TYPE = TextType.getTextType("Identifier");
        }
        catch (Exception e) {
            System.err.println("NamedLocationTuple: Can't instatiate type");
        }
    }
}

