/*
 * Decompiled with CFR 0.152.
 */
package visad.georef;

import java.rmi.RemoteException;
import visad.Real;
import visad.RealTuple;
import visad.RealTupleType;
import visad.RealType;
import visad.VisADException;
import visad.browser.Convert;
import visad.georef.EarthLocation;
import visad.georef.LatLonPoint;
import visad.georef.LatLonTuple;

public class EarthLocationTuple
extends RealTuple
implements EarthLocation {
    LatLonTuple latlon;
    Real alt;

    public EarthLocationTuple(Real lat, Real lon, Real alt) throws VisADException, RemoteException {
        super(RealTupleType.LatitudeLongitudeAltitude, new Real[]{lat, lon, alt}, null);
        this.latlon = new LatLonTuple(lat, lon);
        this.alt = alt;
    }

    public EarthLocationTuple(double lat, double lon, double alt) throws VisADException, RemoteException {
        this(new LatLonTuple(lat, lon), new Real(RealType.Altitude, alt));
    }

    public EarthLocationTuple(LatLonPoint latlon, Real alt) throws VisADException, RemoteException {
        this(latlon.getLatitude(), latlon.getLongitude(), alt);
    }

    public Real getLatitude() {
        return this.latlon.getLatitude();
    }

    public Real getLongitude() {
        return this.latlon.getLongitude();
    }

    public Real getAltitude() {
        return this.alt;
    }

    public LatLonPoint getLatLonPoint() {
        return this.latlon;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.latlon.toString());
        buf.append(" Alt: ");
        buf.append(Convert.shortString(this.alt.getValue()));
        return buf.toString();
    }
}

