/*
 * Decompiled with CFR 0.152.
 */
package visad.formula;

import java.util.StringTokenizer;
import visad.formula.FormulaException;
import visad.formula.FormulaManager;

class Postfix {
    static final int BINARY = 0;
    static final int UNARY = 1;
    static final int FUNC = 2;
    static final int FUNCCONST = 3;
    static final int OTHER = 4;
    private static final String IMPLICIT = " ";
    String[] tokens = null;
    int[] codes = null;

    Postfix(String formula, FormulaManager fm) throws FormulaException {
        String ntoken;
        Object postfix = null;
        Object pfixcode = null;
        char[] charStr = formula.toCharArray();
        int numSpaces = 0;
        int paren = 0;
        int i = 0;
        while (i < charStr.length) {
            if (charStr[i] == ' ') {
                ++numSpaces;
            }
            if (charStr[i] == '(') {
                ++paren;
            }
            if (charStr[i] == ')') {
                --paren;
            }
            if (paren < 0) {
                throw new FormulaException("Unable to convert to postfix notation: illegal placement of parentheses");
            }
            ++i;
        }
        if (paren != 0) {
            throw new FormulaException("Unable to convert to postfix notation: parentheses are mismatched!");
        }
        int j = 0;
        int newlen = charStr.length - numSpaces;
        if (newlen == 0) {
            return;
        }
        char[] exp = new char[newlen];
        int i2 = 0;
        while (i2 < charStr.length) {
            if (charStr[i2] != ' ') {
                exp[j++] = charStr[i2];
            }
            ++i2;
        }
        String infix = new String(exp);
        String ops = "(,)";
        int i3 = 0;
        while (i3 < fm.uOps.length) {
            ops = ops + fm.uOps[i3];
            ++i3;
        }
        int i4 = 0;
        while (i4 < fm.bOps.length) {
            ops = ops + fm.bOps[i4];
            ++i4;
        }
        StringTokenizer tokenizer = new StringTokenizer(infix, ops, true);
        int numTokens = tokenizer.countTokens();
        String[] funcStack = new String[numTokens];
        String[] opStack = new String[numTokens];
        int[] opCodes = new int[numTokens];
        String[] pfix = new String[numTokens];
        int[] pcode = new int[numTokens];
        int opPt = 0;
        int funcPt = 0;
        int pfixlen = 0;
        boolean unary = true;
        boolean zero = false;
        boolean numeral = false;
        String token = ntoken = tokenizer.hasMoreTokens() ? tokenizer.nextToken() : null;
        while (token != null) {
            int num;
            String op;
            int opcode;
            String string = ntoken = tokenizer.hasMoreTokens() ? tokenizer.nextToken() : null;
            if (token.equals(")")) {
                if (opPt < 1) {
                    throw new FormulaException("Unable to convert to postfix notation: operator stack unexpectedly empty");
                }
                opcode = opCodes[--opPt];
                op = opStack[opPt];
                while (!op.equals("(")) {
                    pcode[pfixlen] = opcode;
                    pfix[pfixlen++] = "" + op;
                    if (opPt < 1) {
                        throw new FormulaException("Unable to convert to postfix notation: operator stack unexpectedly empty");
                    }
                    opcode = opCodes[opPt - 1];
                    op = opStack[--opPt];
                }
                if (opcode == 2) {
                    boolean implicit;
                    if (funcPt < 1) {
                        throw new FormulaException("Unable to convert to postfix notation: function stack unexpectedly empty");
                    }
                    String f = funcStack[--funcPt];
                    if (zero) {
                        implicit = f.equals(IMPLICIT);
                        pcode[pfixlen] = implicit ? 2 : 3;
                        pfix[pfixlen++] = "0";
                    } else {
                        int n = 1;
                        while (f.equals(",")) {
                            ++n;
                            if (funcPt < 1) {
                                throw new FormulaException("Unable to convert to postfix notation: function stack unexpectedly empty");
                            }
                            f = funcStack[--funcPt];
                        }
                        implicit = f.equals(IMPLICIT);
                        pcode[pfixlen] = implicit ? 2 : 3;
                        pfix[pfixlen++] = "" + n;
                    }
                    if (!implicit) {
                        pcode[pfixlen] = 2;
                        pfix[pfixlen++] = f;
                    }
                }
                unary = false;
                zero = false;
                numeral = false;
            }
            if (token.equals("(")) {
                opCodes[opPt] = 4;
                opStack[opPt++] = "(";
                unary = true;
                zero = false;
                numeral = false;
            } else if (token.equals(",")) {
                if (opPt < 1) {
                    throw new FormulaException("Unable to convert to postfix notation: operator stack unexpectedly empty");
                }
                opcode = opCodes[opPt - 1];
                op = opStack[opPt - 1];
                while (!op.equals("(")) {
                    pcode[pfixlen] = opcode;
                    pfix[pfixlen++] = "" + op;
                    if (--opPt < 1) {
                        throw new FormulaException("Unable to convert to postfix notation: operator stack unexpectedly empty");
                    }
                    opcode = opCodes[opPt - 1];
                    op = opStack[opPt - 1];
                }
                funcStack[funcPt++] = ",";
                unary = true;
                zero = false;
                numeral = false;
            } else if (unary && fm.isUnaryOp(token) || fm.isBinaryOp(token)) {
                num = -1;
                if (numeral && token.equals(".") && ntoken != null) {
                    try {
                        num = Integer.parseInt(ntoken);
                    }
                    catch (NumberFormatException exc) {
                        // empty catch block
                    }
                }
                if (num > 0) {
                    pfix[pfixlen - 1] = pfix[pfixlen - 1] + "." + ntoken;
                    token = ntoken;
                    ntoken = tokenizer.hasMoreTokens() ? tokenizer.nextToken() : null;
                    unary = false;
                    zero = false;
                    numeral = false;
                } else {
                    int scode;
                    String sop;
                    int prec;
                    boolean isUnary = unary && fm.isUnaryOp(token);
                    int n = prec = isUnary ? fm.getUnaryPrec(token) : fm.getBinaryPrec(token);
                    if (opPt < 1) {
                        sop = null;
                        scode = 0;
                    } else {
                        sop = opStack[opPt - 1];
                        scode = opCodes[opPt - 1];
                    }
                    while (sop != null && prec >= (scode == 1 ? fm.getUnaryPrec(sop) : fm.getBinaryPrec(sop))) {
                        pcode[pfixlen] = scode;
                        pfix[pfixlen++] = "" + sop;
                        if (--opPt < 1) {
                            sop = null;
                            scode = 0;
                            continue;
                        }
                        sop = opStack[opPt - 1];
                        scode = opCodes[opPt - 1];
                    }
                    opCodes[opPt] = isUnary ? 1 : 0;
                    opStack[opPt++] = token;
                    unary = true;
                    zero = false;
                    numeral = false;
                }
            } else if (ntoken != null && ntoken.equals("(")) {
                if (fm.isFunction(token)) {
                    funcStack[funcPt++] = token;
                } else {
                    int scode;
                    String sop;
                    funcStack[funcPt++] = IMPLICIT;
                    if (!token.equals(")")) {
                        pcode[pfixlen] = 4;
                        pfix[pfixlen++] = token;
                    }
                    if (opPt < 1) {
                        sop = null;
                        scode = 0;
                    } else {
                        sop = opStack[opPt - 1];
                        scode = opCodes[opPt - 1];
                    }
                    while (sop != null && fm.iPrec >= (scode == 1 ? fm.getUnaryPrec(sop) : fm.getBinaryPrec(sop))) {
                        pcode[pfixlen] = scode;
                        pfix[pfixlen++] = "" + sop;
                        if (--opPt < 1) {
                            sop = null;
                            scode = 0;
                            continue;
                        }
                        sop = opStack[opPt - 1];
                        scode = opCodes[opPt - 1];
                    }
                }
                opCodes[opPt] = 2;
                opStack[opPt++] = "(";
                token = ntoken;
                ntoken = tokenizer.hasMoreTokens() ? tokenizer.nextToken() : null;
                unary = true;
                zero = true;
                numeral = false;
            } else if (!token.equals(")")) {
                pcode[pfixlen] = 4;
                pfix[pfixlen++] = token;
                unary = false;
                zero = false;
                try {
                    num = Integer.parseInt(token);
                    numeral = true;
                }
                catch (NumberFormatException exc) {
                    numeral = false;
                }
            }
            token = ntoken;
        }
        while (opPt > 0) {
            pcode[pfixlen] = opCodes[opPt - 1];
            pfix[pfixlen++] = "" + opStack[--opPt];
        }
        if (opPt != 0 || funcPt != 0) {
            throw new FormulaException("Unable to convert to postfix notation: stacks are not empty");
        }
        this.tokens = new String[pfixlen];
        this.codes = new int[pfixlen];
        System.arraycopy(pfix, 0, this.tokens, 0, pfixlen);
        System.arraycopy(pcode, 0, this.codes, 0, pfixlen);
    }
}

