/*
 * Decompiled with CFR 0.152.
 */
package visad.formula;

import java.lang.reflect.InvocationTargetException;
import java.rmi.RemoteException;
import java.util.Stack;
import java.util.Vector;
import visad.ActionImpl;
import visad.CellImpl;
import visad.Data;
import visad.Real;
import visad.RealType;
import visad.RemoteCellImpl;
import visad.RemoteDataReference;
import visad.Text;
import visad.Thing;
import visad.ThingReference;
import visad.ThingReferenceImpl;
import visad.VisADException;
import visad.formula.FormulaException;
import visad.formula.FormulaManager;
import visad.formula.FormulaUtil;
import visad.formula.Postfix;

public class FormulaVar
extends ActionImpl {
    public static boolean DEBUG = false;
    public static RealType CONSTANT = RealType.getRealType("visad/formula/constant");
    private FormulaManager fm;
    String name;
    private String formula;
    private Postfix postfix;
    private ThingReference tref;
    private Vector errors = new Vector();
    private Object Lock = new Object();
    private boolean computing = false;
    private Vector depend = new Vector();
    private Vector required = new Vector();
    ThingReference textRef = null;
    CellImpl textCell = new CellImpl(){

        public void doAction() {
            block8: {
                boolean textChanged = false;
                if (FormulaVar.this.textRef != null) {
                    try {
                        Thing thing = FormulaVar.this.textRef.getThing();
                        if (thing instanceof Text) {
                            Text t = (Text)thing;
                            String newForm = t.getValue();
                            if (newForm == null) {
                                newForm = "";
                            }
                            if (!newForm.equals(FormulaVar.this.formula)) {
                                textChanged = true;
                                FormulaVar.this.setFormula(newForm);
                            }
                        }
                    }
                    catch (VisADException exc) {
                        if (DEBUG) {
                            exc.printStackTrace();
                        }
                    }
                    catch (RemoteException exc) {
                        if (!DEBUG) break block8;
                        exc.printStackTrace();
                    }
                }
            }
        }
    };
    RemoteCellImpl rtCell = null;

    FormulaVar(String n, FormulaManager f) throws VisADException {
        this(n, f, null);
    }

    FormulaVar(String n, FormulaManager f, ThingReference t) throws VisADException {
        super(n);
        this.fm = f;
        this.name = n;
        this.tref = t == null ? new ThingReferenceImpl(this.name) : t;
        int i = 0;
        while (i < this.fm.bOps.length) {
            if (this.name.indexOf(this.fm.bOps[i]) >= 0) {
                throw new FormulaException("variable names cannot contain operators");
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < this.fm.uOps.length) {
            if (this.name.indexOf(this.fm.uOps[i2]) >= 0) {
                throw new FormulaException("variable names cannot contain operators");
            }
            ++i2;
        }
    }

    boolean othersDepend() {
        return !this.required.isEmpty();
    }

    boolean isDependentOn(FormulaVar v) {
        if (v == this || this.depend.contains(v)) {
            return true;
        }
        int i = 0;
        while (i < this.depend.size()) {
            FormulaVar vi = (FormulaVar)this.depend.elementAt(i);
            if (vi.isDependentOn(v)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void setDependentOn(FormulaVar v) {
        block5: {
            if (!this.depend.contains(v)) {
                this.depend.add(v);
                try {
                    this.addReference(v.getReference());
                    v.required.add(this);
                }
                catch (VisADException exc) {
                    if (DEBUG) {
                        exc.printStackTrace();
                    }
                }
                catch (RemoteException exc) {
                    if (!DEBUG) break block5;
                    exc.printStackTrace();
                }
            }
        }
    }

    private void clearDependencies() {
        block5: {
            int len = this.depend.size();
            int i = 0;
            while (i < len) {
                FormulaVar v = (FormulaVar)this.depend.elementAt(i);
                v.required.remove(this);
                ++i;
            }
            this.depend.removeAllElements();
            try {
                this.removeAllReferences();
            }
            catch (VisADException exc) {
                if (DEBUG) {
                    exc.printStackTrace();
                }
            }
            catch (RemoteException exc) {
                if (!DEBUG) break block5;
                exc.printStackTrace();
            }
        }
    }

    private void rebuildDependencies() throws FormulaException {
        this.disableAction();
        Object object = this.Lock;
        synchronized (object) {
            this.clearDependencies();
            if (this.formula != null && this.postfix == null) {
                try {
                    Object[] o = new Object[]{this.formula, this.fm};
                    String pf = this.formula;
                    try {
                        pf = (String)FormulaUtil.invokeMethod(this.fm.ppMethod, o);
                    }
                    catch (IllegalAccessException exc) {
                        if (DEBUG) {
                            exc.printStackTrace();
                        }
                        this.evalError("Preparsing access exception", exc);
                    }
                    catch (IllegalArgumentException exc) {
                        if (DEBUG) {
                            exc.printStackTrace();
                        }
                        this.evalError("Preparsing argument exception", exc);
                    }
                    catch (InvocationTargetException exc) {
                        Throwable t = exc.getTargetException();
                        if (DEBUG) {
                            t.printStackTrace();
                        }
                        this.evalError("Preparsing exception", t);
                    }
                    this.postfix = new Postfix(pf, this.fm);
                    int len = this.postfix.tokens == null ? 0 : this.postfix.tokens.length;
                    int i = 0;
                    while (i < len) {
                        String token = this.postfix.tokens[i];
                        if (this.postfix.codes[i] == 4) {
                            Double d = null;
                            try {
                                d = Double.valueOf(token);
                            }
                            catch (NumberFormatException exc) {
                                // empty catch block
                            }
                            if (d == null) {
                                FormulaVar v = null;
                                try {
                                    v = this.fm.getVarByNameOrCreate(token);
                                }
                                catch (FormulaException exc) {
                                    this.evalError("\"" + token + "\" is an illegal variable name");
                                }
                                catch (VisADException exc) {
                                    this.evalError("Internal VisAD error", exc);
                                }
                                if (v != null) {
                                    if (v.isDependentOn(this)) {
                                        this.clearDependencies();
                                        throw new FormulaException("This formula creates an infinite loop");
                                    }
                                    this.setDependentOn(v);
                                }
                            }
                        }
                        ++i;
                    }
                }
                catch (FormulaException exc) {
                    this.evalError("Syntax error in formula", exc);
                    try {
                        this.tref.setThing(null);
                    }
                    catch (VisADException exc2) {
                        this.evalError("Internal VisAD error", exc2);
                    }
                    catch (RemoteException exc2) {
                        this.evalError("Internal remote error", exc2);
                    }
                }
            }
        }
        this.enableAction();
        if (this.depend.isEmpty()) {
            this.doAction();
        }
    }

    void setFormula(String f) throws FormulaException {
        block5: {
            this.formula = f;
            if (this.textRef != null) {
                Text text = new Text(this.formula);
                try {
                    this.textRef.setThing(text);
                }
                catch (VisADException exc) {
                    if (DEBUG) {
                        exc.printStackTrace();
                    }
                }
                catch (RemoteException exc) {
                    if (!DEBUG) break block5;
                    exc.printStackTrace();
                }
            }
        }
        this.postfix = null;
        this.computing = true;
        this.rebuildDependencies();
    }

    void waitForFormula() {
        Object object = this.Lock;
        synchronized (object) {
            if (this.computing) {
                try {
                    this.Lock.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    void setTextRef(ThingReference tr) throws VisADException, RemoteException {
        if (this.textRef == tr) {
            return;
        }
        if (this.textRef != null) {
            if (this.textRef instanceof RemoteDataReference) {
                this.rtCell.removeReference(this.textRef);
                this.rtCell = null;
            } else {
                this.textCell.removeReference(this.textRef);
            }
        }
        this.textRef = tr;
        if (this.textRef != null) {
            if (this.textRef instanceof RemoteDataReference) {
                this.rtCell = new RemoteCellImpl(this.textCell);
                this.rtCell.addReference(this.textRef);
            } else {
                this.textCell.addReference(this.textRef);
            }
        }
    }

    void setThing(Thing t) throws VisADException, RemoteException {
        Object object = this.Lock;
        synchronized (object) {
            this.formula = null;
            this.postfix = null;
            this.clearDependencies();
            if (t == null || t != this.tref.getThing()) {
                this.tref.setThing(t);
            }
        }
    }

    void setReference(ThingReference tr) {
        if (this.tref == tr) {
            return;
        }
        Object object = this.Lock;
        synchronized (object) {
            int len = this.required.size();
            int i = 0;
            while (i < len) {
                block9: {
                    FormulaVar v = (FormulaVar)this.required.elementAt(i);
                    try {
                        v.removeReference(this.tref);
                        v.addReference(tr);
                    }
                    catch (VisADException exc) {
                        if (DEBUG) {
                            exc.printStackTrace();
                        }
                    }
                    catch (RemoteException exc) {
                        if (!DEBUG) break block9;
                        exc.printStackTrace();
                    }
                }
                ++i;
            }
            this.tref = tr;
        }
    }

    Thing getThing() {
        try {
            return this.tref.getThing();
        }
        catch (VisADException exc) {
            return null;
        }
        catch (RemoteException exc) {
            return null;
        }
    }

    ThingReference getReference() {
        return this.tref;
    }

    String getFormula() {
        return this.formula;
    }

    String[] getErrors() {
        Vector vector = this.errors;
        synchronized (vector) {
            int len = this.errors.size();
            if (len == 0) {
                String[] stringArray = null;
                return stringArray;
            }
            String[] s = new String[len];
            int i = 0;
            while (i < len) {
                s[i] = (String)this.errors.elementAt(i);
                ++i;
            }
            String[] stringArray = s;
            return stringArray;
        }
    }

    void clearErrors() {
        Vector vector = this.errors;
        synchronized (vector) {
            this.errors.clear();
        }
    }

    private void evalError(String s) {
        Vector vector = this.errors;
        synchronized (vector) {
            this.errors.add(s);
        }
    }

    private void evalError(String s, Throwable t) {
        String msg = t == null ? null : t.getMessage();
        this.evalError(s + (msg == null ? "" : ": " + msg));
    }

    public void doAction() {
        Object object = this.Lock;
        synchronized (object) {
            try {
                if (this.postfix != null) {
                    this.tref.setThing(this.compute(this.postfix));
                }
            }
            catch (VisADException exc) {
                this.evalError("Could not store final value in variable");
            }
            catch (RemoteException exc) {
                this.evalError("Could not store final value in variable (remote)");
            }
            this.computing = false;
            this.Lock.notifyAll();
        }
    }

    private Thing popStack(Stack s) {
        if (s.empty()) {
            this.evalError("Syntax error in formula (stack empty)");
            return null;
        }
        return (Thing)s.pop();
    }

    private Thing compute(Postfix formula) {
        if (formula.tokens == null) {
            return null;
        }
        int len = formula.tokens.length;
        Stack<Thing> stack = new Stack<Thing>();
        int i = 0;
        while (i < len) {
            Throwable t;
            Object[] o;
            String token = formula.tokens[i];
            String op = "\"" + token + "\"";
            int code = formula.codes[i];
            if (code == 0) {
                o = new Object[2];
                o[1] = this.popStack(stack);
                o[0] = this.popStack(stack);
                Thing ans = null;
                if (o[0] != null && o[1] != null) {
                    int j = 0;
                    while (j < this.fm.bMethods.length) {
                        if (ans == null && this.fm.bOps[j].equals(token)) {
                            try {
                                ans = (Thing)FormulaUtil.invokeMethod(this.fm.bMethods[j], o);
                            }
                            catch (IllegalAccessException exc) {
                                if (DEBUG) {
                                    exc.printStackTrace();
                                }
                                this.evalError("Cannot access binary method for operator " + op, exc);
                            }
                            catch (IllegalArgumentException exc) {
                                if (DEBUG) {
                                    exc.printStackTrace();
                                }
                                this.evalError("Invalid argument to binary method for operator " + op, exc);
                            }
                            catch (InvocationTargetException exc) {
                                t = exc.getTargetException();
                                if (DEBUG) {
                                    t.printStackTrace();
                                }
                                this.evalError("Binary method for operator " + op + " threw an exception", t);
                            }
                        }
                        ++j;
                    }
                }
                if (ans == null) {
                    this.evalError("Could not evaluate binary operator " + op);
                    stack.push(null);
                } else {
                    stack.push(ans);
                }
            } else if (code == 1) {
                o = new Object[]{this.popStack(stack)};
                Thing ans = null;
                if (o[0] != null) {
                    int j = 0;
                    while (j < this.fm.uMethods.length) {
                        if (ans == null && this.fm.uOps[j].equals(token)) {
                            try {
                                ans = (Thing)FormulaUtil.invokeMethod(this.fm.uMethods[j], o);
                            }
                            catch (IllegalAccessException exc) {
                                if (DEBUG) {
                                    exc.printStackTrace();
                                }
                                this.evalError("Cannot access unary method for operator " + op, exc);
                            }
                            catch (IllegalArgumentException exc) {
                                if (DEBUG) {
                                    exc.printStackTrace();
                                }
                                this.evalError("Invalid argument to unary method for operator " + op, exc);
                            }
                            catch (InvocationTargetException exc) {
                                t = exc.getTargetException();
                                if (DEBUG) {
                                    t.printStackTrace();
                                }
                                this.evalError("Unary method for operator " + op + " threw an exception", t);
                            }
                        }
                        ++j;
                    }
                }
                if (ans == null) {
                    this.evalError("Could not evaluate unary operator " + op);
                    stack.push(null);
                } else {
                    stack.push(ans);
                }
            } else if (code == 2) {
                Throwable t2;
                int j;
                boolean eflag;
                Object o2;
                int num;
                Thing ans = null;
                if (this.fm.isFunction(token)) {
                    block91: {
                        num = -1;
                        try {
                            Real r = (Real)this.popStack(stack);
                            num = (int)r.getValue();
                        }
                        catch (ClassCastException exc) {
                            if (!DEBUG) break block91;
                            exc.printStackTrace();
                        }
                    }
                    if (num < 0) {
                        this.evalError("Syntax error in formula (invalid function arg length)");
                        num = 1;
                    }
                    o2 = num > 0 ? new Object[num] : null;
                    eflag = false;
                    j = num - 1;
                    while (j >= 0) {
                        o2[j] = this.popStack(stack);
                        if (o2[j] == null) {
                            eflag = true;
                        }
                        --j;
                    }
                    if (!eflag) {
                        int j2 = 0;
                        while (j2 < this.fm.funcs.length) {
                            if (ans == null && this.fm.funcs[j2].equalsIgnoreCase(token)) {
                                try {
                                    ans = (Thing)FormulaUtil.invokeMethod(this.fm.fMethods[j2], o2);
                                }
                                catch (IllegalAccessException exc) {
                                    if (DEBUG) {
                                        exc.printStackTrace();
                                    }
                                    this.evalError("Cannot access method for function " + op, exc);
                                }
                                catch (IllegalArgumentException exc) {
                                    if (DEBUG) {
                                        exc.printStackTrace();
                                    }
                                    this.evalError("Invalid argument to method for function " + op, exc);
                                }
                                catch (InvocationTargetException exc) {
                                    t2 = exc.getTargetException();
                                    if (DEBUG) {
                                        t2.printStackTrace();
                                    }
                                    this.evalError("Method for function " + op + " threw an exception", t2);
                                }
                            }
                            ++j2;
                        }
                    }
                    if (ans == null) {
                        this.evalError("Could not evaluate function " + op);
                        stack.push(null);
                    } else {
                        stack.push(ans);
                    }
                } else {
                    block92: {
                        num = 0;
                        try {
                            num = Integer.parseInt(token) + 1;
                        }
                        catch (NumberFormatException exc) {
                            if (!DEBUG) break block92;
                            exc.printStackTrace();
                        }
                    }
                    if (num <= 0) {
                        this.evalError("Syntax error in formula (invalid implicit arg length)");
                        num = 1;
                    }
                    o2 = new Object[num];
                    eflag = false;
                    j = num - 1;
                    while (j >= 0) {
                        o2[j] = this.popStack(stack);
                        if (o2[j] == null) {
                            eflag = true;
                        }
                        --j;
                    }
                    if (!eflag) {
                        int j3 = 0;
                        while (j3 < this.fm.iMethods.length) {
                            if (ans == null) {
                                try {
                                    ans = (Thing)FormulaUtil.invokeMethod(this.fm.iMethods[j3], o2);
                                }
                                catch (IllegalAccessException exc) {
                                    if (DEBUG) {
                                        exc.printStackTrace();
                                    }
                                    this.evalError("Cannot access method for implicit function", exc);
                                }
                                catch (IllegalArgumentException exc) {
                                    if (DEBUG) {
                                        exc.printStackTrace();
                                    }
                                    this.evalError("Invalid argument to method for implicit function", exc);
                                }
                                catch (InvocationTargetException exc) {
                                    t2 = exc.getTargetException();
                                    if (DEBUG) {
                                        t2.printStackTrace();
                                    }
                                    this.evalError("Method for implicit function threw an exception", t2);
                                }
                            }
                            ++j3;
                        }
                    }
                    if (ans == null) {
                        this.evalError("Could not evaluate implicit function");
                        stack.push(null);
                    } else {
                        stack.push(ans);
                    }
                }
            } else {
                Double d = null;
                try {
                    d = Double.valueOf(token);
                }
                catch (NumberFormatException exc) {
                    // empty catch block
                }
                if (d == null) {
                    FormulaVar v = null;
                    try {
                        v = this.fm.getVarByNameOrCreate(token);
                    }
                    catch (FormulaException exc) {
                        this.evalError(op + " is an illegal variable name");
                        stack.push(null);
                    }
                    catch (VisADException exc) {
                        this.evalError("Internal error", exc);
                        stack.push(null);
                    }
                    if (v != null) {
                        Thing t3;
                        block93: {
                            ThingReference r = v.getReference();
                            t3 = null;
                            if (r != null) {
                                try {
                                    t3 = r.getThing();
                                }
                                catch (VisADException exc) {
                                    if (DEBUG) {
                                        exc.printStackTrace();
                                    }
                                }
                                catch (RemoteException exc) {
                                    if (!DEBUG) break block93;
                                    exc.printStackTrace();
                                }
                            }
                        }
                        if (t3 == null) {
                            this.evalError("Variable " + op + " has no value");
                            stack.push(null);
                        } else {
                            stack.push(t3);
                        }
                    }
                } else if (code == 4) {
                    stack.push(new Real(CONSTANT, (double)d));
                } else {
                    stack.push(new Real(d));
                }
            }
            ++i;
        }
        Thing answer = this.popStack(stack);
        if (!stack.empty()) {
            this.evalError("Syntax error in formula (leftover objects on stack)");
        }
        if (answer instanceof Data) {
            try {
                answer = ((Data)answer).local();
                if (answer instanceof Real && ((Real)answer).getType() == CONSTANT) {
                    answer = new Real(((Real)answer).getValue());
                }
            }
            catch (VisADException exc) {
                this.evalError("The answer could not be converted to local data");
                answer = null;
            }
            catch (RemoteException exc) {
                this.evalError("The answer could not be converted to local data (remote)");
                answer = null;
            }
        }
        return answer;
    }
}

