/*
 * Decompiled with CFR 0.152.
 */
package visad.data.visad.object;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import visad.ErrorEstimate;
import visad.Unit;
import visad.VisADException;
import visad.data.visad.BinaryObjectCache;
import visad.data.visad.BinaryReader;
import visad.data.visad.BinaryWriter;
import visad.data.visad.object.BinaryIntegerArray;
import visad.data.visad.object.BinaryObject;
import visad.data.visad.object.BinaryUnit;

public class BinaryErrorEstimate
implements BinaryObject {
    public static final int computeBytes(int uIndex) {
        return 28 + (uIndex < 0 ? 0 : 5) + 1;
    }

    public static final int computeBytes(ErrorEstimate[] array) {
        return BinaryIntegerArray.computeBytes(array);
    }

    public static final int[] lookupList(BinaryObjectCache cache, ErrorEstimate[] errors) {
        boolean empty = true;
        int i = 0;
        while (i < errors.length) {
            if (errors[i] != null) {
                empty = false;
                break;
            }
            ++i;
        }
        if (empty) {
            return null;
        }
        int[] indices = new int[errors.length];
        int i2 = 0;
        while (i2 < errors.length) {
            indices[i2] = errors[i2] == null ? -1 : cache.getIndex(errors[i2]);
            ++i2;
        }
        return indices;
    }

    public static final ErrorEstimate read(BinaryReader reader) throws IOException, VisADException {
        BinaryObjectCache errorCache = reader.getErrorEstimateCache();
        BinaryObjectCache unitCache = reader.getUnitCache();
        DataInput file = reader.getInput();
        int objLen = file.readInt();
        int index = file.readInt();
        double errValue = file.readDouble();
        double mean = file.readDouble();
        long number = file.readLong();
        Unit u = null;
        boolean reading = true;
        while (reading) {
            byte directive = file.readByte();
            switch (directive) {
                case 30: {
                    int uIndex = file.readInt();
                    u = (Unit)unitCache.get(uIndex);
                    break;
                }
                case 80: {
                    reading = false;
                    break;
                }
                default: {
                    throw new IOException("Unknown ErrorEstimate directive " + directive);
                }
            }
        }
        ErrorEstimate err = new ErrorEstimate(errValue, mean, number, u);
        errorCache.add(index, err);
        return err;
    }

    public static final ErrorEstimate[] readList(BinaryReader reader) throws IOException {
        BinaryObjectCache cache = reader.getErrorEstimateCache();
        DataInput file = reader.getInput();
        int len = file.readInt();
        if (len < 1) {
            throw new IOException("Corrupted file (bad ErrorEstimate array length " + len + ")");
        }
        ErrorEstimate[] errs = new ErrorEstimate[len];
        int i = 0;
        while (i < len) {
            int index = file.readInt();
            errs[i] = index < 0 ? null : (ErrorEstimate)cache.get(index);
            ++i;
        }
        return errs;
    }

    public static final int write(BinaryWriter writer, ErrorEstimate error, Object token) throws IOException {
        BinaryObjectCache cache = writer.getErrorEstimateCache();
        int index = cache.getIndex(error);
        if (index >= 0) {
            return index;
        }
        index = cache.add(error);
        if (index < 0) {
            throw new IOException("Couldn't cache ErrorEstimate " + error);
        }
        double errValue = error.getErrorValue();
        double mean = error.getMean();
        long number = error.getNumberNotMissing();
        Unit unit = error.getUnit();
        int uIndex = -1;
        if (unit != null) {
            uIndex = BinaryUnit.write(writer, unit, token);
        }
        int objLen = BinaryErrorEstimate.computeBytes(uIndex);
        DataOutput file = writer.getOutput();
        file.writeByte(4);
        file.writeInt(objLen);
        file.writeInt(index);
        file.writeDouble(errValue);
        file.writeDouble(mean);
        file.writeLong(number);
        if (uIndex >= 0) {
            file.writeByte(30);
            file.writeInt(uIndex);
        }
        file.writeByte(80);
        return index;
    }

    public static final int[] writeList(BinaryWriter writer, ErrorEstimate[] errors, Object token) throws IOException {
        boolean empty = true;
        int i = 0;
        while (i < errors.length) {
            if (errors[i] != null) {
                empty = false;
                break;
            }
            ++i;
        }
        if (empty) {
            return null;
        }
        int[] indices = new int[errors.length];
        int i2 = 0;
        while (i2 < errors.length) {
            indices[i2] = errors[i2] == null ? -1 : BinaryErrorEstimate.write(writer, errors[i2], token);
            ++i2;
        }
        return indices;
    }
}

