/*
 * Decompiled with CFR 0.152.
 */
package visad.data.tiff;

import ij.ImagePlus;
import ij.ImageStack;
import ij.io.FileInfo;
import ij.io.FileOpener;
import ij.io.FileSaver;
import ij.io.TiffDecoder;
import ij.process.ColorProcessor;
import ij.process.ImageProcessor;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.rmi.RemoteException;
import visad.Data;
import visad.DataImpl;
import visad.FieldImpl;
import visad.FlatField;
import visad.FunctionType;
import visad.Gridded2DSet;
import visad.Integer1DSet;
import visad.RealType;
import visad.VisADException;
import visad.data.BadFormException;
import visad.data.DefaultFamily;
import visad.data.Form;
import visad.data.FormFileInformer;
import visad.data.FormNode;
import visad.util.DataUtility;
import visad.util.ReflectedUniverse;

public class TiffForm
extends Form
implements FormFileInformer {
    private static int num = 0;
    private static final String[] suffixes = new String[]{"tif", "tiff"};
    private static final String NO_JAI = "This feature requires JAI, available from Sun at http://java.sun.com/products/java-media/jai/";
    private static boolean noJai = false;
    private static ReflectedUniverse r = TiffForm.createReflectedUniverse();

    private static ReflectedUniverse createReflectedUniverse() {
        ReflectedUniverse r = null;
        try {
            r = new ReflectedUniverse();
            r.exec("import com.sun.media.jai.codec.ImageDecodeParam");
            r.exec("import com.sun.media.jai.codec.ImageDecoder");
            r.exec("import com.sun.media.jai.codec.ImageCodec");
        }
        catch (VisADException exc) {
            noJai = true;
        }
        return r;
    }

    private static BufferedImage[] jaiGetImages(String filename) throws BadFormException, IOException {
        if (noJai) {
            throw new BadFormException(NO_JAI);
        }
        BufferedImage[] bi = null;
        try {
            r.setVar("tiff", "tiff");
            r.setVar("file", new File(filename));
            r.exec("id = ImageCodec.createImageDecoder(tiff, file, null)");
            Object ni = r.exec("id.getNumPages()");
            int numImages = (Integer)ni;
            bi = new BufferedImage[numImages];
            int i = 0;
            while (i < numImages) {
                r.setVar("i", new Integer(i));
                RenderedImage ri = (RenderedImage)r.exec("id.decodeAsRenderedImage(i)");
                WritableRaster wr = ri.copyData(null);
                ColorModel cm = ri.getColorModel();
                bi[i] = new BufferedImage(cm, wr, false, null);
                ++i;
            }
        }
        catch (VisADException exc) {
            throw new BadFormException(exc.getMessage());
        }
        return bi;
    }

    public TiffForm() {
        super("TiffForm" + num++);
    }

    public boolean isThisType(String name) {
        int i = 0;
        while (i < suffixes.length) {
            if (name.toLowerCase().endsWith(suffixes[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean isThisType(byte[] block) {
        return false;
    }

    public String[] getDefaultSuffixes() {
        String[] s = new String[suffixes.length];
        System.arraycopy(suffixes, 0, s, 0, suffixes.length);
        return s;
    }

    private static ImageProcessor extractImage(FlatField field) throws VisADException {
        int i;
        Gridded2DSet set = (Gridded2DSet)field.getDomainSet();
        int[] wh = set.getLengths();
        int w = wh[0];
        int h = wh[1];
        double[][] samples = field.getValues();
        int[] pixels = new int[samples[0].length];
        if (samples.length == 3) {
            i = 0;
            while (i < samples[0].length) {
                int r = (int)samples[0][i] & 0xFF;
                int g = (int)samples[1][i] & 0xFF;
                int b = (int)samples[2][i] & 0xFF;
                pixels[i] = r << 16 | g << 8 | b;
                ++i;
            }
        } else if (samples.length == 1) {
            i = 0;
            while (i < samples[0].length) {
                int v = (int)samples[0][i] & 0xFF;
                pixels[i] = v << 16 | v << 8 | v;
                ++i;
            }
        }
        ColorProcessor cp = new ColorProcessor(w, h, pixels);
        return cp;
    }

    public void save(String id, Data data, boolean replace) throws BadFormException, IOException, RemoteException, VisADException {
        FlatField[] fields = DataUtility.getImageFields(data);
        if (fields == null) {
            throw new BadFormException("Data type must be image or time sequence of images");
        }
        if (fields.length > 1) {
            int len = fields.length;
            ImageProcessor[] ips = new ImageProcessor[len];
            int i = 0;
            while (i < len) {
                ips[i] = TiffForm.extractImage(fields[i]);
                ++i;
            }
            ImageStack is = new ImageStack(ips[0].getWidth(), ips[0].getHeight(), ips[0].getColorModel());
            int i2 = 0;
            while (i2 < len) {
                is.addSlice("" + i2, ips[i2]);
                ++i2;
            }
            ImagePlus image = new ImagePlus(id, is);
            FileSaver sav = new FileSaver(image);
            sav.saveAsTiffStack(id);
        } else {
            ImageProcessor ip = TiffForm.extractImage(fields[0]);
            ImagePlus image = new ImagePlus(id, ip);
            FileSaver sav = new FileSaver(image);
            sav.saveAsTiff(id);
        }
    }

    public void add(String id, Data data, boolean replace) throws BadFormException {
        throw new BadFormException("TiffForm.add");
    }

    public DataImpl open(String id) throws BadFormException, IOException, VisADException {
        Data[] fields;
        int nImages;
        TiffDecoder tdec = new TiffDecoder("", id);
        FileInfo info = null;
        boolean canUseImageJ = true;
        try {
            info = tdec.getTiffInfo()[0];
        }
        catch (IOException exc) {
            String msg = exc.getMessage();
            if (msg.startsWith("Unsupported BitsPerSample") || msg.startsWith("Unsupported SamplesPerPixel") || msg.startsWith("ImageJ cannot open compressed TIFF files")) {
                canUseImageJ = false;
            }
            throw exc;
        }
        if (canUseImageJ) {
            FileOpener fo = new FileOpener(info);
            ImageStack stack = fo.open(false).getStack();
            nImages = stack.getSize();
            fields = new FieldImpl[nImages];
            int i = 0;
            while (i < nImages) {
                ImageProcessor ip = stack.getProcessor(i + 1);
                fields[i] = DataUtility.makeField(ip.createImage());
                ++i;
            }
        } else {
            BufferedImage[] bi = TiffForm.jaiGetImages(id);
            nImages = bi.length;
            fields = new FieldImpl[nImages];
            int i = 0;
            while (i < nImages) {
                fields[i] = DataUtility.makeField(bi[i]);
                ++i;
            }
        }
        if (nImages < 1) {
            throw new BadFormException("No images in file");
        }
        if (nImages == 1) {
            return fields[0];
        }
        RealType time = RealType.getRealType("time");
        FunctionType time_function = new FunctionType(time, fields[0].getType());
        Integer1DSet time_set = new Integer1DSet(nImages);
        FieldImpl time_field = new FieldImpl(time_function, time_set);
        time_field.setSamples(fields, false);
        return time_field;
    }

    public DataImpl open(URL url) throws BadFormException, IOException, VisADException {
        throw new BadFormException("TiffForm.open(URL)");
    }

    public FormNode getForms(Data data) {
        return null;
    }

    public static void main(String[] args) throws VisADException, RemoteException, IOException {
        if (args == null || args.length < 1 || args.length > 2) {
            System.out.println("To convert a file to TIFF, run:");
            System.out.println("  java visad.data.tiff.TiffForm in_file out_file");
            System.out.println("To test read a TIFF file, run:");
            System.out.println("  java visad.data.tiff.TiffForm in_file");
            System.exit(2);
        }
        if (args.length == 1) {
            TiffForm form = new TiffForm();
            System.out.print("Reading " + args[0] + " ");
            DataImpl data = form.open(args[0]);
            System.out.println("[done]");
            System.out.println("MathType =\n" + data.getType().prettyString());
        } else if (args.length == 2) {
            System.out.print(args[0] + " -> " + args[1] + " ");
            DefaultFamily loader = new DefaultFamily("loader");
            DataImpl data = loader.open(args[0]);
            loader = null;
            TiffForm form = new TiffForm();
            form.save(args[1], data, true);
            System.out.println("[done]");
        }
        System.exit(0);
    }
}

