/*
 * Decompiled with CFR 0.152.
 */
package visad.data.netcdf;

import java.util.Iterator;
import visad.Unit;
import visad.UnitException;
import visad.VisADException;
import visad.data.netcdf.Quantity;
import visad.data.units.NoSuchUnitException;
import visad.data.units.ParseException;
import visad.data.units.Parser;

public abstract class QuantityDB {
    public abstract Quantity get(String var1);

    public abstract Quantity[] get(Unit var1);

    public synchronized Quantity get(String name, String unitSpec) throws ParseException, NoSuchUnitException, UnitException, VisADException {
        Quantity quantity = this.get(name);
        if (quantity == null) {
            quantity = new Quantity(name, unitSpec);
            this.add(quantity);
        } else {
            Unit quantityUnit = quantity.getDefaultUnit();
            if (!Unit.canConvert(Parser.parse(unitSpec), quantityUnit)) {
                throw new UnitException("Quantity " + name + " already exists; its unit " + quantity.getDefaultUnitString() + " is inconvertible with " + unitSpec);
            }
        }
        return quantity;
    }

    public abstract void add(String var1, Quantity var2) throws VisADException;

    public void add(Quantity quantity) throws VisADException {
        this.add(quantity.getName(), quantity);
    }

    public abstract Iterator quantityIterator();

    public abstract Iterator nameIterator();
}

