/*
 * Decompiled with CFR 0.152.
 */
package visad.data.netcdf;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.StringTokenizer;
import java.util.TreeSet;
import ucar.netcdf.NetcdfFile;
import ucar.netcdf.Schema;
import ucar.netcdf.Variable;
import ucar.netcdf.VariableIterator;
import visad.Data;
import visad.DataImpl;
import visad.UnimplementedException;
import visad.VisADException;
import visad.data.BadFormException;
import visad.data.FormNode;
import visad.data.netcdf.NetCDF;
import visad.data.netcdf.QuantityDB;
import visad.data.netcdf.QuantityDBManager;
import visad.data.netcdf.VariableFilter;
import visad.data.netcdf.in.NetcdfAdapter;
import visad.data.netcdf.in.Strategy;
import visad.data.netcdf.out.VisADAdapter;

public class Plain
extends NetCDF {
    private final QuantityDB quantityDB;

    public Plain() throws VisADException {
        this(QuantityDBManager.instance());
    }

    public Plain(QuantityDB db) {
        super("Plain");
        this.quantityDB = db;
    }

    public synchronized void save(String path, Data data, boolean replace) throws BadFormException, IOException, RemoteException, VisADException, UnimplementedException {
        VisADAdapter adapter = new VisADAdapter(data);
        Schema schema = new Schema(adapter);
        NetcdfFile file = new NetcdfFile(path, replace, false, schema);
        try {
            VariableIterator iter = file.iterator();
            while (iter.hasNext()) {
                Variable outVar = iter.next();
                Variable inVar = adapter.get(outVar.getName());
                int rank = outVar.getRank();
                int[] origin = new int[rank];
                int i = 0;
                while (i < rank) {
                    origin[i] = 0;
                    ++i;
                }
                outVar.copyin(origin, inVar);
            }
            Object var14_13 = null;
        }
        catch (Throwable throwable) {
            Object var14_14 = null;
            file.close();
            throw throwable;
        }
        file.close();
    }

    public synchronized void add(String id, Data data, boolean replace) throws BadFormException {
    }

    public synchronized DataImpl open(String spec) throws BadFormException, IOException, VisADException {
        return new NetcdfAdapter(new NetcdfFile(spec, true), this.quantityDB).getData();
    }

    public synchronized DataImpl open(String spec, Strategy strategy) throws BadFormException, IOException, VisADException {
        return new NetcdfAdapter(new NetcdfFile(spec, true), this.quantityDB).getData(strategy);
    }

    public synchronized DataImpl openProxy(String path) throws BadFormException, IOException, VisADException {
        NetcdfFile file = new NetcdfFile(path, true);
        return new NetcdfAdapter(file, this.quantityDB).getProxy();
    }

    public synchronized DataImpl open(URL url) throws FileNotFoundException, IOException, VisADException {
        String file = url.getFile();
        int i = file.indexOf(63);
        String query = i == -1 ? null : (i == file.length() - 1 ? "" : file.substring(i + 1));
        TreeSet<String> names = new TreeSet<String>();
        if (query != null) {
            StringTokenizer st = new StringTokenizer(query, ",");
            while (st.hasMoreTokens()) {
                names.add(st.nextToken());
            }
        }
        NetcdfFile netcdf = new NetcdfFile(url);
        return new NetcdfAdapter(query == null ? netcdf : new VariableFilter(netcdf, names), this.quantityDB).getData();
    }

    public synchronized FormNode getForms(Data data) throws VisADException, RemoteException, IOException {
        Plain form;
        try {
            VisADAdapter adapter = new VisADAdapter(data);
            form = this;
        }
        catch (BadFormException e) {
            form = null;
        }
        return form;
    }

    public static void main(String[] args) throws Exception {
        DataImpl data;
        String outPath = "plain.nc";
        String inPath = args.length == 0 ? "test.nc" : args[0];
        Plain plain = new Plain();
        System.out.println("Opening netCDF dataset \"" + inPath + "\"");
        try {
            URL url = new URL(inPath);
            data = plain.open(url);
        }
        catch (MalformedURLException e) {
            data = plain.open(inPath);
        }
        if (data == null) {
            System.out.println("No data");
        } else {
            System.out.println("data.getType().toString():\n" + data.getType());
            System.out.println("Writing netCDF dataset \"" + outPath + "\"");
            plain.save(outPath, data, true);
        }
    }
}

