/*
 * Decompiled with CFR 0.152.
 */
package visad.data.mcidas;

import java.io.RandomAccessFile;
import java.util.ArrayList;
import visad.CoordinateSystem;
import visad.data.mcidas.McIDASGridDirectory;

public class McIDASGridReader {
    ArrayList gridH = null;
    ArrayList gridD = null;
    int[] entry;
    RandomAccessFile fn;

    public ArrayList getGridData(String filename) {
        try {
            this.fn = new RandomAccessFile(filename, "r");
            this.fn.seek(0L);
            int[] fileHeader = new int[10];
            int i = 0;
            while (i < 10) {
                fileHeader[i] = this.fn.readInt();
                System.out.println("head=" + fileHeader[i]);
                ++i;
            }
            int numEntries = Math.abs(this.fn.readInt());
            System.out.println("number entries=" + numEntries);
            this.entry = new int[numEntries];
            int i2 = 0;
            while (i2 < numEntries) {
                this.entry[i2] = this.fn.readInt();
                ++i2;
            }
            this.readEntry(0);
        }
        catch (Exception e) {
            System.out.println("exp=" + e);
        }
        return this.gridD;
    }

    private void readEntry(int ent) {
        try {
            int te = this.entry[ent] * 4;
            System.out.println("Entry 0 = " + te);
            byte[] gridHeader = new byte[256];
            this.fn.seek(te);
            this.fn.readFully(gridHeader);
            McIDASGridDirectory mgd = new McIDASGridDirectory(gridHeader);
            System.out.println("grid header =" + mgd.toString());
            CoordinateSystem c = mgd.getCoordinateSystem();
            int rows = mgd.getRows();
            int cols = mgd.getColumns();
            System.out.println("# rows & cols = " + rows + " " + cols);
            double scale = mgd.getParamScale();
            double[] data = new double[rows * cols];
            boolean n = false;
            int nc = 0;
            while (nc < cols) {
                int nr = 0;
                while (nr < rows) {
                    int temp = this.fn.readInt();
                    data[(rows - nr - 1) * cols + nc] = temp == -2139062144 ? Double.NaN : (double)temp / scale;
                    ++nr;
                }
                ++nc;
            }
            this.gridH = new ArrayList();
            this.gridD = new ArrayList();
            this.gridH.add(mgd);
            this.gridD.add(data);
        }
        catch (Exception esc) {
            System.out.println(esc);
        }
    }

    public ArrayList getGrid(int index) {
        this.readEntry(index);
        return this.gridD;
    }

    public ArrayList getGridHeaders() {
        return this.gridH;
    }

    public static void main(String[] a) {
        McIDASGridReader mg = new McIDASGridReader();
        mg.getGridData("/src/visad/data/mcidas/GRID1715");
    }
}

