/*
 * Decompiled with CFR 0.152.
 */
package visad.data.in;

import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.WeakHashMap;
import visad.data.in.ValueVetter;

final class MultipleValueVetter
extends ValueVetter {
    private double[] doubleValues;
    private float[] floatValues;
    private static final WeakHashMap map = new WeakHashMap();

    private MultipleValueVetter(double[] values) {
        this.doubleValues = values;
        this.floatValues = new float[values.length];
        int i = 0;
        while (i < values.length) {
            this.floatValues[i] = (float)values[i];
            ++i;
        }
    }

    static synchronized MultipleValueVetter multipleValueVetter(double[] values) {
        MultipleValueVetter vetter = new MultipleValueVetter(values);
        WeakReference ref = (WeakReference)map.get(vetter);
        if (ref == null) {
            map.put(vetter, new WeakReference<MultipleValueVetter>(vetter));
        } else {
            MultipleValueVetter oldVetter = (MultipleValueVetter)ref.get();
            if (oldVetter == null) {
                map.put(vetter, new WeakReference<MultipleValueVetter>(vetter));
            } else {
                vetter = oldVetter;
            }
        }
        return vetter;
    }

    public float process(float value) {
        int i = 0;
        while (i < this.floatValues.length) {
            if (value == this.floatValues[i]) {
                return Float.NaN;
            }
            ++i;
        }
        return value;
    }

    public double process(double value) {
        int i = 0;
        while (i < this.doubleValues.length) {
            if (value == this.doubleValues[i]) {
                return Double.NaN;
            }
            ++i;
        }
        return value;
    }

    public float[] process(float[] values) {
        int i = 0;
        while (i < values.length) {
            int j = 0;
            while (j < this.floatValues.length) {
                if (values[i] == this.floatValues[j]) {
                    values[i] = Float.NaN;
                    break;
                }
                ++j;
            }
            ++i;
        }
        return values;
    }

    public double[] process(double[] values) {
        int i = 0;
        while (i < values.length) {
            int j = 0;
            while (j < this.doubleValues.length) {
                if (values[i] == this.doubleValues[j]) {
                    values[i] = Double.NaN;
                    break;
                }
                ++j;
            }
            ++i;
        }
        return values;
    }

    public boolean equals(Object obj) {
        MultipleValueVetter that;
        boolean equals = !this.getClass().isInstance(obj) ? false : this == (that = (MultipleValueVetter)obj) || Arrays.equals(this.doubleValues, that.doubleValues);
        return equals;
    }

    public int hashCode() {
        int code = 0;
        int i = 0;
        while (i < this.doubleValues.length) {
            code ^= new Double(this.doubleValues[i]).hashCode();
            ++i;
        }
        return code;
    }
}

