/*
 * Decompiled with CFR 0.152.
 */
package visad.data.ij;

import ij.ImagePlus;
import ij.io.Opener;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.rmi.RemoteException;
import visad.Data;
import visad.DataImpl;
import visad.VisADException;
import visad.data.BadFormException;
import visad.data.Form;
import visad.data.FormFileInformer;
import visad.data.FormNode;
import visad.util.DataUtility;

public class ImageJForm
extends Form
implements FormFileInformer {
    private static int num = 0;
    private static final String[] suffixes = new String[]{"tif", "tiff", "dicom", "fits", "pgm", "jpg", "jpeg", "gif", "lut", "bmp", "zip", "roi"};
    private Opener opener = new Opener();

    public ImageJForm() {
        super("ImageJForm" + num++);
    }

    public boolean isThisType(String name) {
        int i = 0;
        while (i < suffixes.length) {
            if (name.toLowerCase().endsWith(suffixes[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean isThisType(byte[] block) {
        return false;
    }

    public String[] getDefaultSuffixes() {
        String[] s = new String[suffixes.length];
        System.arraycopy(suffixes, 0, s, 0, suffixes.length);
        return s;
    }

    public void save(String id, Data data, boolean replace) throws BadFormException, IOException, RemoteException, VisADException {
        throw new BadFormException("ImageJForm.save");
    }

    public void add(String id, Data data, boolean replace) throws BadFormException {
        throw new BadFormException("ImageJForm.add");
    }

    public DataImpl open(String id) throws BadFormException, IOException, VisADException {
        File file = new File(id);
        ImagePlus image = this.opener.openImage(file.getParent() + System.getProperty("file.separator"), file.getName());
        return DataUtility.makeField(image.getImage());
    }

    public DataImpl open(URL url) throws BadFormException, IOException, VisADException {
        ImagePlus image = this.opener.openURL(url.toString());
        return DataUtility.makeField(image.getImage());
    }

    public FormNode getForms(Data data) {
        return null;
    }

    public static void main(String[] args) throws VisADException, RemoteException, IOException {
        if (args == null || args.length < 1) {
            System.out.println("To test read an image file, run:");
            System.out.println("  java visad.data.ij.ImageJForm in_file");
            System.exit(2);
        }
        ImageJForm form = new ImageJForm();
        System.out.print("Reading " + args[0] + " ");
        DataImpl data = form.open(args[0]);
        System.out.println("[done]");
        System.out.println("MathType =\n" + data.getType().prettyString());
        System.exit(0);
    }
}

