/*
 * Decompiled with CFR 0.152.
 */
package visad.data.hdfeos;

import java.rmi.RemoteException;
import visad.DataImpl;
import visad.FlatField;
import visad.FunctionType;
import visad.MathType;
import visad.RealTupleType;
import visad.RealType;
import visad.Set;
import visad.UnimplementedException;
import visad.VisADException;
import visad.data.FileFlatField;
import visad.data.hdfeos.Calibration;
import visad.data.hdfeos.DimensionSet;
import visad.data.hdfeos.EosGrid;
import visad.data.hdfeos.EosStruct;
import visad.data.hdfeos.EosSwath;
import visad.data.hdfeos.HdfeosAccessor;
import visad.data.hdfeos.HdfeosData;
import visad.data.hdfeos.HdfeosDomain;
import visad.data.hdfeos.HdfeosException;
import visad.data.hdfeos.HdfeosForm;
import visad.data.hdfeos.NamedDimension;
import visad.data.hdfeos.Variable;
import visad.data.hdfeos.VariableSet;

public class HdfeosFlatField
extends HdfeosData {
    HdfeosDomain domain;
    Variable[] range_s;
    int n_fields;
    int r_rank;
    int d_rank;
    String[] name_s;
    int[] num_type;
    Calibration[] cal;
    FunctionType mathtype;
    EosStruct struct;
    boolean pointStruct = false;
    int[] start = null;
    int[] inv_start = null;
    int[] stride = null;
    int[] inv_stride = null;
    int[] edge = null;
    int[] inv_edge = null;
    DimensionSet rangeDimSet = null;
    DimensionSet domainDimSet = null;
    FlatField data = null;

    public HdfeosFlatField(HdfeosDomain domain, Variable[] range_s) throws VisADException, UnimplementedException, HdfeosException {
        this.initialize(domain, range_s);
    }

    public HdfeosFlatField(HdfeosDomain domain, Variable range) throws VisADException, UnimplementedException, HdfeosException {
        Variable[] range_s = new Variable[]{range};
        this.initialize(domain, range_s);
    }

    public HdfeosFlatField(HdfeosDomain domain, VariableSet range_s) throws VisADException, UnimplementedException, HdfeosException {
        this.initialize(domain, range_s.getElements());
    }

    private void initialize(HdfeosDomain domain, Variable[] range_s) throws VisADException, UnimplementedException, HdfeosException {
        this.domain = domain;
        this.struct = domain.getStruct();
        this.n_fields = range_s.length;
        this.name_s = new String[this.n_fields];
        this.num_type = new int[this.n_fields];
        this.cal = new Calibration[this.n_fields];
        int ii = 0;
        while (ii < this.n_fields) {
            this.name_s[ii] = range_s[ii].getName();
            this.num_type[ii] = range_s[ii].getNumberType();
            this.cal[ii] = range_s[ii].getCalibration();
            ++ii;
        }
        this.mathtype = this.makeType();
        if (this.struct instanceof EosSwath || this.struct instanceof EosGrid) {
            this.rangeDimSet = range_s[0].getDimSet();
            this.r_rank = this.rangeDimSet.getSize();
            this.domainDimSet = domain.getDimSet();
            this.d_rank = this.domainDimSet.getSize();
            if (this.d_rank > this.r_rank) {
                throw new HdfeosException("d_rank > r_rank");
            }
            this.start = new int[this.r_rank];
            this.inv_start = new int[this.r_rank];
            this.edge = new int[this.r_rank];
            this.inv_edge = new int[this.r_rank];
            this.stride = new int[this.r_rank];
            this.inv_stride = new int[this.r_rank];
            int ii2 = 0;
            while (ii2 < this.r_rank) {
                NamedDimension n_dim = this.rangeDimSet.getElement(ii2);
                this.start[ii2] = 0;
                this.edge[ii2] = n_dim.getLength();
                this.stride[ii2] = 1;
                ++ii2;
            }
        } else {
            this.pointStruct = true;
            throw new UnimplementedException("ECS structmetadata: POINT");
        }
    }

    public MathType getType() throws VisADException {
        return this.mathtype;
    }

    public DataImpl getData() throws VisADException, RemoteException {
        return this.getData(null);
    }

    public DataImpl getAdaptedData() throws VisADException, RemoteException {
        HdfeosAccessor accessor = new HdfeosAccessor(this, null);
        FileFlatField f_field = new FileFlatField(accessor, HdfeosForm.c_strategy);
        return f_field;
    }

    public DataImpl getData(int[] indexes) throws VisADException, RemoteException {
        Set set = null;
        if (!this.pointStruct) {
            int ii;
            if (indexes == null) {
                if (this.data != null) {
                    return this.data;
                }
                set = this.domain.getData();
            } else {
                if (this.d_rank == this.r_rank) {
                    set = this.domain.getData(indexes);
                } else if (this.d_rank < this.r_rank) {
                    set = this.domain.getData();
                }
                int cnt = 0;
                int ii2 = 0;
                while (ii2 < indexes.length) {
                    this.start[cnt] = indexes[ii2];
                    this.edge[cnt] = 1;
                    ++cnt;
                    ++ii2;
                }
            }
            if (this.struct instanceof EosSwath) {
                ii = 0;
                while (ii < this.r_rank) {
                    this.inv_start[ii] = this.start[this.r_rank - 1 - ii];
                    this.inv_edge[ii] = this.edge[this.r_rank - 1 - ii];
                    this.inv_stride[ii] = this.stride[this.r_rank - 1 - ii];
                    ++ii;
                }
            } else {
                ii = 0;
                while (ii < this.r_rank) {
                    this.inv_start[ii] = this.start[ii];
                    this.inv_edge[ii] = this.edge[ii];
                    this.inv_stride[ii] = this.stride[ii];
                    ++ii;
                }
            }
            FlatField f_field = new FlatField(this.mathtype, set);
            int n_samples = set.getLength();
            float[][] f_array = new float[this.n_fields][n_samples];
            int kk = 0;
            while (kk < this.n_fields) {
                this.struct.readData(this.name_s[kk], this.inv_start, this.inv_stride, this.inv_edge, this.num_type[kk], this.cal[kk], f_array[kk]);
                ++kk;
            }
            f_field.setSamples(f_array);
            this.data = f_field;
            return this.data;
        }
        return null;
    }

    public DataImpl getAdaptedData(int[] indexes) throws VisADException {
        HdfeosAccessor accessor = new HdfeosAccessor(this, indexes);
        FileFlatField f_field = new FileFlatField(accessor, HdfeosForm.c_strategy);
        return f_field;
    }

    private FunctionType makeType() throws VisADException {
        MathType domain_type = this.domain.getType();
        RealType[] r_types = new RealType[this.n_fields];
        int ii = 0;
        while (ii < this.n_fields) {
            r_types[ii] = RealType.getRealType(this.name_s[ii], null, null);
            ++ii;
        }
        MathType range_type = this.n_fields == 1 ? r_types[0] : new RealTupleType(r_types);
        FunctionType f_type = new FunctionType(domain_type, range_type);
        return f_type;
    }
}

