/*
 * Decompiled with CFR 0.152.
 */
package visad.data.hdfeos;

import java.util.StringTokenizer;
import java.util.Vector;
import visad.data.hdfeos.CalibrationDefault;
import visad.data.hdfeos.DimensionSet;
import visad.data.hdfeos.EosStruct;
import visad.data.hdfeos.GeoMap;
import visad.data.hdfeos.GeoMapSet;
import visad.data.hdfeos.HdfeosException;
import visad.data.hdfeos.NamedDimension;
import visad.data.hdfeos.ShapeSet;
import visad.data.hdfeos.Variable;
import visad.data.hdfeos.VariableSet;
import visad.data.hdfeos.hdfeosc.HdfeosLib;

public class EosSwath
extends EosStruct {
    int swath_id;
    int sd_id;
    private String swath_name;
    GeoMapSet G_Set;
    DimensionSet D_Set;
    VariableSet DV_Set;
    VariableSet GV_Set;
    ShapeSet DV_shapeSet;
    ShapeSet GV_shapeSet;

    EosSwath(int file_id, int sd_id, String name) throws HdfeosException {
        this.swath_name = name;
        this.sd_id = sd_id;
        this.struct_id = this.swath_id = HdfeosLib.SWattach(file_id, name);
        if (this.swath_id < 0) {
            throw new HdfeosException(" EosSwath cannot attach to swath: " + name);
        }
        int[] stringSize = new int[]{0};
        int n_maps = HdfeosLib.SWnentries(this.swath_id, 1, stringSize);
        if (n_maps > 0) {
            int[] offset = new int[n_maps];
            int[] increment = new int[n_maps];
            String[] map_list = new String[]{"empty"};
            n_maps = HdfeosLib.SWinqmaps(this.swath_id, stringSize[0], map_list, offset, increment);
            this.G_Set = new GeoMapSet();
            StringTokenizer mapElements = new StringTokenizer(map_list[0], ",", false);
            int cnt = 0;
            while (mapElements.hasMoreElements()) {
                String map = (String)mapElements.nextElement();
                StringTokenizer dims = new StringTokenizer(map, "/", false);
                String[] S_array = new String[2];
                int cnt2 = 0;
                while (dims.hasMoreElements()) {
                    S_array[cnt2] = (String)dims.nextElement();
                    ++cnt2;
                }
                String toDim = S_array[1];
                String fromDim = S_array[0];
                int off = offset[cnt];
                int inc = increment[cnt];
                GeoMap obj = new GeoMap(toDim, fromDim, off, inc);
                this.G_Set.add(obj);
            }
        } else {
            this.G_Set = new GeoMapSet();
        }
        int n_dims = HdfeosLib.SWnentries(this.swath_id, 0, stringSize);
        if (n_dims <= 0) {
            throw new HdfeosException("no dimension defined");
        }
        DimensionSet D_Set = new DimensionSet();
        String[] dimensionList = new String[]{"empty"};
        int[] lengths = new int[n_dims];
        if ((n_dims = HdfeosLib.SWinqdims(this.swath_id, stringSize[0], dimensionList, lengths)) <= 0) {
            throw new HdfeosException("no dimension defined");
        }
        StringTokenizer listElements = new StringTokenizer(dimensionList[0], ",", false);
        int cnt = 0;
        while (listElements.hasMoreElements()) {
            name = (String)listElements.nextElement();
            int len = lengths[cnt];
            GeoMap g_map = this.G_Set.getGeoMap(name);
            NamedDimension obj = new NamedDimension(this.swath_id, name, len, g_map);
            D_Set.add(obj);
            ++cnt;
        }
        this.D_Set = D_Set;
        int n_flds = HdfeosLib.SWnentries(this.swath_id, 4, stringSize);
        if (n_flds <= 0) {
            throw new HdfeosException(" no Data Fields from SWnentries ");
        }
        String[] D_List = new String[]{"empty"};
        int[] dumA = new int[n_flds];
        int[] dumB = new int[n_flds];
        if ((n_flds = HdfeosLib.SWinqdatafields(this.swath_id, stringSize[0], D_List, dumA, dumB)) < 0) {
            throw new HdfeosException("no data fields in swath # " + this.swath_id);
        }
        this.makeVariables(D_List[0], EosStruct.D_TYPE);
        n_flds = HdfeosLib.SWnentries(this.swath_id, 3, stringSize);
        String[] G_List = new String[]{"empty"};
        int[] dumC = new int[n_flds];
        int[] dumD = new int[n_flds];
        n_flds = HdfeosLib.SWinqgeofields(this.swath_id, stringSize[0], G_List, dumC, dumD);
        this.makeVariables(G_List[0], EosStruct.G_TYPE);
        this.DV_shapeSet = new ShapeSet(this.DV_Set);
        this.GV_shapeSet = new ShapeSet(this.GV_Set);
    }

    public int getStructId() {
        return this.swath_id;
    }

    public ShapeSet getDV_shapeSet() {
        return this.DV_shapeSet;
    }

    public ShapeSet getGV_shapeSet() {
        return this.GV_shapeSet;
    }

    private void makeVariables(String fieldList, String f_type) throws HdfeosException {
        int[] rank = new int[1];
        int[] type = new int[1];
        int[] lengths = new int[10];
        StringTokenizer listElements = new StringTokenizer(fieldList, ",", false);
        VariableSet varSet = new VariableSet();
        String[] constantNames = CalibrationDefault.getNames();
        double[][] constants = new double[constantNames.length][];
        while (listElements.hasMoreElements()) {
            int stat;
            CalibrationDefault calibration;
            int cnt;
            boolean noAttr = false;
            boolean noAttrValue = false;
            String field = (String)listElements.nextElement();
            int ii = 0;
            while (ii < constants.length) {
                cnt = HdfeosLib.SDattrinfo(this.sd_id, field, constantNames[ii]);
                if (cnt < 0) {
                    noAttr = true;
                    break;
                }
                constants[ii] = new double[cnt];
                ++ii;
            }
            if (noAttr) {
                calibration = null;
            } else {
                int ii2 = 0;
                while (ii2 < constants.length) {
                    stat = HdfeosLib.GetNumericAttr(this.sd_id, field, constantNames[ii2], constants[ii2]);
                    if (stat < 0) {
                        noAttrValue = true;
                        break;
                    }
                    ++ii2;
                }
                calibration = noAttrValue ? null : new CalibrationDefault(constants);
            }
            String[] dim_list = new String[]{"empty"};
            stat = HdfeosLib.SWfieldinfo(this.swath_id, field, dim_list, rank, lengths, type);
            StringTokenizer dimListElements = new StringTokenizer(dim_list[0], ",", false);
            Vector dims = new Vector();
            DimensionSet newSet = new DimensionSet();
            cnt = 0;
            while (dimListElements.hasMoreElements()) {
                String dimName = (String)dimListElements.nextElement();
                NamedDimension n_dim = this.D_Set.getByName(dimName);
                if (n_dim.isUnlimited()) {
                    n_dim.setLength(lengths[cnt]);
                }
                newSet.add(n_dim);
                ++cnt;
            }
            newSet.setToFinished();
            Variable obj = new Variable(field, newSet, rank[0], type[0], calibration);
            varSet.add(obj);
        }
        varSet.setToFinished();
        if (f_type.equals(EosStruct.G_TYPE)) {
            this.GV_Set = varSet;
        } else {
            this.DV_Set = varSet;
        }
    }
}

