/*
 * Decompiled with CFR 0.152.
 */
package visad.data.hdf5;

import java.net.URL;
import java.rmi.RemoteException;
import ncsa.hdf.hdf5lib.H5;
import ncsa.hdf.hdf5lib.exceptions.HDF5Exception;
import visad.Data;
import visad.DataImpl;
import visad.Field;
import visad.FieldImpl;
import visad.FlatField;
import visad.FunctionType;
import visad.GriddedSet;
import visad.Integer1DSet;
import visad.MathType;
import visad.RealType;
import visad.Set;
import visad.Text;
import visad.TextType;
import visad.Tuple;
import visad.TupleType;
import visad.UnimplementedException;
import visad.VisADException;
import visad.data.BadFormException;
import visad.data.Form;
import visad.data.FormFileInformer;
import visad.data.FormNode;
import visad.data.hdf5.HDF5AdapterException;
import visad.data.hdf5.HDF5DataAdaptable;
import visad.data.hdf5.HDF5DatasetAdapted;
import visad.data.hdf5.HDF5FileAdapted;
import visad.data.hdf5.HDF5GroupAdapted;
import visad.data.hdf5.hdf5objects.HDF5Object;

public class HDF5Form
extends Form
implements FormFileInformer {
    public HDF5Form() {
        this("HDF5 Data");
    }

    public HDF5Form(String name) {
        super(name);
    }

    public boolean isThisType(String name) {
        boolean retVal = false;
        try {
            retVal = H5.H5Fis_hdf5(name);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return retVal;
    }

    public boolean isThisType(byte[] block) {
        int firstByte = new Byte(block[0]).intValue();
        if (firstByte != 137) {
            return false;
        }
        String bytes2to4 = new String(block, 1, 4);
        return bytes2to4.startsWith("HDF");
    }

    public String[] getDefaultSuffixes() {
        String[] suffs = new String[]{"hdf", "h5"};
        return suffs;
    }

    public FormNode getForms(Data data) {
        return this;
    }

    public DataImpl open(String file_path) throws VisADException, RemoteException {
        HDF5FileAdapted file = null;
        try {
            file = new HDF5FileAdapted(file_path, 0, -2);
        }
        catch (HDF5Exception e) {
            System.err.println(e);
        }
        return this.getFileData(file);
    }

    public DataImpl open(URL url) throws VisADException {
        throw new UnimplementedException("HDF5Form.open( URL )");
    }

    public void add(String id, Data data, boolean replace) throws BadFormException {
        throw new BadFormException("HDF5Form.add( String, Data, boolean )");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void save(String filename, Data data, boolean replace) throws BadFormException, RemoteException, VisADException {
        int fid = 0;
        boolean did = false;
        boolean gid = false;
        try {
            fid = H5.H5Fcreate(filename, 2, -2, -2);
        }
        catch (HDF5Exception e) {
            throw new HDF5AdapterException("HDF5Form.save() failed: cannot create file " + filename);
        }
        catch (NoClassDefFoundError e) {
            throw new HDF5AdapterException("HDF5Form.save() failed: cannot create file " + filename);
        }
        try {
            try {
                this.save(fid, data, 0, 0);
            }
            catch (BadFormException e) {
                throw e;
            }
            catch (RemoteException e) {
                throw e;
            }
            catch (VisADException e) {
                throw e;
            }
            catch (HDF5Exception e) {
                throw new HDF5AdapterException(e.toString());
            }
            Object var12_11 = null;
        }
        catch (Throwable throwable) {
            Object var12_12 = null;
            try {
                H5.H5Fclose(fid);
                throw throwable;
            }
            catch (Exception e) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception e) {}
        H5.H5Fclose(fid);
        return;
    }

    private void save(int pid, Data data, int level, int index) throws BadFormException, RemoteException, VisADException, HDF5Exception {
        block18: {
            if (data instanceof Tuple) {
                int g_idx = 0;
                int new_pid = 0;
                Data d = null;
                Tuple tuple = (Tuple)data;
                String gname = "Group" + index + "at" + level;
                if (level == 0) {
                    new_pid = pid;
                    g_idx = -1;
                } else {
                    new_pid = H5.H5Gcreate(pid, gname, -1);
                }
                int n = tuple.getDimension();
                int i = 0;
                while (i < n) {
                    d = tuple.getComponent(i);
                    this.save(new_pid, d, level + 1, g_idx++);
                    ++i;
                }
            } else {
                if (data instanceof Field) {
                    int j;
                    Field field = (Field)data;
                    RealType[] rTypes = ((FunctionType)field.getType()).getRealComponents();
                    Set dset = field.getDomainSet();
                    if (!(dset instanceof GriddedSet) || rTypes == null) {
                        return;
                    }
                    GriddedSet domain = (GriddedSet)dset;
                    RealType rangeType = rTypes[0];
                    int sid = 0;
                    int did = 0;
                    int tid = 0;
                    int l = domain.getLength();
                    int[] ddims = domain.getLengths();
                    int rank = ddims.length;
                    long[] dims = new long[rank];
                    int i = 0;
                    while (i < rank) {
                        dims[i] = ddims[i];
                        ++i;
                    }
                    sid = H5.H5Screate_simple(rank, dims, null);
                    int number_of_range_components = 1;
                    number_of_range_components = field.isFlatField() ? ((FlatField)field).getRangeDimension() : field.getDefaultRangeUnits().length;
                    float[] rangeValues = new float[l];
                    float[][] rValue = field.getFloats(false);
                    if (number_of_range_components == 1) {
                        int i2 = 0;
                        while (i2 < l) {
                            rangeValues[i2] = rValue[0][i2];
                            ++i2;
                        }
                        try {
                            did = H5.H5Dcreate(pid, rangeType.getName(), H5.J2C(55), sid, -2);
                            H5.H5Dwrite(did, H5.J2C(55), -2, -2, -2, rangeValues);
                            Object var23_40 = null;
                        }
                        catch (Throwable throwable) {
                            Object var23_41 = null;
                            H5.H5Dclose(did);
                            H5.H5Sclose(sid);
                            throw throwable;
                        }
                        H5.H5Dclose(did);
                        H5.H5Sclose(sid);
                        {
                            break block18;
                        }
                    }
                    float[][] fValue = new float[l][number_of_range_components];
                    int i3 = 0;
                    while (i3 < l) {
                        j = 0;
                        while (j < number_of_range_components) {
                            fValue[i3][j] = rValue[j][i3];
                            ++j;
                        }
                        ++i3;
                    }
                    try {
                        tid = H5.H5Tcreate(6, number_of_range_components * 4);
                        j = 0;
                        while (j < number_of_range_components) {
                            rangeType = rTypes[j];
                            H5.H5Tinsert(tid, rangeType.getName(), j * 4, H5.J2C(55));
                            ++j;
                        }
                        String dname = "Compound" + index + "at" + level;
                        did = H5.H5Dcreate(pid, dname, tid, sid, -2);
                        H5.H5Dwrite(did, tid, sid, -2, -2, fValue);
                        Object var26_46 = null;
                    }
                    catch (Throwable throwable) {
                        Object var26_47 = null;
                        H5.H5Tclose(tid);
                        H5.H5Dclose(did);
                        H5.H5Sclose(sid);
                        throw throwable;
                    }
                    H5.H5Tclose(tid);
                    H5.H5Dclose(did);
                    H5.H5Sclose(sid);
                    {
                        break block18;
                    }
                }
                if (data instanceof Text) {
                    Text text = (Text)data;
                    String text_value = text.getValue();
                    TextType tt = (TextType)text.getType();
                    String text_name = tt.getName();
                    int max_length = text_value.length();
                    long[] dims_str = new long[]{1L};
                    int dataspace = H5.H5Screate_simple(1, dims_str, null);
                    int datatype = H5.H5Tcopy(H5.J2C(15));
                    H5.H5Tset_size(datatype, max_length);
                    H5.H5Tset_strpad(datatype, 1);
                    int dataset = H5.H5Dcreate(pid, text_name, datatype, dataspace, -2);
                    byte[][] bnotes = new byte[1][max_length];
                    bnotes[0] = text_value.getBytes();
                    H5.H5Dwrite(dataset, datatype, -2, -2, -2, bnotes);
                    H5.H5Dclose(dataset);
                    bnotes = null;
                }
            }
        }
    }

    public MathType getMathType(HDF5FileAdapted file) throws VisADException, RemoteException {
        MathType mathType = null;
        HDF5Object data = null;
        int n_structs = file.getObjectCount();
        if (n_structs <= 0) {
            throw new HDF5AdapterException("no data object in file: " + file.getName());
        }
        MathType[] types = new MathType[n_structs];
        int i = 0;
        while (i < n_structs) {
            Object obj = file.getDataObject(i);
            if (obj instanceof HDF5GroupAdapted) {
                data = (HDF5GroupAdapted)obj;
            } else if (obj instanceof HDF5DatasetAdapted) {
                data = (HDF5DatasetAdapted)obj;
            }
            types[i] = mathType = data.getMathType();
            ++i;
        }
        TupleType t_type = new TupleType(types);
        return t_type;
    }

    public DataImpl getFileData(HDF5FileAdapted file) throws VisADException, RemoteException {
        Object data = null;
        Object h5Data = null;
        int n_structs = file.getObjectCount();
        if (n_structs <= 0) {
            throw new HDF5AdapterException("no data object in file: " + file.getName());
        }
        HDF5DataAdaptable[] datas = new HDF5DataAdaptable[n_structs];
        int ndatas = 0;
        int i = 0;
        while (i < n_structs) {
            Object obj = file.getDataObject(i);
            if (obj instanceof HDF5GroupAdapted) {
                datas[ndatas++] = (HDF5GroupAdapted)obj;
            } else if (obj instanceof HDF5DatasetAdapted) {
                datas[ndatas++] = (HDF5DatasetAdapted)obj;
            }
            ++i;
        }
        return this.assembleStructs(datas);
    }

    private DataImpl assembleStructs(HDF5DataAdaptable[] h_datas) throws VisADException, RemoteException {
        DataImpl fileData = null;
        int n_structs = h_datas.length;
        if (n_structs == 1) {
            return this.getVisADDataObject(h_datas[0]);
        }
        boolean types_equal = true;
        MathType first_type = null;
        MathType[] types = new MathType[n_structs];
        Data[] datas = new DataImpl[n_structs];
        datas[0] = this.getVisADDataObject(h_datas[0]);
        types[0] = datas[0].getType();
        first_type = types[0];
        int i = 1;
        while (i < n_structs) {
            datas[i] = this.getVisADDataObject(h_datas[i]);
            types[i] = ((DataImpl)datas[i]).getType();
            types_equal = types[i].equals(first_type);
            ++i;
        }
        if (types_equal) {
            RealType struct_id = RealType.getRealType("struct_id");
            Integer1DSet domain = new Integer1DSet((MathType)struct_id, n_structs);
            FunctionType fType = new FunctionType(struct_id, first_type);
            FieldImpl field = new FieldImpl(fType, domain);
            int i2 = 0;
            while (i2 < n_structs) {
                field.setSample(i2, datas[i2]);
                ++i2;
            }
            fileData = field;
        } else {
            TupleType t_type = new TupleType(types);
            fileData = new Tuple(t_type, datas, false);
        }
        return fileData;
    }

    public DataImpl getVisADDataObject(HDF5DataAdaptable h_data) throws VisADException, RemoteException {
        return h_data.getAdaptedData();
    }
}

