/*
 * Decompiled with CFR 0.152.
 */
package visad.data.dods;

import dods.dap.AttributeTable;
import dods.dap.BaseType;
import dods.dap.DAS;
import dods.dap.DConnect;
import dods.dap.DODSException;
import dods.dap.parser.ParseException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.Enumeration;
import visad.DataImpl;
import visad.VisADException;
import visad.data.BadFormException;
import visad.data.dods.DataFactory;
import visad.data.in.DataInputSource;

public class DODSSource
implements DataInputSource {
    private DataFactory dataFactory;
    private DConnect dConnect;
    private DAS das;
    private AttributeTable globalTable;
    private Enumeration attrEnum;
    private Enumeration varEnum;

    public DODSSource() {
        this(DataFactory.dataFactory());
    }

    public DODSSource(DataFactory factory) {
        this.dataFactory = factory;
    }

    public synchronized void open(String spec) throws BadFormException, RemoteException, VisADException {
        try {
            URL url = new URL(spec);
            String path = url.getFile();
            String query = null;
            int i = path.lastIndexOf(63);
            if (i != -1) {
                query = path.substring(i);
                path = path.substring(0, i);
            }
            String suffix = ".dods";
            if (path.toLowerCase().endsWith(suffix)) {
                path = path.substring(0, path.length() - suffix.length());
                spec = new URL(url.getProtocol(), url.getHost(), url.getPort(), query == null ? path : path + "?" + query).toString();
            }
            this.dConnect = new DConnect(spec);
            this.das = this.dConnect.getDAS();
            this.globalTable = this.das.getAttributeTable("NC_GLOBAL");
            if (this.globalTable == null) {
                this.globalTable = this.das.getAttributeTable("nc_global");
            }
            if (this.globalTable != null) {
                this.attrEnum = this.globalTable.getNames();
            } else {
                this.attrEnum = null;
                this.varEnum = this.dConnect.getData(null).getVariables();
            }
        }
        catch (MalformedURLException e) {
            throw new BadFormException(e.getMessage());
        }
        catch (FileNotFoundException e) {
            throw new BadFormException(e.getMessage());
        }
        catch (ParseException e) {
            throw new BadFormException(e.getMessage());
        }
        catch (DODSException e) {
            throw new BadFormException(e.getMessage());
        }
        catch (IOException e) {
            throw new BadFormException(e.getMessage());
        }
    }

    public synchronized DataImpl readData() throws VisADException, RemoteException {
        DataImpl data;
        if (this.attrEnum != null) {
            if (this.attrEnum.hasMoreElements()) {
                String name = (String)this.attrEnum.nextElement();
                data = this.dataFactory.data(name, this.globalTable.getAttribute(name), true);
            } else {
                this.attrEnum = null;
                try {
                    this.varEnum = this.dConnect.getData(null).getVariables();
                }
                catch (DODSException e) {
                    throw new RemoteException(this.getClass().getName() + ".readData(): " + "Couldn't get DDS of DODS dataset: " + e);
                }
                catch (ParseException e) {
                    throw new RemoteException(this.getClass().getName() + ".readData(): " + "Couldn't get DDS of DODS dataset: " + e);
                }
                catch (IOException e) {
                    throw new RemoteException(this.getClass().getName() + ".readData(): " + "Couldn't get DDS of DODS dataset: " + e);
                }
                data = this.readData();
            }
        } else if (this.varEnum != null) {
            if (this.varEnum.hasMoreElements()) {
                data = this.dataFactory.data((BaseType)this.varEnum.nextElement(), this.das, true);
            } else {
                data = null;
                this.varEnum = null;
                this.dConnect = null;
                this.das = null;
                this.globalTable = null;
            }
        } else {
            data = null;
        }
        return data;
    }

    protected synchronized DataImpl readAttribute(String name) throws BadFormException, VisADException, RemoteException {
        return this.dataFactory.data(name, this.globalTable.getAttribute(name), true);
    }

    protected synchronized DataImpl readVariable() throws BadFormException, VisADException, RemoteException {
        DataImpl data;
        if (this.varEnum == null) {
            data = null;
        } else if (!this.varEnum.hasMoreElements()) {
            this.varEnum = null;
            data = null;
        } else {
            data = this.dataFactory.data((BaseType)this.varEnum.nextElement(), this.das, true);
        }
        return data;
    }
}

