/*
 * Decompiled with CFR 0.152.
 */
package visad.data.amanda;

import java.awt.Component;
import java.rmi.RemoteException;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import visad.ControlEvent;
import visad.ControlListener;
import visad.DataReferenceImpl;
import visad.FieldImpl;
import visad.PlotText;
import visad.ScalarMap;
import visad.ScalarMapControlEvent;
import visad.ScalarMapEvent;
import visad.ScalarMapListener;
import visad.ValueControl;
import visad.VisADException;
import visad.data.amanda.BaseTrack;
import visad.data.amanda.Event;
import visad.util.VisADSlider;

public class TrackWidget
extends JPanel
implements ControlListener,
ScalarMapListener {
    private ScalarMap map;
    private DataReferenceImpl ref;
    private Event event;
    private int trackIndex;
    private JLabel lengthLabel;
    private JLabel energyLabel;

    public TrackWidget(ScalarMap map, DataReferenceImpl ref) throws RemoteException, VisADException {
        ValueControl ctl = (ValueControl)((Object)map.getControl());
        ctl.addControlListener(this);
        this.map = map;
        this.ref = ref;
        this.event = null;
        this.trackIndex = (int)ctl.getValue();
        this.setLayout(new BoxLayout(this, 1));
        Component labels = this.buildLabels();
        VisADSlider trackSlider = new VisADSlider(map, true, true);
        trackSlider.hardcodeSizePercent(110);
        this.add(trackSlider);
        this.add(labels);
    }

    public Component buildLabels() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        this.lengthLabel = new JLabel("WWWWWW.WWWW");
        this.lengthLabel.setMinimumSize(this.lengthLabel.getSize());
        this.energyLabel = new JLabel("WWWWWW.WWWW");
        this.energyLabel.setMinimumSize(this.energyLabel.getSize());
        panel.add(Box.createHorizontalGlue());
        panel.add(new JLabel("Length: "));
        panel.add(this.lengthLabel);
        panel.add(Box.createHorizontalGlue());
        panel.add(new JLabel("  Energy: "));
        panel.add(this.energyLabel);
        panel.add(Box.createHorizontalGlue());
        return panel;
    }

    private void changeControl(ValueControl ctl) {
        if (this.event == null) {
            this.trackChanged(null);
        } else {
            this.trackIndex = (int)ctl.getValue();
            this.trackChanged(this.event.getTrack(this.trackIndex));
        }
    }

    public void controlChanged(ControlEvent evt) {
        this.changeControl((ValueControl)((Object)evt.getControl()));
    }

    public void controlChanged(ScalarMapControlEvent evt) {
        this.changeControl((ValueControl)((Object)evt.getControl()));
    }

    private static final String floatString(float val) {
        if (val == Float.POSITIVE_INFINITY) {
            return "inf";
        }
        if (val == Float.NEGATIVE_INFINITY) {
            return "-inf";
        }
        if (val == Float.NaN) {
            return "?";
        }
        return PlotText.shortString(val);
    }

    public void mapChanged(ScalarMapEvent evt) {
        System.err.println(evt);
    }

    public void setEvent(Event evt) throws RemoteException, VisADException {
        this.event = evt;
        if (this.event == null) {
            this.trackChanged(null);
        } else {
            this.map.setRange(0.0, this.event.getNumberOfTracks());
            this.trackChanged(this.event.getTrack(this.trackIndex));
        }
    }

    private void trackChanged(BaseTrack track) {
        FieldImpl trackSeq;
        if (track == null) {
            this.lengthLabel.setText("");
            this.energyLabel.setText("");
            trackSeq = BaseTrack.missing;
        } else {
            this.lengthLabel.setText(TrackWidget.floatString(track.getLength()));
            this.energyLabel.setText(TrackWidget.floatString(track.getEnergy()));
            trackSeq = this.event.makeTrackSequence(this.trackIndex);
        }
        try {
            this.ref.setData(trackSeq);
        }
        catch (RemoteException re) {
            re.printStackTrace();
        }
        catch (VisADException ve) {
            ve.printStackTrace();
        }
        this.invalidate();
    }
}

