/*
 * Decompiled with CFR 0.152.
 */
package visad.data.amanda;

import java.awt.Dimension;
import java.rmi.RemoteException;
import javax.swing.JPanel;
import visad.DataReferenceImpl;
import visad.Display;
import visad.GraphicsModeControl;
import visad.Gridded2DSet;
import visad.MathType;
import visad.RealTupleType;
import visad.RealType;
import visad.ScalarMap;
import visad.VisADException;
import visad.data.amanda.Event;
import visad.data.amanda.F2000Util;
import visad.data.amanda.Hit;
import visad.java2d.DisplayImplJ2D;

public class HistogramWidget
extends JPanel {
    private static final RealType countType = RealType.getRealType("count");
    private static RealTupleType histoType;
    private DisplayImplJ2D dpy = new DisplayImplJ2D("histogram");
    private DataReferenceImpl ref;
    private ScalarMap xMap = new ScalarMap(countType, Display.XAxis);
    private ScalarMap yMap = new ScalarMap(Hit.leadingEdgeTimeType, Display.YAxis);
    private ScalarMap cMap;

    public HistogramWidget() throws RemoteException, VisADException {
        this.dpy.addMap(this.xMap);
        this.dpy.addMap(this.yMap);
        this.cMap = new ScalarMap(Hit.leadingEdgeTimeType, Display.RGB);
        this.dpy.addMap(this.cMap);
        F2000Util.invertColorTable(this.cMap);
        GraphicsModeControl gmc2 = this.dpy.getGraphicsModeControl();
        gmc2.setScaleEnable(true);
        this.ref = new DataReferenceImpl("histogram");
        this.dpy.addReference(this.ref);
        JPanel dpyPanel = (JPanel)this.dpy.getComponent();
        Dimension dim = new Dimension(400, 400);
        dpyPanel.setPreferredSize(dim);
        dpyPanel.setMinimumSize(dim);
        this.add(dpyPanel);
    }

    public void setEvent(Event evt) throws RemoteException, VisADException {
        float[][] histoData = evt.makeHistogram(this.xMap, this.yMap, this.cMap);
        Gridded2DSet set = new Gridded2DSet((MathType)histoType, histoData, histoData[0].length);
        this.ref.setData(set);
    }

    static {
        try {
            histoType = new RealTupleType(Hit.leadingEdgeTimeType, countType);
        }
        catch (VisADException ve) {
            System.err.println("Couldn't create histogram MathType");
            ve.printStackTrace();
            histoType = null;
        }
    }
}

