/*
 * Decompiled with CFR 0.152.
 */
package visad.data.amanda;

import java.io.PrintStream;
import java.rmi.RemoteException;
import visad.Data;
import visad.FieldImpl;
import visad.MathType;
import visad.RealType;
import visad.ScalarMap;
import visad.TupleType;
import visad.VisADException;
import visad.data.amanda.BaseTrack;
import visad.data.amanda.FitTrack;
import visad.data.amanda.Hit;
import visad.data.amanda.Hits;
import visad.data.amanda.MCTrack;
import visad.data.amanda.Tracks;

public class Event {
    public static final RealType indexType = RealType.getRealType("Event_Index");
    public static TupleType tupleType;
    public static Data missing;
    private int number;
    private int run;
    private int year;
    private int day;
    private double time;
    private double timeShift;
    private Hits hits;
    private Tracks tracks;

    Event(int number, int run, int year, int day, double time, double timeShift) {
        this.number = number;
        this.run = run;
        this.year = year;
        this.day = day;
        this.time = time;
        this.timeShift = timeShift;
        this.hits = new Hits();
        this.tracks = new Tracks();
    }

    final void add(Hit hit) {
        this.hits.add(hit);
    }

    final void add(FitTrack track) {
        this.tracks.add(track);
    }

    final void add(MCTrack track) {
        this.tracks.add(track);
    }

    final void dump(PrintStream out) {
        out.println(this);
        this.hits.dump(out);
        this.tracks.dump(out);
    }

    public final int getDay() {
        return this.day;
    }

    public final Hit getHit(int idx) {
        return this.hits.get(idx);
    }

    public final int getNumber() {
        return this.number;
    }

    public final int getNumberOfHits() {
        return this.hits.size();
    }

    public final int getNumberOfTracks() {
        return this.tracks.size();
    }

    public final int getRun() {
        return this.run;
    }

    public final double getTime() {
        return this.time;
    }

    public final double getTimeShift() {
        return this.timeShift;
    }

    public final BaseTrack getTrack(int idx) {
        return this.tracks.get(idx);
    }

    public final int getYear() {
        return this.year;
    }

    public final float[][] makeHistogram(ScalarMap xMap, ScalarMap yMap, ScalarMap cMap) {
        float[] timeSteps = this.hits.getTimeSteps();
        int[] bin = new int[timeSteps.length - 1];
        int i = 0;
        while (i < bin.length) {
            bin[i] = 0;
            ++i;
        }
        int hitsLen = this.hits.size();
        int i2 = 0;
        while (i2 < hitsLen) {
            float time = this.hits.get(i2).getLeadingEdgeTime();
            boolean found = false;
            int j = 0;
            while (!found && j < bin.length) {
                if (time < timeSteps[j]) {
                    int n = j;
                    bin[n] = bin[n] + 1;
                    found = true;
                }
                ++j;
            }
            if (!found) {
                int n = bin.length - 1;
                bin[n] = bin[n] + 1;
            }
            ++i2;
        }
        float binMax = bin[0];
        int i3 = 1;
        while (i3 < bin.length) {
            int val = bin[i3];
            if ((float)val > binMax) {
                binMax = val;
            }
            ++i3;
        }
        float[] x = new float[bin.length * 4];
        float[] y = new float[bin.length * 4];
        int idx = 0;
        int i4 = 0;
        while (i4 < bin.length) {
            x[idx] = timeSteps[i4];
            y[idx] = 0.0f;
            x[++idx] = timeSteps[i4];
            y[idx] = bin[i4];
            x[++idx] = timeSteps[i4 + 1];
            y[idx] = bin[i4];
            x[++idx] = timeSteps[i4 + 1];
            y[idx] = 0.0f;
            ++idx;
            ++i4;
        }
        try {
            xMap.setRange(0.0, binMax);
            yMap.setRange(timeSteps[0], timeSteps[timeSteps.length - 1]);
            cMap.setRange(timeSteps[0], timeSteps[timeSteps.length - 1]);
        }
        catch (RemoteException re) {
            System.err.println("Couldn't set histogram ScalarMap ranges");
            re.printStackTrace();
        }
        catch (VisADException ve) {
            System.err.println("Couldn't set histogram ScalarMap ranges");
            ve.printStackTrace();
        }
        return new float[][]{x, y};
    }

    public final FieldImpl makeHitSequence() {
        return this.hits.makeTimeSequence();
    }

    public final FieldImpl makeTrackSequence(int idx) {
        return this.tracks.get(idx).makeTimeSequence(this.hits.getTimeSteps());
    }

    public String toString() {
        return "Event#" + this.number + "[Y" + this.year + "D" + this.day + " H" + this.hits + " T" + this.tracks + "]";
    }

    static {
        missing = Hits.missing;
        try {
            tupleType = new TupleType(new MathType[]{Tracks.functionType, Hits.functionType});
        }
        catch (VisADException ve) {
            ve.printStackTrace();
            tupleType = null;
        }
    }
}

