/*
 * Decompiled with CFR 0.152.
 */
package visad.data;

import java.io.IOException;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Vector;
import visad.Data;
import visad.DataImpl;
import visad.VisADException;
import visad.data.BadFormException;
import visad.data.FormNode;

public class FormFamily
extends FormNode {
    protected Vector forms = new Vector();

    public FormFamily(String name) {
        super(name);
    }

    public void save(String id, Data data, boolean replace) throws BadFormException, RemoteException, IOException, VisADException {
        Enumeration e = this.forms.elements();
        while (e.hasMoreElements()) {
            try {
                ((FormNode)e.nextElement()).save(id, data, replace);
            }
            catch (BadFormException xcpt) {
                continue;
            }
            return;
        }
        throw new BadFormException("Data object not compatible with \"" + this.getName() + "\" data family");
    }

    public void add(String id, Data data, boolean replace) throws BadFormException {
        Enumeration e = this.forms.elements();
        while (e.hasMoreElements()) {
            try {
                ((FormNode)e.nextElement()).add(id, data, replace);
            }
            catch (BadFormException xcpt) {
                continue;
            }
            return;
        }
        throw new BadFormException("Data object not compatible with \"" + this.getName() + "\" data family");
    }

    public DataImpl open(String id) throws BadFormException, IOException, VisADException {
        Enumeration e = this.forms.elements();
        while (e.hasMoreElements()) {
            try {
                return ((FormNode)e.nextElement()).open(id);
            }
            catch (BadFormException badFormException) {
                // empty catch block
            }
        }
        throw new BadFormException("Data object \"" + id + "\" not compatible with \"" + this.getName() + "\" data family");
    }

    public DataImpl open(URL url) throws BadFormException, IOException, VisADException {
        Enumeration e = this.forms.elements();
        while (e.hasMoreElements()) {
            try {
                return ((FormNode)e.nextElement()).open(url);
            }
            catch (BadFormException badFormException) {
                // empty catch block
            }
        }
        throw new BadFormException("Data object \"" + url + "\" not compatible with \"" + this.getName() + "\" data family");
    }

    public FormNode getForms(Data data) throws RemoteException, VisADException, IOException {
        FormFamily family = new FormFamily(this.getName());
        Enumeration e = this.forms.elements();
        while (e.hasMoreElements()) {
            FormNode node = ((FormNode)e.nextElement()).getForms(data);
            if (node == null) continue;
            family.addFormNode(node);
        }
        return family.forms.size() == 0 ? null : family;
    }

    public FormFamily addFormNode(FormNode node) {
        this.forms.addElement(node);
        return this;
    }
}

