/*
 * Decompiled with CFR 0.152.
 */
package visad.collab;

import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import visad.Control;
import visad.RemoteDisplay;
import visad.RemoteVisADException;
import visad.collab.ControlMonitorEvent;
import visad.collab.MonitorCallback;
import visad.collab.MonitorEvent;
import visad.collab.RemoteEventProvider;
import visad.collab.RemoteEventProviderImpl;
import visad.util.ThreadPool;

class MonitorSyncer
implements Runnable {
    private String Name;
    private boolean dead = false;
    private Object cacheLock = new Object();
    private Thread thisThread = null;
    private ArrayList current = new ArrayList();
    private ArrayList diverted = null;
    private HashMap eventCache = null;
    private RemoteDisplay rmtDpy;
    private MonitorCallback callback;
    private int id;
    private RemoteEventProvider provider;
    private static transient ThreadPool callbackPool = null;
    private static Object callbackPoolLock = new Object();

    public MonitorSyncer(String name, MonitorCallback callback, int id) throws RemoteException {
        this.Name = name + ":MonL";
        this.eventCache = new HashMap();
        this.rmtDpy = null;
        this.callback = callback;
        this.id = id;
        this.provider = new RemoteEventProviderImpl(this);
    }

    public MonitorSyncer(String name, RemoteDisplay rmtDpy, int id) throws RemoteException {
        this.Name = name + ":MonL";
        this.eventCache = new HashMap();
        this.rmtDpy = rmtDpy;
        this.callback = rmtDpy.getRemoteDisplaySync();
        this.id = id;
        this.provider = new RemoteEventProviderImpl(this);
    }

    public void addEvent(MonitorEvent evt) {
        String key = evt.getKey();
        Object object = this.cacheLock;
        synchronized (object) {
            MonitorEvent oldEvt = this.eventCache.put(key, evt);
            if (this.thisThread != null) {
                if (this.diverted == null) {
                    this.diverted = new ArrayList();
                }
                this.diverted.add(key);
            } else {
                this.current.add(key);
                this.thisThread = new Thread(this);
                this.thisThread.start();
            }
        }
    }

    public MonitorEvent getEvent(Object key) {
        MonitorEvent evt;
        Object object = this.cacheLock;
        synchronized (object) {
            evt = (MonitorEvent)this.eventCache.remove(key);
        }
        if (evt != null) {
            evt.setOriginator(this.id);
        }
        return evt;
    }

    public int getID() {
        return this.id;
    }

    public MonitorCallback getListener() {
        return this.callback;
    }

    public String getName() {
        return this.Name;
    }

    public boolean hasControlEventQueued(Control ctl) {
        if (ctl == null) {
            return false;
        }
        return this.eventCache.containsKey(ControlMonitorEvent.getControlKey(ctl));
    }

    public boolean isEmpty() {
        return this.eventCache.isEmpty();
    }

    public boolean isDead() {
        return this.dead;
    }

    public boolean isMonitored(RemoteDisplay rmtDpy) {
        return this.rmtDpy.equals(rmtDpy);
    }

    public void run() {
        Object object;
        boolean done = false;
        try {
            int attempts = 0;
            while (!done) {
                try {
                    this.sendEventKeys(this.current);
                    done = true;
                }
                catch (RemoteException re) {
                    if (attempts++ < 5) {
                        try {
                            Thread.sleep(500L);
                        }
                        catch (InterruptedException ie) {}
                    }
                    this.dead = true;
                    break;
                }
                catch (RemoteVisADException rve) {
                    rve.printStackTrace();
                    done = true;
                }
                if (!done) continue;
                Object object2 = this.cacheLock;
                synchronized (object2) {
                    if (!this.undivertEvents()) {
                        break;
                    }
                    done = false;
                }
            }
            Object var7_9 = null;
            object = this.cacheLock;
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            Object object3 = this.cacheLock;
            synchronized (object3) {
                this.thisThread = null;
            }
            throw throwable;
        }
        synchronized (object) {
            this.thisThread = null;
        }
    }

    private void sendEventKeys(ArrayList list) throws RemoteException, RemoteVisADException {
        while (list.size() > 0) {
            String key = (String)list.remove(0);
            this.callback.eventReady(this.provider, key);
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("MonitorSyncer[");
        buf.append(this.Name);
        buf.append("=#");
        buf.append(this.id);
        buf.append(']');
        return buf.toString();
    }

    private boolean undivertEvents() {
        boolean undivert;
        Object object = this.cacheLock;
        synchronized (object) {
            boolean bl = undivert = this.diverted != null;
            if (undivert) {
                this.current = this.diverted;
                this.diverted = null;
            }
        }
        return undivert;
    }

    class ControlEventKey {
        private Control control;
        private Class cclass;
        private int instance;

        ControlEventKey(Control ctl) {
            this.control = ctl;
            this.cclass = ctl.getClass();
            this.instance = ctl.getInstanceNumber();
        }

        public boolean equals(ControlEventKey key) {
            return this.instance == key.instance && this.cclass.equals(key.cclass);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ControlEventKey)) {
                return false;
            }
            return this.equals((ControlEventKey)obj);
        }

        public boolean equals(Control ctl) {
            return this.cclass.equals(ctl.getClass());
        }

        public int hashCode() {
            return this.cclass.hashCode() + this.instance;
        }

        public String toString() {
            StringBuffer buf = new StringBuffer(this.control.toString());
            if (buf.length() > 48) {
                buf.setLength(0);
            }
            buf.insert(0, ':');
            buf.insert(0, this.instance);
            buf.insert(0, '#');
            buf.insert(0, this.cclass.getName());
            return buf.toString();
        }
    }
}

