/*
 * Decompiled with CFR 0.152.
 */
package visad.collab;

import java.io.Serializable;

public abstract class MonitorEvent
implements Serializable {
    public static final int MAP_ADDED = 1;
    public static final int MAP_CHANGED = 2;
    public static final int MAPS_CLEARED = 3;
    public static final int REFERENCE_ADDED = 10;
    public static final int REFERENCE_REMOVED = 11;
    public static final int CONTROL_INIT_REQUESTED = 20;
    public static final int CONTROL_CHANGED = 21;
    public static final int MESSAGE_SENT = 22;
    private static int nextSeqNum = 0;
    protected int seqNum = nextSeqNum++;
    protected int type;
    private int originator;

    public MonitorEvent(int type, int originator) {
        this.type = type;
        this.originator = originator;
    }

    public int getType() {
        return this.type;
    }

    public abstract String getKey();

    public int getOriginator() {
        return this.originator;
    }

    public int getSequenceNumber() {
        return this.seqNum;
    }

    public static String getTypeName(int type) {
        switch (type) {
            case 1: {
                return "MAP_ADDED";
            }
            case 2: {
                return "MAP_CHANGED";
            }
            case 3: {
                return "MAPS_CLEARED";
            }
            case 10: {
                return "REFERENCE_ADDED";
            }
            case 11: {
                return "REFERENCE_REMOVED";
            }
            case 20: {
                return "CONTROL_INIT_REQUESTED";
            }
            case 21: {
                return "CONTROL_CHANGED";
            }
        }
        return "Unknown MonitorEvent Type #" + type;
    }

    public String getTypeName() {
        return MonitorEvent.getTypeName(this.type);
    }

    public void setOriginator(int id) {
        this.originator = id;
    }

    public abstract Object clone();

    public String toString() {
        StringBuffer buf = new StringBuffer("MonitorEvent[");
        buf.append('#');
        buf.append(this.getSequenceNumber());
        buf.append(' ');
        buf.append(this.getTypeName());
        if (this.originator == -1) {
            buf.append(" Lcl");
        } else {
            buf.append(" Rmt ");
            buf.append(this.originator);
        }
        buf.append(']');
        return buf.toString();
    }
}

