/*
 * Decompiled with CFR 0.152.
 */
package visad.collab;

import visad.ConstantMap;
import visad.ScalarMap;
import visad.VisADException;
import visad.collab.MonitorEvent;

public class MapMonitorEvent
extends MonitorEvent {
    private ScalarMap map;

    public MapMonitorEvent(int type, ScalarMap map) throws VisADException {
        this(type, -1, map);
    }

    public MapMonitorEvent(int type, int originator, ScalarMap map) throws VisADException {
        super(type, originator);
        if (type != 1 && type != 2 && type != 3) {
            throw new VisADException("Bad type " + type);
        }
        if (map == null && type != 3) {
            throw new VisADException("Null map");
        }
        this.map = map;
    }

    public String getKey() {
        String key;
        if (this.type == 3) {
            key = "MAPS_CLEARED";
        } else {
            key = this.map.toString();
            switch (this.type) {
                case 1: {
                    key = "ADD " + key;
                    break;
                }
                case 2: {
                    key = "CHG " + key;
                    break;
                }
                default: {
                    System.err.println("MapMonitorEvent type " + this.type + " not handled by getKey()");
                }
            }
        }
        return key;
    }

    public ScalarMap getMap() {
        return this.map;
    }

    public boolean equals(Object o) {
        if (!(o instanceof MapMonitorEvent)) {
            return false;
        }
        MapMonitorEvent evt = (MapMonitorEvent)o;
        if (this.getType() != evt.getType()) {
            return false;
        }
        if (this.map == null) {
            if (evt.map != null) {
                return false;
            }
        } else {
            if (evt.map == null) {
                return false;
            }
            if (!this.map.equals(evt.map)) {
                return false;
            }
        }
        return true;
    }

    public Object clone() {
        MapMonitorEvent evt;
        try {
            evt = new MapMonitorEvent(this.getType(), this.getOriginator(), this.map == null ? null : (ScalarMap)this.map.clone());
            evt.seqNum = this.seqNum;
        }
        catch (VisADException e) {
            evt = null;
        }
        return evt;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("MapMonitorEvent[");
        buf.append('#');
        buf.append(this.getSequenceNumber());
        buf.append(' ');
        buf.append(this.getTypeName());
        int orig = this.getOriginator();
        if (orig == -1) {
            buf.append(" Lcl");
        } else {
            buf.append(" Rmt ");
            buf.append(orig);
        }
        if (this.map == null) {
            buf.append(" <null>");
        } else if (this.map instanceof ConstantMap) {
            buf.append(' ');
            buf.append(((ConstantMap)this.map).getConstant());
            buf.append(" -> ");
            buf.append(this.map.getDisplayScalar());
        } else {
            buf.append(' ');
            buf.append(this.map.getScalar());
            buf.append(" -> ");
            buf.append(this.map.getDisplayScalar());
        }
        buf.append(']');
        return buf.toString();
    }
}

