/*
 * Decompiled with CFR 0.152.
 */
package visad.collab;

import java.rmi.RemoteException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.ListIterator;
import java.util.Vector;
import visad.AnimationControl;
import visad.Control;
import visad.ControlEvent;
import visad.DataDisplayLink;
import visad.DataReference;
import visad.DataReferenceImpl;
import visad.DisplayEvent;
import visad.DisplayImpl;
import visad.DisplayMapEvent;
import visad.DisplayReferenceEvent;
import visad.MessageEvent;
import visad.RemoteDisplay;
import visad.RemoteDisplayImpl;
import visad.RemoteReferenceLinkImpl;
import visad.RemoteVisADException;
import visad.ScalarMap;
import visad.ScalarMapControlEvent;
import visad.ScalarMapEvent;
import visad.VisADException;
import visad.collab.ControlMonitorEvent;
import visad.collab.DisplayMonitor;
import visad.collab.DisplaySync;
import visad.collab.DisplaySyncImpl;
import visad.collab.MapMonitorEvent;
import visad.collab.MessageMonitorEvent;
import visad.collab.MonitorCallback;
import visad.collab.MonitorEvent;
import visad.collab.MonitorSyncer;
import visad.collab.ReferenceMonitorEvent;
import visad.collab.RemoteDisplayMonitor;
import visad.collab.RemoteDisplaySyncImpl;

public class DisplayMonitorImpl
implements DisplayMonitor {
    private int nextListenerID = 1;
    private String Name;
    private DisplayImpl myDisplay;
    private ArrayList listeners;
    private DisplaySync sync;
    private boolean cluster = false;

    public DisplayMonitorImpl(DisplayImpl dpy) {
        this(dpy, false);
    }

    public DisplayMonitorImpl(DisplayImpl dpy, boolean cl) {
        this.Name = dpy.getName() + ":Mon";
        dpy.addDisplayListener(this);
        dpy.addMessageListener(this);
        this.myDisplay = dpy;
        this.listeners = new ArrayList();
        this.cluster = cl;
    }

    public void addListener(MonitorCallback listener, int id) throws RemoteException, VisADException {
        MonitorSyncer ms = new MonitorSyncer(this.myDisplay.getName(), listener, id);
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            this.listeners.add(ms);
        }
    }

    public void addListener(RemoteDisplay rmtDpy, int id) throws RemoteException, VisADException {
        MonitorSyncer ms = new MonitorSyncer(this.myDisplay.getName(), rmtDpy, id);
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            this.listeners.add(ms);
        }
    }

    public void addRemoteListener(RemoteDisplay rd) throws RemoteException, RemoteVisADException {
        RemoteDisplayMonitor rdm = rd.getRemoteDisplayMonitor();
        int id = this.negotiateUniqueID(rdm);
        DisplaySyncImpl dsi = (DisplaySyncImpl)this.myDisplay.getDisplaySync();
        RemoteDisplaySyncImpl wrap = new RemoteDisplaySyncImpl(dsi);
        try {
            rdm.addListener(new RemoteDisplayImpl(this.myDisplay), id);
        }
        catch (Exception e) {
            throw new RemoteVisADException("Couldn't make this object a listener for the remote display");
        }
        boolean unwind = false;
        try {
            if (!this.cluster) {
                this.addListener(rd, id);
            }
        }
        catch (Exception e) {
            unwind = true;
        }
        if (unwind) {
            this.removeListener(wrap);
            throw new RemoteVisADException("Couldn't add listener for the remote display to this object");
        }
    }

    public int checkID(int id) {
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            boolean failed = true;
            block3: while (failed) {
                failed = false;
                ListIterator iter = ((AbstractList)this.listeners).listIterator();
                while (iter.hasNext()) {
                    MonitorSyncer li = (MonitorSyncer)iter.next();
                    if (id != 0 && li.getID() != id) continue;
                    id = this.getNextListenerID();
                    failed = true;
                    continue block3;
                }
            }
        }
        return id;
    }

    public void controlChanged(ControlEvent evt) {
        ControlMonitorEvent ctlEvt;
        if (this.myDisplay.hasSlaves()) {
            Control control = evt.getControl();
            String msg = control.getSaveString();
            Class<?> c = control.getClass();
            Vector v = this.myDisplay.getControls(c);
            int index = -1;
            int i = 0;
            while (i < v.size()) {
                Control ctrl = (Control)v.elementAt(i);
                if (control == ctrl) {
                    index = i;
                    break;
                }
                ++i;
            }
            String message = c.getName() + "\n" + index + "\n" + msg;
            this.myDisplay.updateSlaves(message);
        }
        if (!this.hasListeners()) {
            return;
        }
        if (evt.getControl() instanceof AnimationControl) {
            return;
        }
        Control ctlClone = (Control)evt.getControl().clone();
        try {
            ctlEvt = new ControlMonitorEvent(21, evt.getRemoteId(), ctlClone);
        }
        catch (VisADException ve) {
            ve.printStackTrace();
            ctlEvt = null;
        }
        if (ctlEvt != null) {
            this.notifyListeners(ctlEvt);
        }
    }

    public void controlChanged(ScalarMapControlEvent evt) {
        if (!this.hasListeners()) {
            return;
        }
        int id = evt.getId();
        if (id == 4 || id == 5) {
            evt.getControl().removeControlListener(this);
        }
        if (id == 5 || id == 3) {
            Control ctl = evt.getScalarMap().getControl();
            this.controlChanged(new ControlEvent(ctl, evt.getRemoteId()));
            ctl.addControlListener(this);
        }
    }

    public void destroy() {
        this.sync = null;
        this.myDisplay.removeDisplayListener(this);
    }

    public void displayChanged(DisplayEvent evt) {
        if (!this.hasListeners()) {
            return;
        }
        switch (evt.getId()) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
            case 11: {
                MapMonitorEvent mapEvt;
                ScalarMap map = (ScalarMap)((DisplayMapEvent)evt).getMap().clone();
                try {
                    mapEvt = new MapMonitorEvent(1, evt.getRemoteId(), map);
                }
                catch (VisADException ve) {
                    ve.printStackTrace();
                    mapEvt = null;
                }
                if (mapEvt == null) break;
                this.notifyListeners(mapEvt);
                break;
            }
            case 12: {
                MapMonitorEvent mapEvt;
                boolean sendClear;
                try {
                    sendClear = this.sync.isLocalClear();
                }
                catch (RemoteException re) {
                    sendClear = false;
                }
                if (!sendClear) break;
                try {
                    mapEvt = new MapMonitorEvent(3, evt.getRemoteId(), null);
                }
                catch (VisADException ve) {
                    ve.printStackTrace();
                    mapEvt = null;
                }
                if (mapEvt == null) break;
                this.notifyListeners(mapEvt);
                break;
            }
            case 13: {
                ReferenceMonitorEvent refEvt;
                RemoteReferenceLinkImpl rrl;
                DataReference linkRef;
                DisplayReferenceEvent dre = (DisplayReferenceEvent)evt;
                DataDisplayLink link = dre.getDataDisplayLink();
                try {
                    linkRef = link.getDataReference();
                }
                catch (Exception e) {
                    linkRef = null;
                }
                if (linkRef == null || !(linkRef instanceof DataReferenceImpl)) break;
                try {
                    rrl = new RemoteReferenceLinkImpl(link);
                }
                catch (RemoteException re) {
                    re.printStackTrace();
                    rrl = null;
                }
                if (rrl == null) break;
                try {
                    refEvt = new ReferenceMonitorEvent(10, evt.getRemoteId(), rrl);
                }
                catch (VisADException ve) {
                    ve.printStackTrace();
                    refEvt = null;
                }
                if (refEvt == null) break;
                this.notifyListeners(refEvt);
                break;
            }
            case 15: {
                break;
            }
            default: {
                System.err.println("DisplayMonitorImpl.displayChanged: " + this.Name + " got " + evt.getClass().getName() + " " + evt + "=>" + evt.getDisplay());
                System.exit(1);
            }
        }
    }

    public int getConnectionID(RemoteDisplay rmtDpy) {
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            ListIterator iter = ((AbstractList)this.listeners).listIterator();
            while (iter.hasNext()) {
                MonitorSyncer li = (MonitorSyncer)iter.next();
                if (!li.isMonitored(rmtDpy)) continue;
                int n = li.getID();
                return n;
            }
        }
        return 0;
    }

    private int getNextListenerID() {
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            if (this.nextListenerID == 0) {
                ++this.nextListenerID;
            }
            int n = this.nextListenerID++;
            return n;
        }
    }

    public boolean hasEventQueued(Control ctl) {
        return this.hasEventQueued(0, ctl, true);
    }

    public boolean hasEventQueued(int listenerID, Control ctl) {
        return this.hasEventQueued(listenerID, ctl, false);
    }

    private boolean hasEventQueued(int listenerID, Control ctl, boolean anyListener) {
        boolean result = false;
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            ListIterator iter = ((AbstractList)this.listeners).listIterator();
            while (iter.hasNext()) {
                MonitorSyncer li = (MonitorSyncer)iter.next();
                if (!anyListener && listenerID != li.getID()) continue;
                result = li.hasControlEventQueued(ctl);
                if (!anyListener || result) break;
            }
        }
        return result;
    }

    public boolean isEmpty() {
        boolean result = true;
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            ListIterator iter = ((AbstractList)this.listeners).listIterator();
            while (iter.hasNext()) {
                MonitorSyncer li = (MonitorSyncer)iter.next();
                if (li.isEmpty()) continue;
                result = false;
            }
        }
        return result;
    }

    private boolean hasListeners() {
        return this.listeners.size() > 0;
    }

    public void mapChanged(ScalarMapEvent evt) {
        MapMonitorEvent mapEvt;
        if (!this.hasListeners()) {
            return;
        }
        if (evt.getId() == 1 && this.cluster) {
            return;
        }
        ScalarMap mapClone = (ScalarMap)evt.getScalarMap().clone();
        try {
            mapEvt = new MapMonitorEvent(2, evt.getRemoteId(), mapClone);
        }
        catch (VisADException ve) {
            ve.printStackTrace();
            mapEvt = null;
        }
        if (mapEvt != null) {
            this.notifyListeners(mapEvt);
        }
    }

    private int negotiateUniqueID(RemoteDisplayMonitor rdm) throws RemoteException, RemoteVisADException {
        int id;
        int rmtID = this.getNextListenerID();
        int round = 0;
        do {
            if ((rmtID = rdm.checkID(id = rmtID)) == id) continue;
            id = this.checkID(rmtID);
        } while (id != rmtID && ++round < 20);
        if (round >= 20) {
            throw new RemoteVisADException("ID negotiation failed");
        }
        return id;
    }

    public void notifyListeners(MonitorEvent evt) {
        int evtID = evt.getOriginator();
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            ListIterator iter = ((AbstractList)this.listeners).listIterator();
            while (iter.hasNext()) {
                MonitorSyncer li = (MonitorSyncer)iter.next();
                if (li.isDead()) {
                    this.myDisplay.lostCollabConnection(li.getID());
                    iter.remove();
                    continue;
                }
                if (evtID == li.getID()) continue;
                li.addEvent(evt);
            }
        }
    }

    public void receiveMessage(MessageEvent msg) {
        MessageMonitorEvent msgEvt;
        if (!this.hasListeners()) {
            return;
        }
        try {
            msgEvt = new MessageMonitorEvent(22, msg.getOriginatorId(), msg);
        }
        catch (RemoteException re) {
            re.printStackTrace();
            msgEvt = null;
        }
        catch (VisADException ve) {
            ve.printStackTrace();
            msgEvt = null;
        }
        if (msgEvt != null) {
            this.notifyListeners(msgEvt);
        }
    }

    public void removeListener(MonitorCallback l) {
        if (l != null) {
            ArrayList arrayList = this.listeners;
            synchronized (arrayList) {
                ListIterator iter = ((AbstractList)this.listeners).listIterator();
                while (iter.hasNext()) {
                    MonitorSyncer li = (MonitorSyncer)iter.next();
                    if (!li.getListener().equals(l)) continue;
                    iter.remove();
                    break;
                }
            }
        }
    }

    public void setDisplaySync(DisplaySync sync) {
        this.sync = sync;
    }

    public String toString() {
        return this.Name;
    }
}

