/*
 * Decompiled with CFR 0.152.
 */
package visad.cluster;

import java.awt.Component;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Vector;
import javax.media.j3d.Appearance;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.ColoringAttributes;
import javax.media.j3d.Geometry;
import javax.media.j3d.GeometryArray;
import javax.media.j3d.ImageComponent;
import javax.media.j3d.ImageComponent2D;
import javax.media.j3d.Node;
import javax.media.j3d.OrderedGroup;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Switch;
import javax.media.j3d.Texture;
import javax.media.j3d.Texture2D;
import javax.media.j3d.TextureAttributes;
import javax.media.j3d.TransparencyAttributes;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JPanel;
import visad.AVControl;
import visad.ConstantMap;
import visad.Control;
import visad.Data;
import visad.DataDisplayLink;
import visad.DataShadow;
import visad.Display;
import visad.DisplayException;
import visad.DisplayImpl;
import visad.DisplayRealType;
import visad.GraphicsModeControl;
import visad.RealType;
import visad.ScalarMap;
import visad.Set;
import visad.SetType;
import visad.ShadowType;
import visad.VisADAppearance;
import visad.VisADException;
import visad.VisADGeometryArray;
import visad.VisADGroup;
import visad.VisADSceneGraphObject;
import visad.VisADSwitch;
import visad.cluster.ClientDisplayRendererJ3D;
import visad.cluster.ClusterException;
import visad.cluster.RemoteProxyAgent;
import visad.collab.CollabUtil;
import visad.java3d.AVControlJ3D;
import visad.java3d.DefaultRendererJ3D;
import visad.java3d.DisplayImplJ3D;
import visad.java3d.DisplayRendererJ3D;
import visad.java3d.ProjectionControlJ3D;
import visad.java3d.ShadowTypeJ3D;

public class UserRendererJ3D
extends DefaultRendererJ3D {
    private RemoteProxyAgent agent = null;
    private DisplayImpl display = null;
    private ConstantMap[] cmaps = null;
    private DataDisplayLink link = null;
    private long time_out = 10000L;
    private int[] resolutions = null;

    public UserRendererJ3D() {
        this(null, 10000L);
    }

    public UserRendererJ3D(RemoteProxyAgent a) {
        this(a, 10000L);
    }

    public UserRendererJ3D(RemoteProxyAgent a, long to) {
        this.agent = a;
        this.time_out = to;
    }

    public void setResolutions(int[] rs) throws RemoteException {
        try {
            this.agent.setResolutions(rs);
        }
        catch (RemoteException re) {
            if (CollabUtil.isDisconnectException(re)) {
                this.getDisplay().connectionFailed(this, this.link);
                this.removeLink(this.link);
                return;
            }
            throw re;
        }
    }

    public DataShadow prepareAction(boolean go, boolean initialize, DataShadow shadow) throws VisADException, RemoteException {
        DataDisplayLink[] Links = this.getLinks();
        if (Links != null && Links.length > 0) {
            this.link = Links[0];
            if (this.cmaps == null) {
                this.display = this.getDisplay();
                Vector cvector = this.link.getConstantMaps();
                if (cvector != null && cvector.size() > 0) {
                    int clength = cvector.size();
                    this.cmaps = new ConstantMap[clength];
                    int i = 0;
                    while (i < clength) {
                        this.cmaps[i] = (ConstantMap)cvector.elementAt(i);
                        ++i;
                    }
                }
            }
        }
        Vector map_vector = this.display.getMapVector();
        int n = map_vector.size();
        ScalarMap[] maps = new ScalarMap[n];
        Control[] controls = new Control[n];
        int i = 0;
        while (i < n) {
            maps[i] = (ScalarMap)map_vector.elementAt(i);
            controls[i] = maps[i].getControl();
            ++i;
        }
        Serializable[] responses = this.agent.prepareAction(go, initialize, shadow, this.cmaps, maps, controls, this.display.getName(), this.time_out);
        return super.prepareAction(go, initialize, shadow);
    }

    public BranchGroup doTransform() throws VisADException, RemoteException {
        Serializable[] responses = null;
        try {
            responses = this.agent.doTransform();
        }
        catch (DisplayException e) {
            this.addException(e);
        }
        if (this.link == null) {
            this.addException(new DisplayException("Data is null: UserRendererJ3D.doTransform"));
            responses = null;
        }
        BranchGroup branch = new BranchGroup();
        branch.setCapability(17);
        branch.setCapability(12);
        branch.setCapability(13);
        branch.setCapability(14);
        int n = responses == null ? 0 : responses.length;
        int i = 0;
        while (i < n) {
            if (responses[i] != null) {
                VisADSceneGraphObject vsgo = (VisADSceneGraphObject)responses[i];
                branch.addChild(this.convertSceneGraph(vsgo));
            }
            ++i;
        }
        if (n == 0) {
            ShadowTypeJ3D.ensureNotEmpty(branch, this.display);
        }
        return branch;
    }

    public void setSpatialValues(float[][] spatial_values) {
        super.setSpatialValues(spatial_values);
    }

    public Node convertSceneGraph(VisADSceneGraphObject scene) throws VisADException {
        if (scene instanceof VisADSwitch) {
            VisADSwitch Vswit = (VisADSwitch)scene;
            BranchGroup branch = new BranchGroup();
            branch.setCapability(17);
            branch.setCapability(12);
            branch.setCapability(13);
            branch.setCapability(14);
            Switch swit = new Switch();
            swit.setCapability(17);
            swit.setCapability(18);
            swit.setCapability(17);
            swit.setCapability(12);
            swit.setCapability(13);
            int n = Vswit.numChildren();
            Set set = Vswit.getSet();
            if (set != null) {
                int i = 0;
                while (i < n) {
                    VisADSceneGraphObject vsgo = Vswit.getChild(i);
                    swit.addChild(this.convertSceneGraph(vsgo));
                    ++i;
                }
                RealType real = (RealType)((SetType)set.getType()).getDomain().getComponent(0);
                AVControl control = null;
                Vector mapVector = this.display.getMapVector();
                Enumeration maps = mapVector.elements();
                while (maps.hasMoreElements()) {
                    DisplayRealType dreal;
                    ScalarMap map = (ScalarMap)maps.nextElement();
                    if (!real.equals(map.getScalar()) || !(dreal = map.getDisplayScalar()).equals(Display.Animation) && !dreal.equals(Display.SelectValue)) continue;
                    control = (AVControl)((Object)map.getControl());
                    break;
                }
                if (control == null) {
                    throw new ClusterException("AVControl is null");
                }
                ((AVControlJ3D)control).addPair(swit, set, this);
                ((AVControlJ3D)control).init();
            } else {
                if (Vswit.numChildren() != 3) {
                    throw new ClusterException("VisADSwitch for volume render must have 3 children");
                }
                VisADGroup VbranchX = (VisADGroup)((VisADSwitch)scene).getChild(0);
                VisADGroup VbranchY = (VisADGroup)((VisADSwitch)scene).getChild(1);
                VisADGroup VbranchZ = (VisADGroup)((VisADSwitch)scene).getChild(2);
                int nX = VbranchX.numChildren();
                OrderedGroup branchX = new OrderedGroup();
                branchX.setCapability(12);
                VisADAppearance[] appearanceX = new VisADAppearance[nX];
                int i = 0;
                while (i < nX) {
                    VisADAppearance appearance = (VisADAppearance)VbranchX.getChild(i);
                    branchX.addChild((Node)((Shape3D)this.convertSceneGraph(appearance)));
                    ++i;
                }
                OrderedGroup branchXrev = new OrderedGroup();
                branchXrev.setCapability(12);
                int i2 = nX - 1;
                while (i2 >= 0) {
                    VisADAppearance appearance = (VisADAppearance)VbranchX.getChild(i2);
                    branchXrev.addChild((Node)((Shape3D)this.convertSceneGraph(appearance)));
                    --i2;
                }
                int nY = VbranchY.numChildren();
                OrderedGroup branchY = new OrderedGroup();
                branchY.setCapability(12);
                VisADAppearance[] appearanceY = new VisADAppearance[nY];
                int i3 = 0;
                while (i3 < nY) {
                    VisADAppearance appearance = (VisADAppearance)VbranchY.getChild(i3);
                    branchY.addChild((Node)((Shape3D)this.convertSceneGraph(appearance)));
                    ++i3;
                }
                OrderedGroup branchYrev = new OrderedGroup();
                branchYrev.setCapability(12);
                int i4 = nY - 1;
                while (i4 >= 0) {
                    VisADAppearance appearance = (VisADAppearance)VbranchY.getChild(i4);
                    branchYrev.addChild((Node)((Shape3D)this.convertSceneGraph(appearance)));
                    --i4;
                }
                int nZ = VbranchZ.numChildren();
                OrderedGroup branchZ = new OrderedGroup();
                branchZ.setCapability(12);
                VisADAppearance[] appearanceZ = new VisADAppearance[nZ];
                int i5 = 0;
                while (i5 < nZ) {
                    VisADAppearance appearance = (VisADAppearance)VbranchZ.getChild(i5);
                    branchZ.addChild((Node)((Shape3D)this.convertSceneGraph(appearance)));
                    ++i5;
                }
                OrderedGroup branchZrev = new OrderedGroup();
                branchZrev.setCapability(12);
                int i6 = nZ - 1;
                while (i6 >= 0) {
                    VisADAppearance appearance = (VisADAppearance)VbranchZ.getChild(i6);
                    branchZrev.addChild((Node)((Shape3D)this.convertSceneGraph(appearance)));
                    --i6;
                }
                swit.addChild((Node)branchX);
                swit.addChild((Node)branchY);
                swit.addChild((Node)branchZ);
                swit.addChild((Node)branchXrev);
                swit.addChild((Node)branchYrev);
                swit.addChild((Node)branchZrev);
                ProjectionControlJ3D control = (ProjectionControlJ3D)this.display.getProjectionControl();
                control.addPair(swit, this);
            }
            branch.addChild((Node)swit);
            return branch;
        }
        if (scene instanceof VisADGroup) {
            VisADGroup group = (VisADGroup)scene;
            BranchGroup branch = new BranchGroup();
            branch.setCapability(17);
            branch.setCapability(12);
            branch.setCapability(13);
            branch.setCapability(14);
            int n = group.numChildren();
            int i = 0;
            while (i < n) {
                VisADSceneGraphObject vsgo = group.getChild(i);
                branch.addChild(this.convertSceneGraph(vsgo));
                ++i;
            }
            ShadowTypeJ3D.ensureNotEmpty(branch, this.display);
            return branch;
        }
        if (scene instanceof VisADAppearance) {
            VisADAppearance appearance = (VisADAppearance)scene;
            GraphicsModeControl mode = this.display.getGraphicsModeControl();
            VisADGeometryArray vga = appearance.array;
            GeometryArray array = ((DisplayImplJ3D)this.display).makeGeometry(vga);
            if (array == null) {
                return null;
            }
            BufferedImage image = null;
            if (appearance.image_pixels != null) {
                image = new BufferedImage(appearance.image_width, appearance.image_height, appearance.image_type);
                image.setRGB(0, 0, appearance.image_width, appearance.image_height, appearance.image_pixels, 0, appearance.image_width);
            }
            if (image != null) {
                Appearance appearance_j3d = this.makeTextureAppearance(appearance, mode, array);
                TextureAttributes texture_attributes = new TextureAttributes();
                texture_attributes.setTextureMode(2);
                texture_attributes.setPerspectiveCorrectionMode(1);
                appearance_j3d.setTextureAttributes(texture_attributes);
                int transparencyMode = mode.getTransparencyMode();
                Texture2D texture = new Texture2D(1, 6, appearance.texture_width, appearance.texture_height);
                texture.setCapability(4);
                ImageComponent2D image2d = new ImageComponent2D(2, image);
                image2d.setCapability(2);
                texture.setImage(0, (ImageComponent)image2d);
                if (transparencyMode == 0) {
                    texture.setMinFilter(2);
                    texture.setMagFilter(2);
                } else {
                    texture.setBoundaryModeS(2);
                    texture.setBoundaryModeT(2);
                    texture.setMinFilter(3);
                    texture.setMagFilter(3);
                }
                texture.setEnable(true);
                appearance_j3d.setTexture((Texture)texture);
                appearance_j3d.setCapability(2);
                Shape3D shape = new Shape3D((Geometry)array, appearance_j3d);
                shape.setCapability(14);
                return shape;
            }
            Appearance appearance_j3d = this.makeAppearance(appearance, mode, array);
            Shape3D shape = new Shape3D((Geometry)array, appearance_j3d);
            return shape;
        }
        throw new VisADException("unknown scene " + scene);
    }

    private Appearance makeTextureAppearance(VisADAppearance appearance, GraphicsModeControl mode, GeometryArray array) {
        TransparencyAttributes c_alpha = null;
        if (appearance.alpha == 1.0f) {
            c_alpha = null;
        } else if (appearance.alpha == appearance.alpha) {
            c_alpha = new TransparencyAttributes(2, appearance.alpha);
        } else {
            c_alpha = new TransparencyAttributes();
            c_alpha.setTransparencyMode(2);
        }
        ColoringAttributes c_color = null;
        if (appearance.red == appearance.red && appearance.green == appearance.green && appearance.blue == appearance.blue) {
            c_color = new ColoringAttributes();
            c_color.setColor(appearance.red, appearance.green, appearance.blue);
        }
        return ShadowTypeJ3D.makeAppearance(mode, c_alpha, null, array, false);
    }

    private Appearance makeAppearance(VisADAppearance appearance, GraphicsModeControl mode, GeometryArray array) {
        TransparencyAttributes c_alpha = null;
        c_alpha = appearance.alpha == 1.0f ? new TransparencyAttributes(4, 0.0f) : (appearance.alpha == appearance.alpha ? new TransparencyAttributes(mode.getTransparencyMode(), appearance.alpha) : new TransparencyAttributes(mode.getTransparencyMode(), 0.0f));
        ColoringAttributes c_color = null;
        if (appearance.red == appearance.red && appearance.green == appearance.green && appearance.blue == appearance.blue) {
            c_color = new ColoringAttributes();
            c_color.setColor(appearance.red, appearance.green, appearance.blue);
        }
        return ShadowTypeJ3D.makeAppearance(mode, c_alpha, c_color, array, false);
    }

    public DataShadow computeRanges(Data data, ShadowType type, DataShadow shadow) throws VisADException, RemoteException {
        Vector<Serializable> message = new Vector<Serializable>();
        message.addElement(type);
        if (shadow == null) {
            message.addElement(new Integer(this.getDisplay().getScalarCount()));
        } else {
            message.addElement(shadow);
        }
        Serializable[] responses = this.agent.computeRanges(message);
        DataShadow new_shadow = null;
        int n = responses.length;
        int i = 0;
        while (i < n) {
            if (responses[i] != null) {
                if (new_shadow == null) {
                    new_shadow = (DataShadow)responses[i];
                } else {
                    new_shadow.merge((DataShadow)responses[i]);
                }
            }
            ++i;
        }
        return new_shadow;
    }

    public Object clone() {
        return new UserRendererJ3D(this.agent, this.time_out);
    }

    public static void main(String[] args) throws VisADException, RemoteException {
        DisplayImplJ3D display = new DisplayImplJ3D("display", (DisplayRendererJ3D)new ClientDisplayRendererJ3D());
        JFrame frame = new JFrame("test UserRendererJ3D");
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.setAlignmentY(0.0f);
        panel.setAlignmentX(0.0f);
        frame.getContentPane().add(panel);
        panel.add(display.getComponent());
        ((Component)frame).setSize(500, 500);
        ((Component)frame).setVisible(true);
    }
}

