/*
 * Decompiled with CFR 0.152.
 */
package visad.cluster;

import java.awt.Component;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.rmi.Naming;
import java.rmi.RemoteException;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JPanel;
import visad.DataReferenceImpl;
import visad.Display;
import visad.FieldImpl;
import visad.FlatField;
import visad.FunctionType;
import visad.Linear1DSet;
import visad.Linear2DSet;
import visad.RealTupleType;
import visad.RealType;
import visad.RemoteDataReferenceImpl;
import visad.RemoteDisplayImpl;
import visad.ScalarMap;
import visad.VisADException;
import visad.cluster.ClientDisplayRendererJ3D;
import visad.cluster.ClusterException;
import visad.cluster.RemoteClientPartitionedFieldImpl;
import visad.cluster.RemoteClusterData;
import visad.cluster.RemoteNodePartitionedField;
import visad.cluster.RemoteNodePartitionedFieldImpl;
import visad.data.gif.GIFForm;
import visad.java2d.DisplayImplJ2D;
import visad.java3d.DisplayImplJ3D;
import visad.java3d.DisplayRendererJ3D;
import visad.util.ContourWidget;

public class TestCluster {
    public static void main(String[] args) throws RemoteException, VisADException {
        int node_divide = 2;
        int number_of_nodes = node_divide * node_divide;
        if (args == null || args.length < 2) {
            System.out.println("usage: 'java visad.cluster.TestCluster n file.gif'");
            System.out.println("  where n = 0 for client, 1 - " + number_of_nodes + " for nodes");
            return;
        }
        int id = -1;
        try {
            id = Integer.parseInt(args[0]);
        }
        catch (NumberFormatException e) {
            System.out.println("usage: 'java visad.cluster.TestCluster n file.gif'");
            System.out.println("  where n = 0 for client, 1 - " + number_of_nodes + " for nodes");
            return;
        }
        if (id < 0 || id > number_of_nodes) {
            System.out.println("usage: 'java visad.cluster.TestCluster n file.gif'");
            System.out.println("  where n = 0 for client, 1 - " + number_of_nodes + " for nodes");
            return;
        }
        boolean client = id == 0;
        GIFForm gif_form = new GIFForm();
        FlatField image = (FlatField)gif_form.open(args[1]);
        if (image == null) {
            System.out.println("cannot open " + args[1]);
            return;
        }
        FunctionType image_type = (FunctionType)image.getType();
        RealTupleType domain_type = image_type.getDomain();
        Linear2DSet domain_set = (Linear2DSet)image.getDomainSet();
        Linear1DSet x_set = domain_set.getX();
        Linear1DSet y_set = domain_set.getY();
        int x_len = x_set.getLength();
        int y_len = y_set.getLength();
        int len = domain_set.getLength();
        Linear2DSet ps = new Linear2DSet(domain_type, x_set.getFirst(), x_set.getLast(), node_divide, y_set.getFirst(), y_set.getLast(), node_divide, domain_set.getCoordinateSystem(), domain_set.getSetUnits(), null);
        RemoteNodePartitionedField[] node_images = new RemoteNodePartitionedField[number_of_nodes];
        if (!client) {
            Linear2DSet[] subsets = new Linear2DSet[number_of_nodes];
            if (number_of_nodes == 1) {
                subsets[0] = domain_set;
                node_images[0] = new RemoteNodePartitionedFieldImpl(image);
            } else {
                int k;
                int i;
                int[] indices = new int[len];
                int i2 = 0;
                while (i2 < len) {
                    indices[i2] = i2;
                    ++i2;
                }
                float[][] values = domain_set.indexToValue(indices);
                int[] ps_indices = ps.valueToIndex(values);
                float[][] firsts = new float[2][number_of_nodes];
                float[][] lasts = new float[2][number_of_nodes];
                int[][] lows = new int[2][number_of_nodes];
                int[][] his = new int[2][number_of_nodes];
                int j = 0;
                while (j < 2) {
                    i = 0;
                    while (i < number_of_nodes) {
                        firsts[j][i] = Float.MAX_VALUE;
                        lasts[j][i] = -3.4028235E38f;
                        lows[j][i] = len + 1;
                        his[j][i] = -1;
                        ++i;
                    }
                    ++j;
                }
                i = 0;
                while (i < len) {
                    k = ps_indices[i];
                    if (k >= 0) {
                        int[] index = new int[]{indices[i] % x_len, indices[i] / x_len};
                        int j2 = 0;
                        while (j2 < 2) {
                            if (values[j2][i] < firsts[j2][k]) {
                                firsts[j2][k] = values[j2][i];
                            }
                            if (values[j2][i] > lasts[j2][k]) {
                                lasts[j2][k] = values[j2][i];
                            }
                            if (index[j2] < lows[j2][k]) {
                                lows[j2][k] = index[j2];
                            }
                            if (index[j2] > his[j2][k]) {
                                his[j2][k] = index[j2];
                            }
                            ++j2;
                        }
                    }
                    ++i;
                }
                k = id - 1;
                if (his[0][k] < 0 || his[1][k] < 0) {
                    throw new ClusterException("Set partition error");
                }
                subsets[k] = new Linear2DSet(domain_type, firsts[0][k], lasts[0][k], his[0][k] - lows[0][k] + 1, firsts[1][k], lasts[1][k], his[1][k] - lows[1][k] + 1, domain_set.getCoordinateSystem(), domain_set.getSetUnits(), null);
                FieldImpl subimage = (FieldImpl)image.resample(subsets[k]);
                node_images[k] = new RemoteNodePartitionedFieldImpl(subimage);
            }
            int kk = id - 1;
            String url = "///TestCluster" + kk;
            try {
                Naming.rebind(url, node_images[kk]);
            }
            catch (Exception e) {
                System.out.println("rebind " + kk + " " + e);
                return;
            }
            DisplayImplJ2D display = new DisplayImplJ2D("dummy");
            return;
        }
        int k = 0;
        while (k < number_of_nodes) {
            String url = "///TestCluster" + k;
            try {
                node_images[k] = (RemoteNodePartitionedField)Naming.lookup(url);
            }
            catch (Exception e) {
                System.out.println("lookup " + k + " " + e);
                return;
            }
            ++k;
        }
        RemoteClientPartitionedFieldImpl client_image = new RemoteClientPartitionedFieldImpl(image_type, domain_set);
        RemoteClusterData[] table = new RemoteClusterData[number_of_nodes + 1];
        int i = 0;
        while (i < number_of_nodes) {
            table[i] = node_images[i];
            ++i;
        }
        table[number_of_nodes] = client_image;
        int i3 = 0;
        while (i3 < table.length) {
            table[i3].setupClusterData(ps, table);
            ++i3;
        }
        DisplayImplJ3D display = new DisplayImplJ3D("main_display", (DisplayRendererJ3D)new ClientDisplayRendererJ3D(100000L));
        RealType element = (RealType)domain_type.getComponent(0);
        RealType line = (RealType)domain_type.getComponent(1);
        RealTupleType range_type = (RealTupleType)image_type.getRange();
        RealType red = (RealType)range_type.getComponent(0);
        display.addMap(new ScalarMap(line, Display.YAxis));
        display.addMap(new ScalarMap(element, Display.XAxis));
        ScalarMap contour_map = new ScalarMap(red, Display.IsoContour);
        display.addMap(contour_map);
        DataReferenceImpl ref = new DataReferenceImpl("image");
        RemoteDataReferenceImpl remote_ref = new RemoteDataReferenceImpl(ref);
        remote_ref.setData(client_image);
        RemoteDisplayImpl remote_display = new RemoteDisplayImpl(display);
        remote_display.addReference(remote_ref);
        JFrame frame = new JFrame("test ClientRendererJ3D");
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.setAlignmentY(0.0f);
        panel.setAlignmentX(0.0f);
        frame.getContentPane().add(panel);
        panel.add(display.getComponent());
        panel.add(new ContourWidget(contour_map));
        ((Component)frame).setSize(500, 700);
        ((Component)frame).setVisible(true);
    }
}

