/*
 * Decompiled with CFR 0.152.
 */
package visad.bom;

import java.rmi.RemoteException;
import visad.Data;
import visad.DataImpl;
import visad.FieldImpl;
import visad.FlatField;
import visad.FunctionType;
import visad.Gridded1DDoubleSet;
import visad.Gridded1DSet;
import visad.MathType;
import visad.QuickSort;
import visad.Real;
import visad.RealTuple;
import visad.RealTupleType;
import visad.RealType;
import visad.Text;
import visad.TextType;
import visad.Tuple;
import visad.TupleType;
import visad.VisADException;
import visad.util.Util;

public class TCData {
    FieldImpl data = null;
    static RealType rtTime = RealType.Time;
    static RealType rtConfidence;
    static RealType rtLat;
    static RealType rtLon;
    static RealType rtError;
    static RealType rtLocationStyle;
    static RealTupleType locationTuple;
    static FunctionType locationFunction;
    static RealType rtWindMean;
    static RealType rtWindGust;
    static RealType rtCentralPressure;
    static RealType rtCategory;
    static RealType rtIntensityStyle;
    static RealType rtGaleRadius;
    static RealType rtStormRadius;
    static RealType rtHurricaneRadius;
    static RealType rtRadiusOfMaximumWinds;
    static RealType rtSizeStyle;
    static RealType rtDepth;
    static RealType rtEyeDiameter;
    static RealType rtPressureOfLastClosedIsobar;
    static RealType rtStructureStyle;
    static RealType rtTrackID;
    static TextType ttTrackType;
    static TextType ttTrackName;
    static RealType rtBaseDateTime;
    static RealType rtCreateDateTime;
    static TextType ttTrackStyle;
    static TupleType ttTrack;
    static FunctionType ftId2Track;
    static RealType rtDisturbanceID;
    static TextType ttCountry;
    static TextType ttState;
    static RealType rtYear;
    static RealType rtNumber;
    static TextType ttHistoricalName;
    static RealType rtOpenDate;
    static RealType rtCloseDate;
    static RealType rtArchiveMode;
    static RealType rtRealtimeMode;
    static TupleType ttDisturbance;
    static FunctionType ftId2Disturbance;
    static FunctionType mtTC;

    public TCData() throws VisADException {
        if (mtTC == null) {
            FunctionType ftId2Disturbance;
            rtTime = RealType.Time;
            rtConfidence = RealType.getRealType("CONFIDENCE", null, null);
            rtLat = RealType.Latitude;
            rtLon = RealType.Longitude;
            rtError = RealType.getRealType("ERROR", null, null);
            rtLocationStyle = RealType.getRealType("LOCATIONSTYLE", null, null);
            rtWindMean = RealType.getRealType("WINDMEAN", null, null);
            rtWindGust = RealType.getRealType("WINDGUST", null, null);
            rtCentralPressure = RealType.getRealType("CENTRALPRESSURE", null, null);
            rtCategory = RealType.getRealType("CATEGORY", null, null);
            rtIntensityStyle = RealType.getRealType("INTENSITYSTYLE", null, null);
            rtGaleRadius = RealType.getRealType("GALERADIUS", null, null);
            rtStormRadius = RealType.getRealType("STORMRADIUS", null, null);
            rtHurricaneRadius = RealType.getRealType("HURRICANERADIUS", null, null);
            rtRadiusOfMaximumWinds = RealType.getRealType("RADIUSOFMAXIMUMWINDS", null, null);
            rtSizeStyle = RealType.getRealType("SIZESTYLE", null, null);
            rtDepth = RealType.getRealType("DEPTH", null, null);
            rtEyeDiameter = RealType.getRealType("EYEDIAMETER", null, null);
            rtPressureOfLastClosedIsobar = RealType.getRealType("PRESSUREOFLASTCLOSEDISOBAR", null, null);
            rtStructureStyle = RealType.getRealType("STRUCTURESTYLE", null, null);
            RealTupleType locationTuple = new RealTupleType(new RealType[]{rtLat, rtLon, rtError, rtConfidence, rtLocationStyle, rtWindMean, rtWindGust, rtCentralPressure, rtCategory, rtIntensityStyle, rtGaleRadius, rtStormRadius, rtHurricaneRadius, rtRadiusOfMaximumWinds, rtSizeStyle, rtDepth, rtEyeDiameter, rtPressureOfLastClosedIsobar, rtStructureStyle});
            locationFunction = new FunctionType(rtTime, locationTuple);
            rtTrackID = RealType.getRealType("TRACKID", null, null);
            ttTrackType = TextType.getTextType("TRACKTYPE");
            ttTrackName = TextType.getTextType("TRACKNAME");
            rtBaseDateTime = RealType.getRealType("BASEDATETIME", null, null);
            rtCreateDateTime = RealType.getRealType("CREATEDATETIME", null, null);
            ttTrackStyle = TextType.getTextType("TRACKSTYLE");
            ttTrack = new TupleType(new MathType[]{ttTrackType, ttTrackName, rtBaseDateTime, rtCreateDateTime, ttTrackStyle, locationFunction});
            ftId2Track = new FunctionType(rtTrackID, ttTrack);
            rtDisturbanceID = RealType.getRealType("DISTURBANCEID", null, null);
            ttCountry = TextType.getTextType("COUNTRY");
            ttState = TextType.getTextType("STATE");
            ttHistoricalName = TextType.getTextType("HISTORICALNAME");
            rtYear = RealType.getRealType("YEAR", null, null);
            rtNumber = RealType.getRealType("NUM", null, null);
            rtOpenDate = RealType.getRealType("OPENDATE", null, null);
            rtCloseDate = RealType.getRealType("CLOSEDATE", null, null);
            rtArchiveMode = RealType.getRealType("ARCHIVEMODE", null, null);
            rtRealtimeMode = RealType.getRealType("REALTIMEMODE", null, null);
            TupleType ttDisturbance = new TupleType(new MathType[]{ttCountry, ttState, rtYear, rtNumber, ttHistoricalName, rtOpenDate, rtCloseDate, rtArchiveMode, rtRealtimeMode, ftId2Track});
            mtTC = ftId2Disturbance = new FunctionType(rtDisturbanceID, ttDisturbance);
        }
    }

    public FieldImpl getData() {
        return this.data;
    }

    public MathType getType() {
        return mtTC;
    }

    public synchronized void addLocation(int disturbanceID, int trackID, double time, RealTuple location) throws VisADException, RemoteException {
        this.addToTrack(disturbanceID, trackID, time, 5, locationFunction, location);
    }

    private void addToTrack(int disturbanceID, int trackID, double time, int tuple_index, FunctionType function_type, RealTuple rt) throws VisADException, RemoteException {
        Tuple disturbance = this.getDisturbance(disturbanceID);
        if (disturbance == null) {
            throw new VisADException("invalid disturbanceID");
        }
        Tuple track = this.getTrack(trackID, disturbance);
        if (track == null) {
            throw new VisADException("invalid trackID");
        }
        FlatField field = (FlatField)track.getComponent(tuple_index);
        Gridded1DDoubleSet set = (Gridded1DDoubleSet)field.getDomainSet();
        double[][] times = set.getDoubles(false);
        int length = set.getLength();
        double[][] new_times = new double[1][length + 1];
        float[][] values = field.getFloats(false);
        int dim = values.length;
        float[][] new_values = new float[dim][length + 1];
        int k = 0;
        int m = -1;
        int i = 0;
        while (i < length + 1) {
            int j;
            if (Util.isApproximatelyEqual(time, times[0][k])) {
                throw new VisADException("time " + time + " already used");
            }
            if (m < 0 && time < times[0][k]) {
                new_times[0][i] = time;
                j = 0;
                while (j < dim) {
                    new_values[j][i] = Float.NaN;
                    ++j;
                }
                m = i;
            } else {
                new_times[0][i] = times[0][k];
                j = 0;
                while (j < dim) {
                    new_values[j][i] = values[j][k];
                    ++j;
                }
                ++k;
            }
            ++i;
        }
        Gridded1DDoubleSet new_set = new Gridded1DDoubleSet((MathType)rtTime, new_times, length + 1);
        FlatField new_field = new FlatField(function_type, new_set);
        new_field.setSamples(new_values, false);
        new_field.setSample(m, (Data)rt);
        Data[] comps = new Data[]{track.getComponent(0), track.getComponent(1), track.getComponent(2), track.getComponent(3), track.getComponent(4), track.getComponent(5)};
        comps[tuple_index] = new_field;
        Tuple new_track = new Tuple(new Data[]{comps[0], comps[1], comps[2], comps[3], comps[4], comps[5]});
        this.setTrack(trackID, new_track, disturbance);
        this.setDisturbance(disturbanceID, disturbance);
    }

    public static FieldImpl makeTrackField(int trackID, Tuple track) throws VisADException, RemoteException {
        float fid = trackID;
        Gridded1DSet set = new Gridded1DSet((MathType)rtTrackID, (float[][])new float[][]{{fid}}, 1);
        FieldImpl field = new FieldImpl(ftId2Track, set);
        field.setSample(0, (Data)track);
        return field;
    }

    public synchronized void addTrack(int disturbanceID, int trackID, Tuple track) throws VisADException, RemoteException {
        Gridded1DSet set;
        Tuple disturbance = this.getDisturbance(disturbanceID);
        if (disturbance == null) {
            throw new VisADException("invalid disturbanceID");
        }
        FieldImpl field = (FieldImpl)disturbance.getComponent(9);
        float fid = trackID;
        FieldImpl new_field = null;
        if (field == null) {
            set = new Gridded1DSet((MathType)rtTrackID, (float[][])new float[][]{{fid}}, 1);
            new_field = new FieldImpl(ftId2Track, set);
            new_field.setSample(0, (Data)track);
        } else {
            set = (Gridded1DSet)field.getDomainSet();
            float[][] ids = set.getSamples(false);
            int length = set.getLength();
            float[][] new_ids = new float[1][length + 1];
            int k = 0;
            int m = -1;
            int i = 0;
            while (i < length + 1) {
                if (fid == ids[0][k]) {
                    throw new VisADException("trackID " + trackID + " already used");
                }
                if (m < 0 && fid < ids[0][k]) {
                    new_ids[0][i] = fid;
                    m = i;
                } else {
                    new_ids[0][i] = ids[0][k];
                    ++k;
                }
                ++i;
            }
            Gridded1DSet new_set = new Gridded1DSet((MathType)rtTrackID, new_ids, length + 1);
            new_field = new FieldImpl(ftId2Track, new_set);
            k = 0;
            int i2 = 0;
            while (i2 < length + 1) {
                if (i2 == m) {
                    new_field.setSample(i2, (Data)track, false);
                } else {
                    new_field.setSample(i2, field.getSample(k), false);
                    ++k;
                }
                ++i2;
            }
        }
        Tuple new_disturbance = new Tuple(new Data[]{disturbance.getComponent(0), disturbance.getComponent(1), disturbance.getComponent(2), disturbance.getComponent(3), disturbance.getComponent(4), disturbance.getComponent(5), disturbance.getComponent(6), disturbance.getComponent(7), disturbance.getComponent(8), new_field});
        this.setDisturbance(disturbanceID, new_disturbance);
    }

    public synchronized void addDisturbance(int disturbanceID, Tuple disturbance) throws VisADException, RemoteException {
        float fid = disturbanceID;
        if (this.data == null) {
            Gridded1DSet set = new Gridded1DSet((MathType)rtDisturbanceID, (float[][])new float[][]{{fid}}, 1);
            this.data = new FieldImpl(mtTC, set);
            this.data.setSample(0, (Data)disturbance);
        } else {
            Gridded1DSet set = (Gridded1DSet)this.data.getDomainSet();
            float[][] ids = set.getSamples(false);
            int length = set.getLength();
            float[][] new_ids = new float[1][length + 1];
            int k = 0;
            int m = -1;
            int i = 0;
            while (i < length + 1) {
                if (fid == ids[0][k]) {
                    throw new VisADException("disturbanceID " + disturbanceID + " already used");
                }
                if (m < 0 && fid < ids[0][k]) {
                    new_ids[0][i] = fid;
                    m = i;
                } else {
                    new_ids[0][i] = ids[0][k];
                    ++k;
                }
                ++i;
            }
            Gridded1DSet new_set = new Gridded1DSet((MathType)rtDisturbanceID, new_ids, length + 1);
            FieldImpl new_data = new FieldImpl(mtTC, new_set);
            k = 0;
            int i2 = 0;
            while (i2 < length + 1) {
                if (i2 == m) {
                    new_data.setSample(i2, (Data)disturbance, false);
                } else {
                    new_data.setSample(i2, this.data.getSample(k), false);
                    ++k;
                }
                ++i2;
            }
            this.data = new_data;
        }
    }

    private Tuple getDisturbance(int disturbanceID) throws VisADException, RemoteException {
        int index = this.findDisturbance(disturbanceID);
        if (index < 0) {
            return null;
        }
        return (Tuple)this.data.getSample(index);
    }

    private void setDisturbance(int disturbanceID, Tuple disturbance) throws VisADException, RemoteException {
        int index = this.findDisturbance(disturbanceID);
        if (index >= 0) {
            this.data.setSample(index, (Data)disturbance);
        }
    }

    private int findDisturbance(int disturbanceID) throws VisADException, RemoteException {
        if (this.data == null) {
            return -1;
        }
        Gridded1DSet set = (Gridded1DSet)this.data.getDomainSet();
        float[][] ids = set.getSamples(false);
        int length = set.getLength();
        float fid = disturbanceID;
        int i = 0;
        while (i < length) {
            if (ids[0][i] == fid) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private Tuple getTrack(int trackID, Tuple disturbance) throws VisADException, RemoteException {
        int index = this.findTrack(trackID, disturbance);
        if (index < 0) {
            return null;
        }
        FieldImpl field = (FieldImpl)disturbance.getComponent(9);
        return (Tuple)field.getSample(index);
    }

    private void setTrack(int trackID, Tuple track, Tuple disturbance) throws VisADException, RemoteException {
        int index = this.findTrack(trackID, disturbance);
        if (index >= 0) {
            FieldImpl field = (FieldImpl)disturbance.getComponent(9);
            field.setSample(index, (Data)track);
        }
    }

    private int findTrack(int trackID, Tuple disturbance) throws VisADException, RemoteException {
        if (disturbance == null) {
            return -1;
        }
        FieldImpl field = (FieldImpl)disturbance.getComponent(9);
        if (field == null) {
            return -1;
        }
        Gridded1DSet set = (Gridded1DSet)field.getDomainSet();
        float[][] ids = set.getSamples(false);
        int length = set.getLength();
        float fid = trackID;
        int i = 0;
        while (i < length) {
            if (ids[0][i] == fid) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static Tuple makeDisturbance(String country, String state, int year, int number, String historical_name, double open_date, double close_date, int archive_mode, int realtime_mode, FieldImpl tracks) throws VisADException, RemoteException {
        return new Tuple(new DataImpl[]{new Text(ttCountry, country), new Text(ttState, state), new Real(rtYear, (double)year), new Real(rtNumber, (double)number), new Text(ttHistoricalName, historical_name), new Real(rtOpenDate, open_date), new Real(rtCloseDate, close_date), new Real(rtArchiveMode, (double)archive_mode), new Real(rtRealtimeMode, (double)realtime_mode), tracks});
    }

    public static Tuple makeTrack(String track_type, String track_name, double base_date_time, double create_date_time, String display_type, FlatField locations) throws VisADException, RemoteException {
        return new Tuple(new DataImpl[]{new Text(ttTrackType, track_type), new Text(ttTrackName, track_name), new Real(rtBaseDateTime, base_date_time), new Real(rtCreateDateTime, create_date_time), new Text(ttTrackStyle, display_type), locations});
    }

    public static FlatField makeLocations(double[] times, float[] lats, float[] lons, float[] errors, int[] confidence, int[] location_styles, float[] wind_means, float[] wind_gusts, float[] central_pressures, int[] categories, int[] intensityStyle, float[] gale_radii, float[] storm_radii, float[] hurricane_radii, float[] radii_of_maximum_winds, int[] size_styles, float[] depth, float[] eyeDiameter, float[] pressureOfLastClosedIsobar, int[] structureStyle) throws VisADException, RemoteException {
        if (times == null || lats == null || lons == null || errors == null || confidence == null || location_styles == null || wind_means == null || wind_gusts == null || central_pressures == null || categories == null || intensityStyle == null || gale_radii == null || storm_radii == null || hurricane_radii == null || radii_of_maximum_winds == null || size_styles == null || depth == null || eyeDiameter == null || pressureOfLastClosedIsobar == null || structureStyle == null) {
            throw new VisADException("arguments may not be null");
        }
        int length = times.length;
        if (lats.length != length || lons.length != length || errors.length != length || confidence.length != length || location_styles.length != length) {
            throw new VisADException("argument lengths must match");
        }
        int[] permute = QuickSort.sort(times);
        Gridded1DDoubleSet set = new Gridded1DDoubleSet((MathType)rtTime, new double[][]{times}, length);
        FlatField field = new FlatField(locationFunction, set);
        float[] plats = new float[length];
        float[] plons = new float[length];
        float[] perrors = new float[length];
        float[] pconfidence = new float[length];
        float[] pLocation_styles = new float[length];
        float[] pwind_means = new float[length];
        float[] pwind_gusts = new float[length];
        float[] pcentral_pressures = new float[length];
        float[] pcategories = new float[length];
        float[] pIntensityStyle = new float[length];
        float[] pgale_radii = new float[length];
        float[] pstorm_radii = new float[length];
        float[] phurricane_radii = new float[length];
        float[] pradii_of_maximum_winds = new float[length];
        float[] psize_styles = new float[length];
        float[] pdepth = new float[length];
        float[] pEyeDiameter = new float[length];
        float[] pPressureOfLastClosedIsobar = new float[length];
        float[] pStructureStyle = new float[length];
        int i = 0;
        while (i < length) {
            plats[i] = lats[permute[i]];
            plons[i] = lons[permute[i]];
            perrors[i] = errors[permute[i]];
            pconfidence[i] = confidence[permute[i]];
            pLocation_styles[i] = location_styles[permute[i]];
            pwind_means[i] = wind_means[permute[i]];
            pwind_gusts[i] = wind_gusts[permute[i]];
            pcentral_pressures[i] = central_pressures[permute[i]];
            pcategories[i] = categories[permute[i]];
            pIntensityStyle[i] = intensityStyle[permute[i]];
            pgale_radii[i] = gale_radii[permute[i]];
            pstorm_radii[i] = storm_radii[permute[i]];
            phurricane_radii[i] = hurricane_radii[permute[i]];
            pradii_of_maximum_winds[i] = radii_of_maximum_winds[permute[i]];
            psize_styles[i] = size_styles[permute[i]] < 0 ? Float.NaN : (float)size_styles[permute[i]];
            pdepth[i] = depth[permute[i]];
            pEyeDiameter[i] = eyeDiameter[permute[i]];
            pPressureOfLastClosedIsobar[i] = pressureOfLastClosedIsobar[permute[i]];
            pStructureStyle[i] = structureStyle[permute[i]];
            ++i;
        }
        float[][] values = new float[][]{plats, plons, perrors, pconfidence, pLocation_styles, pwind_means, pwind_gusts, pcentral_pressures, pcategories, pIntensityStyle, pgale_radii, pstorm_radii, phurricane_radii, pradii_of_maximum_winds, psize_styles, pdepth, pEyeDiameter, pPressureOfLastClosedIsobar, pStructureStyle};
        field.setSamples(values, false);
        return field;
    }

    public static void main(String[] args) throws VisADException, RemoteException {
        TCData data = new TCData();
        MathType mtTC = data.getType();
        System.out.println("MathType:\n" + mtTC);
    }
}

