/*
 * Decompiled with CFR 0.152.
 */
package visad.bom;

import java.rmi.RemoteException;
import visad.DataDisplayLink;
import visad.DataRenderer;
import visad.DisplayImpl;
import visad.FlowControl;
import visad.MathType;
import visad.ShadowType;
import visad.VisADException;
import visad.VisADGeometryArray;
import visad.VisADLineArray;
import visad.VisADTriangleArray;
import visad.bom.BarbManipulationRendererJ3D;
import visad.bom.BarbRenderer;
import visad.java3d.ShadowRealTupleTypeJ3D;

public class ShadowBarbRealTupleTypeJ3D
extends ShadowRealTupleTypeJ3D {
    private static final int NUM = 1024;
    static /* synthetic */ Class class$visad$Flow1Control;
    static /* synthetic */ Class class$visad$Flow2Control;

    public ShadowBarbRealTupleTypeJ3D(MathType t, DataDisplayLink link, ShadowType parent) throws VisADException, RemoteException {
        super(t, link, parent);
    }

    public VisADGeometryArray[] makeFlow(int which, float[][] flow_values, float flowScale, float[][] spatial_values, byte[][] color_values, boolean[][] range_select) throws VisADException {
        DataRenderer renderer = this.getLink().getRenderer();
        boolean direct = renderer.getIsDirectManipulation();
        if (direct && renderer instanceof BarbManipulationRendererJ3D) {
            return ShadowBarbRealTupleTypeJ3D.staticMakeFlow(this.getDisplay(), which, flow_values, flowScale, spatial_values, color_values, range_select, renderer, true);
        }
        return ShadowBarbRealTupleTypeJ3D.staticMakeFlow(this.getDisplay(), which, flow_values, flowScale, spatial_values, color_values, range_select, renderer, false);
    }

    public static VisADGeometryArray[] staticMakeFlow(DisplayImpl display, int which, float[][] flow_values, float flowScale, float[][] spatial_values, byte[][] color_values, boolean[][] range_select, DataRenderer renderer, boolean direct) throws VisADException {
        if (flow_values[0] == null) {
            return null;
        }
        if (spatial_values[0] == null) {
            return null;
        }
        int len = spatial_values[0].length;
        int flen = flow_values[0].length;
        int rlen = 0;
        if (range_select[0] == null) {
            rlen = len;
        } else {
            int j = 0;
            while (j < range_select[0].length) {
                if (range_select[0][j]) {
                    ++rlen;
                }
                ++j;
            }
        }
        if (rlen == 0) {
            return null;
        }
        boolean[] south = new boolean[len];
        float[][] earth_locs = renderer.spatialToEarth(spatial_values);
        if (earth_locs != null) {
            int i = 0;
            while (i < len) {
                south[i] = earth_locs[0][i] < 0.0f;
                ++i;
            }
        } else {
            FlowControl fcontrol = null;
            if (which == 0) {
                fcontrol = (FlowControl)display.getControl(class$visad$Flow1Control == null ? (class$visad$Flow1Control = ShadowBarbRealTupleTypeJ3D.class$("visad.Flow1Control")) : class$visad$Flow1Control);
            } else if (which == 1) {
                fcontrol = (FlowControl)display.getControl(class$visad$Flow2Control == null ? (class$visad$Flow2Control = ShadowBarbRealTupleTypeJ3D.class$("visad.Flow2Control")) : class$visad$Flow2Control);
            }
            if (fcontrol == null) {
                throw new VisADException("ShadowBarbRealTupleTypeJ3D: Unable to get FlowControl");
            }
            boolean isSouth = fcontrol.getBarbOrientation() == 1;
            int i = 0;
            while (i < len) {
                south[i] = isSouth;
                ++i;
            }
        }
        flow_values = ShadowType.adjustFlowToEarth(which, flow_values, spatial_values, 0.02f, renderer);
        float[] vx = new float[1024];
        float[] vy = new float[1024];
        float[] vz = new float[1024];
        float[] tx = new float[1024];
        float[] ty = new float[1024];
        float[] tz = new float[1024];
        byte[] vred = null;
        byte[] vgreen = null;
        byte[] vblue = null;
        byte[] tred = null;
        byte[] tgreen = null;
        byte[] tblue = null;
        if (color_values != null) {
            vred = new byte[1024];
            vgreen = new byte[1024];
            vblue = new byte[1024];
            tred = new byte[1024];
            tgreen = new byte[1024];
            tblue = new byte[1024];
        }
        int[] numv = new int[]{0};
        int[] numt = new int[]{0};
        float scale = flowScale;
        float pt_size = 0.25f * flowScale;
        float f0 = 0.0f;
        float f1 = 0.0f;
        float f2 = 0.0f;
        int j = 0;
        while (j < len) {
            if (range_select[0] == null || range_select[0][j]) {
                byte[] cblue;
                byte[] cgreen;
                byte[] cred;
                int l;
                float[] cz;
                float[] cy;
                float[] cx;
                if (flen == 1) {
                    f0 = flow_values[0][0];
                    f1 = flow_values[1][0];
                    f2 = flow_values[2][0];
                } else {
                    f0 = flow_values[0][j];
                    f1 = flow_values[1][j];
                    f2 = flow_values[2][j];
                }
                if (numv[0] + 256 > vx.length) {
                    cx = vx;
                    cy = vy;
                    cz = vz;
                    l = 2 * vx.length;
                    vx = new float[l];
                    vy = new float[l];
                    vz = new float[l];
                    System.arraycopy(cx, 0, vx, 0, cx.length);
                    System.arraycopy(cy, 0, vy, 0, cy.length);
                    System.arraycopy(cz, 0, vz, 0, cz.length);
                    if (color_values != null) {
                        cred = vred;
                        cgreen = vgreen;
                        cblue = vblue;
                        vred = new byte[l];
                        vgreen = new byte[l];
                        vblue = new byte[l];
                        System.arraycopy(cred, 0, vred, 0, cred.length);
                        System.arraycopy(cgreen, 0, vgreen, 0, cgreen.length);
                        System.arraycopy(cblue, 0, vblue, 0, cblue.length);
                    }
                }
                if (numt[0] + 256 > tx.length) {
                    cx = tx;
                    cy = ty;
                    cz = tz;
                    l = 2 * tx.length;
                    tx = new float[l];
                    ty = new float[l];
                    tz = new float[l];
                    System.arraycopy(cx, 0, tx, 0, cx.length);
                    System.arraycopy(cy, 0, ty, 0, cy.length);
                    System.arraycopy(cz, 0, tz, 0, cz.length);
                    if (color_values != null) {
                        cred = tred;
                        cgreen = tgreen;
                        cblue = tblue;
                        tred = new byte[l];
                        tgreen = new byte[l];
                        tblue = new byte[l];
                        System.arraycopy(cred, 0, tred, 0, cred.length);
                        System.arraycopy(cgreen, 0, tgreen, 0, cgreen.length);
                        System.arraycopy(cblue, 0, tblue, 0, cblue.length);
                    }
                }
                int oldnv = numv[0];
                int oldnt = numt[0];
                float[] mbarb = ((BarbRenderer)((Object)renderer)).makeVector(south[j], spatial_values[0][j], spatial_values[1][j], spatial_values[2][j], scale, pt_size, f0, f1, vx, vy, vz, numv, tx, ty, tz, numt);
                if (direct) {
                    ((BarbManipulationRendererJ3D)renderer).setVectorSpatialValues(mbarb, which);
                }
                int nv = numv[0];
                int nt = numt[0];
                if (color_values != null) {
                    if (color_values[0].length > 1) {
                        int i = oldnv;
                        while (i < nv) {
                            vred[i] = color_values[0][j];
                            vgreen[i] = color_values[1][j];
                            vblue[i] = color_values[2][j];
                            ++i;
                        }
                        int i2 = oldnt;
                        while (i2 < nt) {
                            tred[i2] = color_values[0][j];
                            tgreen[i2] = color_values[1][j];
                            tblue[i2] = color_values[2][j];
                            ++i2;
                        }
                    } else {
                        int i = oldnv;
                        while (i < nv) {
                            vred[i] = color_values[0][0];
                            vgreen[i] = color_values[1][0];
                            vblue[i] = color_values[2][0];
                            ++i;
                        }
                        int i3 = oldnt;
                        while (i3 < nt) {
                            tred[i3] = color_values[0][0];
                            tgreen[i3] = color_values[1][0];
                            tblue[i3] = color_values[2][0];
                            ++i3;
                        }
                    }
                }
            }
            ++j;
        }
        int nv = numv[0];
        int nt = numt[0];
        if (nv == 0) {
            return null;
        }
        VisADGeometryArray[] arrays = null;
        VisADLineArray array = new VisADLineArray();
        array.vertexCount = nv;
        float[] coordinates = new float[3 * nv];
        int m = 0;
        int i = 0;
        while (i < nv) {
            coordinates[m++] = vx[i];
            coordinates[m++] = vy[i];
            coordinates[m++] = vz[i];
            ++i;
        }
        array.coordinates = coordinates;
        byte[] colors = null;
        if (color_values != null) {
            colors = new byte[3 * nv];
            m = 0;
            int i4 = 0;
            while (i4 < nv) {
                colors[m++] = vred[i4];
                colors[m++] = vgreen[i4];
                colors[m++] = vblue[i4];
                ++i4;
            }
            array.colors = colors;
        }
        VisADTriangleArray tarray = null;
        if (nt > 0) {
            tarray = new VisADTriangleArray();
            tarray.vertexCount = nt;
            coordinates = new float[3 * nt];
            float[] normals = new float[3 * nt];
            m = 0;
            int i5 = 0;
            while (i5 < nt) {
                coordinates[m++] = tx[i5];
                coordinates[m++] = ty[i5];
                coordinates[m++] = tz[i5];
                ++i5;
            }
            tarray.coordinates = coordinates;
            m = 0;
            int i6 = 0;
            while (i6 < nt) {
                normals[m++] = 0.0f;
                normals[m++] = 0.0f;
                normals[m++] = 1.0f;
                ++i6;
            }
            tarray.normals = normals;
            if (color_values != null) {
                colors = new byte[3 * nt];
                m = 0;
                int i7 = 0;
                while (i7 < nt) {
                    colors[m++] = tred[i7];
                    colors[m++] = tgreen[i7];
                    colors[m++] = tblue[i7];
                    ++i7;
                }
                tarray.colors = colors;
            }
            array = (VisADLineArray)array.adjustLongitudeBulk(renderer);
            tarray = (VisADTriangleArray)tarray.adjustLongitudeBulk(renderer);
            arrays = new VisADGeometryArray[]{array, tarray};
        } else {
            array = (VisADLineArray)array.adjustLongitudeBulk(renderer);
            arrays = new VisADGeometryArray[]{array};
        }
        return arrays;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

