/*
 * Decompiled with CFR 0.152.
 */
package visad.bom;

import visad.CommonUnit;
import visad.CoordinateSystemException;
import visad.RealTupleType;
import visad.Unit;
import visad.VisADException;
import visad.georef.NavigatedCoordinateSystem;

public class Radar2DCoordinateSystem
extends NavigatedCoordinateSystem {
    private static Unit[] coordinate_system_units = new Unit[]{CommonUnit.meter, CommonUnit.degree};
    private float centlat;
    private float centlon;
    private float radlow;
    private float radres;
    private float azlow;
    private float azres;
    private double coscentlat;
    private double lonscale;
    private double latscale;

    public Radar2DCoordinateSystem(float clat, float clon) throws VisADException {
        this(RealTupleType.LatitudeLongitudeTuple, clat, clon, 0.0f, 1.0f, 0.0f, 1.0f);
    }

    public Radar2DCoordinateSystem(float clat, float clon, float radl, float radr, float azl, float azr) throws VisADException {
        this(RealTupleType.LatitudeLongitudeTuple, clat, clon, radl, radr, azl, azr);
    }

    public Radar2DCoordinateSystem(RealTupleType reference, float clat, float clon, float radl, float radr, float azl, float azr) throws VisADException {
        super(reference, coordinate_system_units);
        this.centlat = clat;
        this.centlon = clon;
        this.radlow = radl;
        this.radres = radr;
        this.azlow = azl;
        this.azres = azr;
        this.coscentlat = Math.cos(Math.PI / 180 * (double)this.centlat);
        this.lonscale = 111137.0 * this.coscentlat;
        this.latscale = 111137.0;
    }

    public double[][] toReference(double[][] tuples) throws VisADException {
        if (tuples == null || tuples.length != 2) {
            throw new CoordinateSystemException("Radar2DCoordinateSystem.toReference: tuples wrong dimension");
        }
        int len = tuples[0].length;
        double[][] value = new double[2][len];
        int i = 0;
        while (i < len) {
            double rad = (double)this.radlow + (double)this.radres * tuples[0][i];
            if (rad < 0.0) {
                value[0][i] = Double.NaN;
                value[1][i] = Double.NaN;
            } else {
                double az = (double)this.azlow + (double)this.azres * tuples[1][i];
                double cosaz = Math.cos(Math.PI / 180 * az);
                double sinaz = Math.sin(Math.PI / 180 * az);
                value[0][i] = (double)this.centlat + cosaz * rad / this.latscale;
                value[1][i] = (double)this.centlon + sinaz * rad / this.lonscale;
            }
            ++i;
        }
        return value;
    }

    public double[][] fromReference(double[][] tuples) throws VisADException {
        if (tuples == null || tuples.length != 2) {
            throw new CoordinateSystemException("Radar2DCoordinateSystem.fromReference: tuples wrong dimension");
        }
        int len = tuples[0].length;
        double[][] value = new double[2][len];
        int i = 0;
        while (i < len) {
            double slat = (tuples[0][i] - (double)this.centlat) * this.latscale;
            double slon = (tuples[1][i] - (double)this.centlon) * this.lonscale;
            value[0][i] = (Math.sqrt(slat * slat + slon * slon) - (double)this.radlow) / (double)this.radres;
            value[1][i] = (57.29577951308232 * Math.atan2(slon, slat) - (double)this.azlow) / (double)this.azres;
            if (value[1][i] < 0.0) {
                double[] dArray = value[1];
                int n = i;
                dArray[n] = dArray[n] + 360.0;
            }
            ++i;
        }
        return value;
    }

    public float[][] toReference(float[][] tuples) throws VisADException {
        if (tuples == null || tuples.length != 2) {
            throw new CoordinateSystemException("Radar2DCoordinateSystem.toReference: tuples wrong dimension");
        }
        int len = tuples[0].length;
        float[][] value = new float[2][len];
        int i = 0;
        while (i < len) {
            double rad = this.radlow + this.radres * tuples[0][i];
            if (rad < 0.0) {
                value[0][i] = Float.NaN;
                value[1][i] = Float.NaN;
            } else {
                double az = this.azlow + this.azres * tuples[1][i];
                double cosaz = Math.cos(Math.PI / 180 * az);
                double sinaz = Math.sin(Math.PI / 180 * az);
                value[0][i] = (float)((double)this.centlat + cosaz * rad / this.latscale);
                value[1][i] = (float)((double)this.centlon + sinaz * rad / this.lonscale);
            }
            ++i;
        }
        return value;
    }

    public float[][] fromReference(float[][] tuples) throws VisADException {
        if (tuples == null || tuples.length != 2) {
            throw new CoordinateSystemException("Radar2DCoordinateSystem.fromReference: tuples wrong dimension");
        }
        int len = tuples[0].length;
        float[][] value = new float[2][len];
        int i = 0;
        while (i < len) {
            double slat = (double)(tuples[0][i] - this.centlat) * this.latscale;
            double slon = (double)(tuples[1][i] - this.centlon) * this.lonscale;
            value[0][i] = (float)((Math.sqrt(slat * slat + slon * slon) - (double)this.radlow) / (double)this.radres);
            value[1][i] = (float)((57.29577951308232 * Math.atan2(slon, slat) - (double)this.azlow) / (double)this.azres);
            if ((double)value[1][i] < 0.0) {
                float[] fArray = value[1];
                int n = i;
                fArray[n] = fArray[n] + 360.0f;
            }
            ++i;
        }
        return value;
    }

    public boolean equals(Object cs) {
        return cs instanceof Radar2DCoordinateSystem;
    }

    public float[] getAzimuthParameters() {
        return new float[]{this.azlow, this.azres};
    }

    public float[] getRangeParameters() {
        return new float[]{this.radlow, this.radres};
    }

    public float[] getCenterPoint() {
        return new float[]{this.centlat, this.centlon};
    }
}

