/*
 * Decompiled with CFR 0.152.
 */
package visad.bom;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.rmi.RemoteException;
import visad.ConstantMap;
import visad.DataReferenceImpl;
import visad.DataRenderer;
import visad.DelaunayCustom;
import visad.Display;
import visad.DisplayImpl;
import visad.GraphicsModeControl;
import visad.Irregular2DSet;
import visad.SampledSet;
import visad.UnionSet;
import visad.VisADException;
import visad.java3d.DefaultRendererJ3D;

class CurveDelete
implements ActionListener {
    DataReferenceImpl ref;
    DisplayImpl display;
    boolean lines = false;
    DataReferenceImpl new_ref;

    CurveDelete(DataReferenceImpl r, DisplayImpl d) {
        this.ref = r;
        this.display = d;
    }

    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (cmd.equals("del")) {
            try {
                UnionSet set = (UnionSet)this.ref.getData();
                SampledSet[] sets = set.getSets();
                SampledSet[] new_sets = new SampledSet[sets.length - 1];
                System.arraycopy(sets, 0, new_sets, 0, sets.length - 1);
                this.ref.setData(new UnionSet(set.getType(), new_sets));
            }
            catch (VisADException ex) {
            }
            catch (RemoteException ex) {}
        } else if (cmd.equals("fill")) {
            UnionSet set = null;
            try {
                set = (UnionSet)this.ref.getData();
                System.out.println("area = " + DelaunayCustom.computeArea(set));
            }
            catch (VisADException ex) {
                System.out.println(ex.getMessage());
            }
            try {
                Irregular2DSet new_set = DelaunayCustom.fillCheck(set, false);
                if (this.new_ref == null) {
                    this.new_ref = new DataReferenceImpl("fill");
                    ConstantMap[] cmaps = new ConstantMap[]{new ConstantMap(1.0, Display.Blue), new ConstantMap(1.0, Display.Red), new ConstantMap(0.0, Display.Green)};
                    DefaultRendererJ3D renderer = new DefaultRendererJ3D();
                    renderer.suppressExceptions(true);
                    this.display.addReferences((DataRenderer)renderer, this.new_ref, cmaps);
                }
                this.new_ref.setData(new_set);
            }
            catch (VisADException ex) {
                System.out.println(ex.getMessage());
            }
            catch (RemoteException ex) {
                System.out.println(ex.getMessage());
            }
        } else if (cmd.equals("lines")) {
            try {
                this.lines = !this.lines;
                GraphicsModeControl mode = this.display.getGraphicsModeControl();
                if (this.lines) {
                    mode.setPolygonMode(1);
                } else {
                    mode.setPolygonMode(2);
                }
            }
            catch (VisADException ex) {
                System.out.println(ex.getMessage());
            }
            catch (RemoteException ex) {
                System.out.println(ex.getMessage());
            }
        }
    }
}

