/*
 * Decompiled with CFR 0.152.
 */
package visad.bio;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.rmi.RemoteException;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JToggleButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import visad.AnimationControl;
import visad.VisADException;
import visad.bio.BioAnimWidget;
import visad.bio.ToolPanel;
import visad.bio.VisBio;
import visad.browser.Divider;

public class ViewToolPanel
extends ToolPanel {
    private JCheckBox twoD;
    private JButton zoomIn2;
    private JButton zoomReset2;
    private JButton zoomOut2;
    private JCheckBox threeD;
    private JButton zoomIn3;
    private JButton zoomReset3;
    private JButton zoomOut3;
    private JCheckBox box3;
    private JCheckBox preview;
    private JToggleButton loRes;
    private JToggleButton hiRes;
    private JCheckBox autoSwitch;
    private BioAnimWidget anim;
    private JCheckBox doVolume;
    private JLabel volumeValue;
    private JSlider volumeRes;
    private JCheckBox doSlice;
    private JLabel sliceValue;
    private JSlider sliceRes;
    private JCheckBox sliceContinuous;
    private int maxVolRes;

    public ViewToolPanel(VisBio biovis) {
        super(biovis);
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 0));
        this.twoD = new JCheckBox("2-D", true);
        this.twoD.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                boolean b = ViewToolPanel.this.twoD.isSelected();
                ViewToolPanel.this.bio.set2D(b);
                ViewToolPanel.this.zoomIn2.setEnabled(b);
                ViewToolPanel.this.zoomReset2.setEnabled(b);
                ViewToolPanel.this.zoomOut2.setEnabled(b);
            }
        });
        p.add(this.twoD);
        this.zoomIn2 = new JButton("Zoom in");
        this.zoomIn2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ViewToolPanel.this.bio.setZoom(false, 1.5);
            }
        });
        p.add(this.zoomIn2);
        this.zoomReset2 = new JButton("Reset");
        this.zoomReset2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ViewToolPanel.this.bio.resetZoom(false);
            }
        });
        p.add(this.zoomReset2);
        this.zoomOut2 = new JButton("Zoom out");
        this.zoomOut2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ViewToolPanel.this.bio.setZoom(false, 0.667);
            }
        });
        p.add(this.zoomOut2);
        this.controls.add(ToolPanel.pad(p));
        p = new JPanel();
        p.setLayout(new BoxLayout(p, 0));
        boolean okay3d = this.bio.display3 != null;
        this.threeD = new JCheckBox("3-D", okay3d);
        this.threeD.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                boolean b = ViewToolPanel.this.threeD.isSelected();
                ViewToolPanel.this.bio.set3D(b);
                ViewToolPanel.this.zoomIn3.setEnabled(b);
                ViewToolPanel.this.zoomReset3.setEnabled(b);
                ViewToolPanel.this.zoomOut3.setEnabled(b);
            }
        });
        this.threeD.setEnabled(okay3d);
        p.add(this.threeD);
        this.zoomIn3 = new JButton("Zoom in");
        this.zoomIn3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ViewToolPanel.this.bio.setZoom(true, 2.0);
            }
        });
        this.zoomIn3.setEnabled(okay3d);
        p.add(this.zoomIn3);
        this.zoomReset3 = new JButton("Reset");
        this.zoomReset3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ViewToolPanel.this.bio.resetZoom(true);
            }
        });
        this.zoomReset3.setEnabled(okay3d);
        p.add(this.zoomReset3);
        this.zoomOut3 = new JButton("Zoom out");
        this.zoomOut3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ViewToolPanel.this.bio.setZoom(true, 0.5);
            }
        });
        this.zoomOut3.setEnabled(okay3d);
        p.add(this.zoomOut3);
        this.controls.add(ToolPanel.pad(p));
        this.box3 = new JCheckBox("3-D bounding box", okay3d);
        this.box3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    ViewToolPanel.this.bio.display3.getDisplayRenderer().setBoxOn(ViewToolPanel.this.box3.isSelected());
                }
                catch (VisADException exc) {
                    exc.printStackTrace();
                }
                catch (RemoteException exc) {
                    exc.printStackTrace();
                }
            }
        });
        this.box3.setEnabled(okay3d);
        this.controls.add(ToolPanel.pad(this.box3));
        this.preview = new JCheckBox("Previous/next preview displays", false);
        this.preview.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                boolean b = ViewToolPanel.this.preview.isSelected();
                ViewToolPanel.this.bio.setPreview(b);
            }
        });
        this.preview.setEnabled(okay3d);
        this.controls.add(ToolPanel.pad(this.preview));
        this.controls.add(Box.createVerticalStrut(10));
        this.controls.add(new Divider());
        this.controls.add(Box.createVerticalStrut(10));
        p = new JPanel();
        p.setLayout(new BoxLayout(p, 0));
        this.loRes = new JToggleButton("Lo-res", false);
        this.loRes.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ViewToolPanel.this.bio.sm.setMode(true);
            }
        });
        this.loRes.setEnabled(false);
        p.add(this.loRes);
        this.hiRes = new JToggleButton("Hi-res", true);
        this.hiRes.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AnimationControl control = ViewToolPanel.this.anim.getControl();
                try {
                    if (control != null) {
                        control.setOn(false);
                    }
                }
                catch (VisADException exc) {
                    exc.printStackTrace();
                }
                catch (RemoteException exc) {
                    exc.printStackTrace();
                }
                ViewToolPanel.this.bio.sm.setMode(false);
            }
        });
        this.hiRes.setEnabled(false);
        p.add(this.hiRes);
        this.controls.add(ToolPanel.pad(p));
        this.autoSwitch = new JCheckBox("Auto-switch resolutions", true);
        this.autoSwitch.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                ViewToolPanel.this.bio.sm.setAutoSwitch(ViewToolPanel.this.autoSwitch.isSelected());
            }
        });
        this.autoSwitch.setEnabled(false);
        this.controls.add(ToolPanel.pad(this.autoSwitch));
        this.controls.add(Box.createVerticalStrut(5));
        p = new JPanel();
        p.setLayout(new BoxLayout(p, 0));
        this.anim = new BioAnimWidget(this.bio);
        this.anim.setEnabled(false);
        p.add(this.anim);
        this.controls.add(ToolPanel.pad(p));
        this.controls.add(Box.createVerticalStrut(10));
        this.controls.add(new Divider());
        this.controls.add(Box.createVerticalStrut(10));
        p = new JPanel();
        p.setLayout(new BoxLayout(p, 0));
        this.doVolume = new JCheckBox("3-D volume rendering: ", false);
        this.doVolume.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                boolean b = ViewToolPanel.this.doVolume.isSelected();
                ViewToolPanel.this.bio.setVolume(b);
            }
        });
        this.doVolume.setEnabled(false);
        p.add(this.doVolume);
        int detail = 256;
        int normal = detail / 2;
        this.volumeValue = new JLabel("");
        this.volumeValue.setEnabled(false);
        p.add(this.volumeValue);
        this.controls.add(ToolPanel.pad(p));
        this.volumeRes = new JSlider(0, detail, normal);
        this.volumeRes.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                ViewToolPanel.this.doVolumeRes(!ViewToolPanel.this.volumeRes.getValueIsAdjusting());
            }
        });
        this.volumeRes.setEnabled(false);
        this.volumeRes.setMajorTickSpacing(detail / 4);
        this.volumeRes.setMinorTickSpacing(detail / 16);
        this.volumeRes.setPaintTicks(true);
        this.controls.add(ToolPanel.pad(this.volumeRes));
        p = new JPanel();
        p.setLayout(new BoxLayout(p, 0));
        this.doSlice = new JCheckBox("Arbitrary data slice: ", false);
        this.doSlice.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                boolean b = ViewToolPanel.this.doSlice.isSelected();
                ViewToolPanel.this.bio.sm.setPlaneSelect(b);
                ViewToolPanel.this.bio.vert.setEnabled(!b);
                ViewToolPanel.this.bio.toolMeasure.setEnabled(!b);
                ViewToolPanel.this.bio.mm.pool2.setSlice(b ? -1 : ViewToolPanel.this.bio.sm.getSlice());
            }
        });
        this.doSlice.setEnabled(false);
        p.add(this.doSlice);
        this.sliceValue = new JLabel("");
        this.sliceValue.setEnabled(false);
        p.add(this.sliceValue);
        this.controls.add(ToolPanel.pad(p));
        this.sliceRes = new JSlider(0, detail, normal);
        this.sliceRes.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                ViewToolPanel.this.doSliceRes(!ViewToolPanel.this.sliceRes.getValueIsAdjusting());
            }
        });
        this.sliceRes.setEnabled(false);
        this.sliceRes.setMajorTickSpacing(detail / 4);
        this.sliceRes.setMinorTickSpacing(detail / 16);
        this.sliceRes.setPaintTicks(true);
        this.controls.add(ToolPanel.pad(this.sliceRes));
        this.sliceContinuous = new JCheckBox("Update slice continuously", false);
        this.sliceContinuous.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                ViewToolPanel.this.bio.sm.setPlaneContinuous(ViewToolPanel.this.sliceContinuous.isSelected());
            }
        });
        this.sliceContinuous.setEnabled(false);
        this.controls.add(ToolPanel.pad(this.sliceContinuous));
    }

    public void init() {
        int slices;
        this.maxVolRes = this.bio.sm.res_x;
        if (this.bio.sm.res_y > this.maxVolRes) {
            this.maxVolRes = this.bio.sm.res_y;
        }
        if ((slices = this.bio.sm.getNumberOfSlices()) > this.maxVolRes) {
            this.maxVolRes = slices;
        }
        if (this.maxVolRes > 128) {
            this.maxVolRes = 128;
        }
        int volVal = this.maxVolRes < 64 ? this.maxVolRes : 64;
        double volPercent = (double)volVal / (double)this.maxVolRes;
        int vv = (int)(volPercent * 256.0);
        if (this.volumeRes.getValue() == vv) {
            this.doVolumeRes(true);
        } else {
            this.volumeRes.setValue(vv);
        }
        int max = this.bio.sm.res_x < this.bio.sm.res_y ? this.bio.sm.res_x : this.bio.sm.res_y;
        int sliceVal = max < 64 ? max : 64;
        double slicePercent = (double)sliceVal / (double)max;
        int sv = (int)(slicePercent * 256.0);
        if (this.sliceRes.getValue() == sv) {
            this.doSliceRes(true);
        } else {
            this.sliceRes.setValue((int)(slicePercent * 256.0));
        }
    }

    public void setEnabled(boolean enabled) {
        boolean b = enabled && this.bio.sm.hasThumbnails();
        this.loRes.setEnabled(b);
        this.hiRes.setEnabled(b);
        this.autoSwitch.setEnabled(b);
        this.anim.setEnabled(b);
        b = enabled && this.bio.sm.getNumberOfSlices() > 1 && this.bio.display3 != null;
        this.doVolume.setEnabled(b);
        this.volumeValue.setEnabled(b);
        this.volumeRes.setEnabled(b);
        this.doSlice.setEnabled(b);
        this.sliceValue.setEnabled(b);
        this.sliceRes.setEnabled(b);
        this.sliceContinuous.setEnabled(b);
    }

    public void setMode(boolean lowres) {
        this.loRes.setSelected(lowres);
        this.hiRes.setSelected(!lowres);
    }

    void setControl(AnimationControl control) {
        this.anim.setControl(control);
    }

    private void doVolumeRes(boolean go) {
        int value = this.volumeRes.getValue();
        double percent = (double)value / 256.0;
        int res = (int)(percent * (double)this.maxVolRes);
        if (res < 2) {
            res = 2;
        }
        this.volumeValue.setText(res + " x " + res + " x " + res);
        if (go) {
            this.bio.sm.setVolumeResolution(res);
        }
    }

    private void doSliceRes(boolean go) {
        int value = this.sliceRes.getValue();
        double percent = (double)value / 256.0;
        int x = (int)(percent * (double)this.bio.sm.res_x);
        int y = (int)(percent * (double)this.bio.sm.res_y);
        if (x < 2) {
            x = 2;
        }
        if (y < 2) {
            y = 2;
        }
        this.sliceValue.setText(x + " x " + y);
        if (go) {
            this.bio.sm.setSliceRange(x, y);
        }
    }
}

